/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.loot.mixin.loottable;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.github.fabricators_of_create.porting_lib.loot.LootCollector;
import io.github.fabricators_of_create.porting_lib.loot.extensions.LootTableBuilderExtensions;
import io.github.fabricators_of_create.porting_lib.loot.extensions.LootTableExtensions;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_52;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_52.class}, priority=50000)
public class LootTableMixin
implements LootTableExtensions {
    @Unique
    private class_2960 lootTableId;

    @Override
    public void setLootTableId(class_2960 id) {
        if (this.lootTableId != null) {
            throw new IllegalStateException("Attempted to rename loot table from '" + this.lootTableId + "' to '" + id + "': this is not supported");
        }
        this.lootTableId = Objects.requireNonNull(id);
    }

    @Override
    public class_2960 getLootTableId() {
        return this.lootTableId;
    }

    @WrapMethod(method={"getRandomItemsRaw(Lnet/minecraft/world/level/storage/loot/LootContext;Ljava/util/function/Consumer;)V"})
    private void finishCollectingLoot(class_47 lootContext, Consumer<class_1799> consumer, Operation<Void> original) {
        LootCollector lootCollector = new LootCollector(consumer);
        original.call(new Object[]{lootContext, lootCollector});
        lootCollector.finish(this.getLootTableId(), lootContext);
    }

    @Mixin(value={class_52.class_53.class})
    public static class BuilderMixin
    implements LootTableBuilderExtensions {
        @Unique
        private class_2960 id;

        @Override
        public void port_lib$setId(class_2960 id) {
            this.id = id;
        }

        @ModifyReturnValue(method={"build"}, at={@At(value="RETURN")})
        private class_52 addId(class_52 table) {
            if (this.id != null) {
                table.setLootTableId(this.id);
            }
            return table;
        }
    }
}

