/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.loot;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.fabricators_of_create.porting_lib.core.util.LamdbaExceptionUtils;
import io.github.fabricators_of_create.porting_lib.loot.IGlobalLootModifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class GlobalLootModifierProvider
implements class_2405 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_7784 output;
    private final String modid;
    private final Map<String, JsonElement> toSerialize = new HashMap<String, JsonElement>();
    private boolean replace = false;

    public GlobalLootModifierProvider(class_7784 output, String modid) {
        this.output = output;
        this.modid = modid;
    }

    protected void replacing() {
        this.replace = true;
    }

    protected abstract void start();

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.start();
        Path forgePath = this.output.method_45972(class_7784.class_7490.field_39367).resolve("forge").resolve("loot_modifiers").resolve("global_loot_modifiers.json");
        Path modifierFolderPath = this.output.method_45972(class_7784.class_7490.field_39367).resolve(this.modid).resolve("loot_modifiers");
        ArrayList entries = new ArrayList();
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        this.toSerialize.forEach(LamdbaExceptionUtils.rethrowBiConsumer((name, json) -> {
            entries.add(new class_2960(this.modid, name));
            Path modifierPath = modifierFolderPath.resolve(name + ".json");
            futuresBuilder.add((Object)class_2405.method_10320((class_7403)cache, (JsonElement)json, (Path)modifierPath));
        }));
        JsonObject forgeJson = new JsonObject();
        forgeJson.addProperty("replace", Boolean.valueOf(this.replace));
        forgeJson.add("entries", GSON.toJsonTree(entries.stream().map(class_2960::toString).collect(Collectors.toList())));
        futuresBuilder.add((Object)class_2405.method_10320((class_7403)cache, (JsonElement)forgeJson, (Path)forgePath));
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    public <T extends IGlobalLootModifier> void add(String modifier, T instance) {
        JsonElement json = (JsonElement)IGlobalLootModifier.DIRECT_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, instance).getOrThrow(false, s -> {});
        this.toSerialize.put(modifier, json);
    }

    public String method_10321() {
        return "Global Loot Modifiers : " + this.modid;
    }
}

