/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.tags.data;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemTagLangProvider
extends FabricLanguageProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemTagLangProvider.class);
    private final Class<?> tagClass;
    private final Map<class_6862<class_1792>, String> specialCases;

    public ItemTagLangProvider(FabricDataOutput output, Class<?> tagClass) {
        this(output, tagClass, Map.of());
    }

    public ItemTagLangProvider(FabricDataOutput output, Class<?> tagClass, Map<class_6862<class_1792>, String> specialCases) {
        super(output);
        this.tagClass = tagClass;
        this.specialCases = specialCases;
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (Field field : this.tagClass.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object o = field.get(null);
                if (!(o instanceof class_6862)) continue;
                class_6862 tag = (class_6862)o;
                class_2960 id = tag.comp_327();
                String path = id.method_12832().replaceAll("/", ".");
                String key = "tag.%s.%s".formatted(id.method_12836(), path);
                String english = this.specialCases.containsKey(tag) ? this.specialCases.get(tag) : ItemTagLangProvider.toEnglish(id.method_12832());
                translationBuilder.add(key, english);
                LOGGER.info("Translated tag [{}] as [{}] with key [{}]", new Object[]{id, english, key});
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String toEnglish(String path) {
        String[] sections = path.split("/");
        StringBuilder result = new StringBuilder();
        for (int i = sections.length - 1; i >= 0; --i) {
            String section = sections[i];
            result.append(ItemTagLangProvider.toSentence(section)).append(" ");
        }
        return result.toString().trim();
    }

    private static String toSentence(String path) {
        return Arrays.stream(path.split("_")).map(ItemTagLangProvider::uppercase).collect(Collectors.joining(" "));
    }

    private static String uppercase(String word) {
        char first = word.charAt(0);
        char upper = Character.toUpperCase(first);
        return upper + word.substring(1);
    }
}

