/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models.generators;

import com.google.common.base.Preconditions;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelProvider;
import net.minecraft.class_2960;

public abstract class ModelFile {
    protected class_2960 location;

    protected ModelFile(class_2960 location) {
        this.location = location;
    }

    protected abstract boolean exists();

    public class_2960 getLocation() {
        this.assertExistence();
        return this.location;
    }

    public void assertExistence() {
        Preconditions.checkState((boolean)this.exists(), (String)"Model at %s does not exist", (Object)this.location);
    }

    public class_2960 getUncheckedLocation() {
        return this.location;
    }

    public static class ExistingModelFile
    extends ModelFile {
        private final ExistingFileHelper existingHelper;

        public ExistingModelFile(class_2960 location, ExistingFileHelper existingHelper) {
            super(location);
            this.existingHelper = existingHelper;
        }

        @Override
        protected boolean exists() {
            if (this.getUncheckedLocation().method_12832().contains(".")) {
                return this.existingHelper.exists(this.getUncheckedLocation(), (ExistingFileHelper.IResourceType)ModelProvider.MODEL_WITH_EXTENSION);
            }
            return this.existingHelper.exists(this.getUncheckedLocation(), (ExistingFileHelper.IResourceType)ModelProvider.MODEL);
        }
    }

    public static class UncheckedModelFile
    extends ModelFile {
        public UncheckedModelFile(String location) {
            this(new class_2960(location));
        }

        public UncheckedModelFile(class_2960 location) {
            super(location);
        }

        @Override
        protected boolean exists() {
            return true;
        }
    }
}

