/*
 * Decompiled with CFR 0.152.
 */
package com.tom.directgpu;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.tom.directgpu.DirectGPUDisplay;
import com.tom.directgpu.DirectGPUManager;
import com.tom.directgpu.DirectGPUMod;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class DirectGPURenderer {
    private static boolean initialized = false;
    private static final Queue<Integer> textureCleanupQueue = new ConcurrentLinkedQueue<Integer>();
    private static Boolean isWindows = null;
    private static boolean calibrationMode = false;
    private static double calibrationDivisor = 3.0;
    private static double calibrationSubtract = 0.33;
    private static final Map<Integer, Long> lastUpdateTime = new ConcurrentHashMap<Integer, Long>();
    private static final long MIN_UPDATE_INTERVAL_MS = 16L;
    private static final int SKIP_EVERY_N_FRAMES = 2;
    private static final Map<Integer, Integer> skipFrameCounter = new ConcurrentHashMap<Integer, Integer>();
    private static long lastRenderTime = System.currentTimeMillis();
    private static boolean wasPaused = false;
    private static final float BEZEL_INSET = 0.12f;
    private static int frameCount = 0;
    private static int skippedUpdates = 0;
    private static long lastStatsLog = System.currentTimeMillis();
    private static long totalRenderTime = 0L;
    private static int renderFrameCount = 0;

    public static void init() {
        if (initialized) {
            return;
        }
        DirectGPURenderer.detectPlatform();
        DirectGPUMod.log("DirectGPU Renderer initialized");
        initialized = true;
    }

    private static void detectPlatform() {
        if (isWindows == null) {
            String os = System.getProperty("os.name").toLowerCase();
            isWindows = os.contains("win");
            DirectGPUMod.log("Platform detected: " + (isWindows != false ? "Windows" : "Linux/Other"));
        }
    }

    public static void setCalibrationMode(boolean enabled, double divisor, double subtract) {
        calibrationMode = enabled;
        calibrationDivisor = divisor;
        calibrationSubtract = subtract;
        if (enabled) {
            DirectGPUMod.log("Calibration mode enabled: divisor=" + divisor + ", subtract=" + subtract);
        } else {
            DirectGPUMod.log("Calibration mode disabled");
        }
    }

    public static double[] getCalibrationValues() {
        return new double[]{calibrationMode ? 1.0 : 0.0, calibrationDivisor, calibrationSubtract};
    }

    private static double getDisplayCenterOffset(int blockSize) {
        if (isWindows == null) {
            DirectGPURenderer.detectPlatform();
        }
        if (calibrationMode) {
            return (double)(blockSize - 1) / calibrationDivisor - calibrationSubtract;
        }
        return (double)(blockSize - 1) / 2.0;
    }

    private static String getWindowsFacing(String facing) {
        if (!isWindows.booleanValue()) {
            return facing;
        }
        switch (facing) {
            case "north": {
                return "south";
            }
            case "south": {
                return "north";
            }
            case "east": {
                return "west";
            }
            case "west": {
                return "east";
            }
            case "up": {
                return "down";
            }
            case "down": {
                return "up";
            }
        }
        return facing;
    }

    private static Vec3 applyWindowsPositionOffset(String facing, double x, double y, double z) {
        if (!isWindows.booleanValue()) {
            return new Vec3(x, y, z);
        }
        switch (facing) {
            case "north": {
                return new Vec3(x + 1.0, y, z);
            }
            case "south": {
                return new Vec3(x - 1.0, y, z);
            }
            case "east": {
                return new Vec3(x, y, z + 1.0);
            }
            case "west": {
                return new Vec3(x, y, z - 1.0);
            }
            case "up": {
                return new Vec3(x + 1.0, y, z);
            }
            case "down": {
                return new Vec3(x + 1.0, y, z);
            }
        }
        return new Vec3(x, y, z);
    }

    public static void tick() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91104_() || mc.f_91080_ != null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastStatsLog > 10000L) {
            long avgRenderTime;
            if (skippedUpdates > 0) {
                DirectGPUMod.log("Performance: Skipped " + skippedUpdates + " texture updates in last 10s");
            }
            if (renderFrameCount > 0 && (avgRenderTime = totalRenderTime / (long)renderFrameCount) > 16L) {
                DirectGPUMod.warn("Average render time: " + avgRenderTime + "ms per frame (causing lag!)");
            }
            skippedUpdates = 0;
            totalRenderTime = 0L;
            renderFrameCount = 0;
            lastStatsLog = now;
        }
    }

    public static void queueTextureCleanup(int textureId) {
        if (textureId != -1) {
            textureCleanupQueue.offer(textureId);
            lastUpdateTime.remove(textureId);
            skipFrameCounter.remove(textureId);
        }
    }

    public static void render(PoseStack poseStack, Camera camera) {
        long renderStartTime;
        block16: {
            Integer textureId;
            int cleaned;
            if (!initialized) {
                return;
            }
            renderStartTime = System.currentTimeMillis();
            Minecraft mc = Minecraft.m_91087_();
            if (mc.m_91104_() || mc.f_91080_ != null) {
                if (!wasPaused) {
                    DirectGPUMod.log("Rendering paused (menu open or game paused)");
                    wasPaused = true;
                }
                return;
            }
            if (wasPaused) {
                DirectGPUMod.log("Rendering resumed");
                wasPaused = false;
            }
            if (!RenderSystem.isOnRenderThread()) {
                if (frameCount % 100 == 0) {
                    DirectGPUMod.warn("render() called from wrong thread!");
                }
                return;
            }
            int maxCleanups = 5;
            for (cleaned = 0; cleaned < maxCleanups && (textureId = textureCleanupQueue.poll()) != null; ++cleaned) {
                DirectGPURenderer.deleteTexture(textureId);
            }
            if (cleaned > 0) {
                DirectGPUMod.log("Cleaned up " + cleaned + " textures");
            }
            long now = System.currentTimeMillis();
            long timeSinceLastRender = now - lastRenderTime;
            lastRenderTime = now;
            if (timeSinceLastRender > 1000L) {
                DirectGPUMod.log("Long pause detected (" + timeSinceLastRender + "ms), skipping frame");
                return;
            }
            try {
                List<DirectGPUDisplay> displays = DirectGPUManager.getAllDisplays();
                int maxRendersPerFrame = displays.size();
                if (timeSinceLastRender > 50L) {
                    maxRendersPerFrame = Math.max(1, displays.size() / 2);
                    DirectGPUMod.warn("Heavy load detected, limiting renders to " + maxRendersPerFrame);
                }
                int renderedCount = 0;
                for (DirectGPUDisplay display : displays) {
                    if (display == null || renderedCount >= maxRendersPerFrame) continue;
                    try {
                        DirectGPURenderer.renderDisplay(poseStack, camera, display, now);
                        ++renderedCount;
                    }
                    catch (Exception e) {
                        if (frameCount % 100 != 0) continue;
                        DirectGPUMod.error("Error rendering display " + display.id + ": " + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                if (frameCount % 100 != 0) break block16;
                DirectGPUMod.error("Error in render loop: " + e.getMessage());
            }
        }
        ++frameCount;
        long renderTime = System.currentTimeMillis() - renderStartTime;
        totalRenderTime += renderTime;
        ++renderFrameCount;
        if (renderTime > 50L) {
            DirectGPUMod.warn("Slow render frame: " + renderTime + "ms");
        }
    }

    private static void renderDisplay(PoseStack poseStack, Camera camera, DirectGPUDisplay display, long currentTime) {
        double centerZ;
        double centerY;
        double centerX;
        if (!DirectGPUManager.displayExists(display.id)) {
            return;
        }
        if (display.textureId == -1) {
            display.textureId = DirectGPURenderer.createTexture(display);
            if (display.textureId == -1) {
                return;
            }
            lastUpdateTime.put(display.textureId, currentTime);
            skipFrameCounter.put(display.textureId, 0);
            display.markClean();
        } else if (display.isDirty()) {
            Integer skipCount = skipFrameCounter.get(display.textureId);
            if (skipCount == null) {
                skipCount = 0;
            }
            Integer n = skipCount;
            skipCount = skipCount + 1;
            skipFrameCounter.put(display.textureId, skipCount);
            if (skipCount >= 2) {
                Long lastUpdate = lastUpdateTime.get(display.textureId);
                if (lastUpdate == null || currentTime - lastUpdate >= 16L) {
                    DirectGPURenderer.updateTexture(display);
                    lastUpdateTime.put(display.textureId, currentTime);
                    skipFrameCounter.put(display.textureId, 0);
                    display.markClean();
                } else {
                    ++skippedUpdates;
                }
            }
        }
        String renderFacing = DirectGPURenderer.getWindowsFacing(display.facing);
        Vec3 cameraPos = camera.m_90583_();
        if (renderFacing.equals("east") || renderFacing.equals("west")) {
            centerX = display.x;
            centerY = (double)display.y + DirectGPURenderer.getDisplayCenterOffset(display.height);
            centerZ = (double)display.z + DirectGPURenderer.getDisplayCenterOffset(display.width);
        } else if (renderFacing.equals("up") || renderFacing.equals("down")) {
            centerX = (double)display.x + DirectGPURenderer.getDisplayCenterOffset(display.width);
            centerY = display.y;
            centerZ = (double)display.z + DirectGPURenderer.getDisplayCenterOffset(display.height);
        } else {
            centerX = (double)display.x + DirectGPURenderer.getDisplayCenterOffset(display.width);
            centerY = (double)display.y + DirectGPURenderer.getDisplayCenterOffset(display.height);
            centerZ = display.z;
        }
        Vec3 adjustedPos = DirectGPURenderer.applyWindowsPositionOffset(display.facing, centerX, centerY, centerZ);
        double worldX = adjustedPos.f_82479_ + 0.5;
        double worldY = adjustedPos.f_82480_ + 0.5;
        double worldZ = adjustedPos.f_82481_ + 0.5;
        double relX = worldX - cameraPos.f_82479_;
        double relY = worldY - cameraPos.f_82480_;
        double relZ = worldZ - cameraPos.f_82481_;
        double distSq = relX * relX + relY * relY + relZ * relZ;
        if (distSq > 4096.0) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(relX, relY, relZ);
        DirectGPURenderer.rotateForFacing(poseStack, renderFacing);
        poseStack.m_85837_(0.0, 0.0, 0.502);
        RenderSystem.enablePolygonOffset();
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (int)display.textureId);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableCull();
        float width = display.width;
        float height = display.height;
        float insetWidth = width - 0.24f;
        float insetHeight = height - 0.24f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float halfWidth = insetWidth / 2.0f;
        float halfHeight = insetHeight / 2.0f;
        bufferBuilder.m_252986_(matrix, -halfWidth, -halfHeight, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, halfWidth, -halfHeight, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, halfWidth, halfHeight, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, -halfWidth, halfHeight, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disablePolygonOffset();
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        poseStack.m_85849_();
    }

    private static void rotateForFacing(PoseStack poseStack, String facing) {
        switch (facing) {
            case "north": {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case "south": {
                break;
            }
            case "east": {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                break;
            }
            case "west": {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case "up": {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                break;
            }
            case "down": {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            }
        }
    }

    private static int createTexture(DirectGPUDisplay display) {
        if (!RenderSystem.isOnRenderThread()) {
            DirectGPUMod.error("createTexture() called from wrong thread!");
            return -1;
        }
        try {
            int textureId = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)textureId);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            byte[] pixelData = display.getPixelsCopy();
            ByteBuffer buffer = ByteBuffer.allocateDirect(pixelData.length);
            buffer.put(pixelData);
            buffer.flip();
            GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)display.getPixelWidth(), (int)display.getPixelHeight(), (int)0, (int)6407, (int)5121, (ByteBuffer)buffer);
            DirectGPUMod.log("Created texture " + textureId + " for display " + display.id + " (" + display.getPixelWidth() + "x" + display.getPixelHeight() + ")");
            return textureId;
        }
        catch (Exception e) {
            DirectGPUMod.error("Failed to create texture for display " + display.id + ": " + e.getMessage());
            return -1;
        }
    }

    private static void updateTexture(DirectGPUDisplay display) {
        block4: {
            if (display.textureId == -1) {
                return;
            }
            if (!RenderSystem.isOnRenderThread()) {
                DirectGPUMod.error("updateTexture() called from wrong thread!");
                return;
            }
            try {
                GL11.glBindTexture((int)3553, (int)display.textureId);
                byte[] pixelData = display.getPixelsCopy();
                ByteBuffer buffer = ByteBuffer.allocateDirect(pixelData.length);
                buffer.put(pixelData);
                buffer.flip();
                GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)display.getPixelWidth(), (int)display.getPixelHeight(), (int)6407, (int)5121, (ByteBuffer)buffer);
            }
            catch (Exception e) {
                if (frameCount % 100 != 0) break block4;
                DirectGPUMod.error("Failed to update texture for display " + display.id + ": " + e.getMessage());
            }
        }
    }

    private static void deleteTexture(int textureId) {
        if (textureId != -1) {
            try {
                GL11.glDeleteTextures((int)textureId);
                DirectGPUMod.log("Deleted texture " + textureId);
            }
            catch (Exception e) {
                DirectGPUMod.error("Failed to delete texture " + textureId + ": " + e.getMessage());
            }
        }
    }
}

