/*
 * Decompiled with CFR 0.152.
 */
package com.tom.directgpu;

import com.tom.directgpu.DirectGPUBlockEntity;
import com.tom.directgpu.DirectGPUMod;
import com.tom.directgpu.DirectGPUPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;

public class DirectGPUPeripheralProvider
implements IPeripheralProvider {
    private static final Map<BlockPos, PeripheralWrapper> peripheralCache = new HashMap<BlockPos, PeripheralWrapper>();

    @Nonnull
    public LazyOptional<IPeripheral> getPeripheral(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof DirectGPUBlockEntity) {
            DirectGPUMod.log("Peripheral requested for DirectGPU block at " + pos + " (side: " + side + ")");
            PeripheralWrapper wrapper = peripheralCache.get(pos);
            if (wrapper == null || !wrapper.isValid()) {
                DirectGPUMod.log("Creating new DirectGPU peripheral at " + pos);
                DirectGPUPeripheral peripheral = new DirectGPUPeripheral(pos, world);
                LazyOptional optional = LazyOptional.of(() -> peripheral);
                optional.addListener(opt -> {
                    DirectGPUMod.log("Peripheral invalidated at " + pos);
                    peripheral.cleanup();
                    peripheralCache.remove(pos);
                });
                wrapper = new PeripheralWrapper(peripheral, (LazyOptional<IPeripheral>)optional);
                peripheralCache.put(pos, wrapper);
            } else {
                DirectGPUMod.log("Returning cached peripheral at " + pos);
            }
            return wrapper.optional;
        }
        return LazyOptional.empty();
    }

    private static class PeripheralWrapper {
        final DirectGPUPeripheral peripheral;
        final LazyOptional<IPeripheral> optional;

        PeripheralWrapper(DirectGPUPeripheral peripheral, LazyOptional<IPeripheral> optional) {
            this.peripheral = peripheral;
            this.optional = optional;
        }

        boolean isValid() {
            return this.optional.isPresent();
        }
    }
}

