/*
 * Decompiled with CFR 0.152.
 */
package com.tom.directgpu;

import com.tom.directgpu.DirectGPUCleanupManager;
import com.tom.directgpu.DirectGPUDictionary;
import com.tom.directgpu.DirectGPUDisplay;
import com.tom.directgpu.DirectGPUImageDecoder;
import com.tom.directgpu.DirectGPUInputHandler;
import com.tom.directgpu.DirectGPUKeyboardBridge;
import com.tom.directgpu.DirectGPUManager;
import com.tom.directgpu.DirectGPUMod;
import com.tom.directgpu.DirectGPURenderer;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class DirectGPUPeripheral
implements IPeripheral {
    private final BlockPos pos;
    private final Level world;
    private final String computerKey;

    public DirectGPUPeripheral(BlockPos pos, Level world) {
        this.pos = pos;
        this.world = world;
        this.computerKey = DirectGPUCleanupManager.makeComputerKey(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        DirectGPUMod.log("DirectGPU Peripheral created at " + pos);
    }

    @Nonnull
    public String getType() {
        return "directgpu";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }

    public void cleanup() {
        DirectGPUMod.log("Cleaning up DirectGPU peripheral at " + this.pos);
        DirectGPUCleanupManager.clearAllForComputer(this.computerKey);
    }

    @LuaFunction
    public final int createDisplay(int x, int y, int z, String facing, int width, int height) throws LuaException {
        return this.createDisplayWithResolution(x, y, z, facing, width, height, 1);
    }

    @LuaFunction
    public final int createDisplayAt(int x, int y, int z, String facing, int width, int height) throws LuaException {
        return this.createDisplayWithResolution(x, y, z, facing, width, height, 1);
    }

    @LuaFunction
    public final int createDisplayWithResolution(int x, int y, int z, String facing, int width, int height, int resolutionMultiplier) throws LuaException {
        try {
            if (width <= 0 || width > 16) {
                throw new LuaException("Width must be between 1 and 16");
            }
            if (height <= 0 || height > 16) {
                throw new LuaException("Height must be between 1 and 16");
            }
            if (resolutionMultiplier < 1 || resolutionMultiplier > 4) {
                throw new LuaException("Resolution multiplier must be between 1 and 4");
            }
            String[] validFacings = new String[]{"north", "south", "east", "west", "up", "down"};
            boolean validFacing = false;
            for (String f : validFacings) {
                if (!f.equalsIgnoreCase(facing)) continue;
                validFacing = true;
                break;
            }
            if (!validFacing) {
                throw new LuaException("Invalid facing. Must be: north, south, east, west, up, or down");
            }
            int displayId = DirectGPUManager.createDisplay(x, y, z, facing, width, height, resolutionMultiplier);
            if (displayId == -1) {
                throw new LuaException("Failed to create display - check resource limits");
            }
            DirectGPUCleanupManager.registerDisplay(this.computerKey, displayId);
            return displayId;
        }
        catch (LuaException e) {
            throw e;
        }
        catch (Exception e) {
            DirectGPUMod.error("createDisplay error: " + e.getMessage());
            throw new LuaException("Failed to create display: " + e.getMessage());
        }
    }

    @LuaFunction
    public final boolean removeDisplay(int displayId) throws LuaException {
        try {
            boolean result = DirectGPUManager.removeDisplay(displayId);
            if (result) {
                DirectGPUMod.log("Display " + displayId + " removed by Lua");
            }
            return result;
        }
        catch (Exception e) {
            throw new LuaException("Failed to remove display: " + e.getMessage());
        }
    }

    @LuaFunction
    public final List<Integer> listDisplays() {
        return DirectGPUManager.listDisplays();
    }

    @LuaFunction
    public final Map<String, Object> getDisplayInfo(int displayId) throws LuaException {
        DirectGPUDisplay display = DirectGPUManager.getDisplay(displayId);
        if (display == null) {
            throw new LuaException("Display " + displayId + " does not exist");
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("id", display.id);
        info.put("x", display.x);
        info.put("y", display.y);
        info.put("z", display.z);
        info.put("facing", display.facing);
        info.put("width", display.width);
        info.put("height", display.height);
        info.put("pixelWidth", display.getPixelWidth());
        info.put("pixelHeight", display.getPixelHeight());
        info.put("resolutionMultiplier", display.resolutionMultiplier);
        return info;
    }

    @LuaFunction
    public final void clearAllDisplays() {
        DirectGPUCleanupManager.clearAllForComputer(this.computerKey);
    }

    @LuaFunction
    public final Map<String, Object> getResourceStats() {
        return DirectGPUManager.getResourceStats();
    }

    @LuaFunction
    public final void setPixel(int displayId, int x, int y, int r, int g, int b) throws LuaException {
        DirectGPUDisplay display = DirectGPUManager.getDisplay(displayId);
        if (display == null) {
            throw new LuaException("Display " + displayId + " does not exist");
        }
        display.setPixel(x, y, r, g, b);
    }

    @LuaFunction
    public final int[] getPixel(int displayId, int x, int y) throws LuaException {
        DirectGPUDisplay display = DirectGPUManager.getDisplay(displayId);
        if (display == null) {
            throw new LuaException("Display " + displayId + " does not exist");
        }
        return display.getPixel(x, y);
    }

    @LuaFunction
    public final void clear(int displayId, int r, int g, int b) throws LuaException {
        DirectGPUDisplay display = DirectGPUManager.getDisplay(displayId);
        if (display == null) {
            throw new LuaException("Display " + displayId + " does not exist");
        }
        display.clear(r, g, b);
    }

    @LuaFunction
    public final void fillRect(int displayId, int x, int y, int w, int h, int r, int g, int b) throws LuaException {
        DirectGPUDisplay display = DirectGPUManager.getDisplay(displayId);
        if (display == null) {
            throw new LuaException("Display " + displayId + " does not exist");
        }
        display.fillRect(x, y, w, h, r, g, b);
    }

    @LuaFunction
    public final void drawLine(int displayId, int x1, int y1, int x2, int y2, int r, int g, int b) throws LuaException {
        DirectGPUDisplay display = DirectGPUManager.getDisplay(displayId);
        if (display == null) {
            throw new LuaException("Display " + displayId + " does not exist");
        }
        display.drawLine(x1, y1, x2, y2, r, g, b);
    }

    @LuaFunction
    public final void updateDisplay(int displayId) throws LuaException {
        DirectGPUDisplay display = DirectGPUManager.getDisplay(displayId);
        if (display == null) {
            throw new LuaException("Display " + displayId + " does not exist");
        }
        display.markDirty();
    }

    @LuaFunction
    public final void loadImage(int displayId, Map<?, ?> imageData) throws LuaException {
        try {
            DirectGPUDisplay display = DirectGPUManager.getDisplay(displayId);
            if (display == null) {
                throw new LuaException("Display " + displayId + " does not exist");
            }
            display.loadImageFromDict(imageData);
        }
        catch (LuaException e) {
            throw e;
        }
        catch (Exception e) {
            DirectGPUMod.error("loadImage error: " + e.getMessage());
            throw new LuaException("Failed to load image: " + e.getMessage());
        }
    }

    @LuaFunction
    public final void loadJPEGRegion(int displayId, String jpegBinaryData, int x, int y, int w, int h) throws LuaException {
        DirectGPUDisplay display = DirectGPUManager.getDisplay(displayId);
        if (display == null) {
            throw new LuaException("Display not found");
        }
        if (w <= 0 || h <= 0) {
            throw new LuaException("Width and height must be positive");
        }
        try {
            byte[] jpegData = jpegBinaryData.getBytes("ISO-8859-1");
            Map<String, Object> result = DirectGPUImageDecoder.decodeAndScaleJPEG(jpegData, w, h);
            byte[] scaledPixels = (byte[])result.get("pixels");
            this.blitFlatPixelsToDisplay(display, scaledPixels, w, h, x, y);
        }
        catch (Exception e) {
            throw new LuaException("Failed to load JPEG to region: " + e.getMessage());
        }
    }

    @LuaFunction
    public final Map<String, Object> decodeJPEG(byte[] jpegData) throws LuaException {
        try {
            return DirectGPUImageDecoder.decodeJPEG(jpegData);
        }
        catch (Exception e) {
            DirectGPUMod.error("decodeJPEG error: " + e.getMessage());
            throw new LuaException("Failed to decode JPEG: " + e.getMessage());
        }
    }

    @LuaFunction
    public final Map<String, Object> decodeAndScaleJPEG(byte[] jpegData, int targetWidth, int targetHeight) throws LuaException {
        try {
            return DirectGPUImageDecoder.decodeAndScaleJPEG(jpegData, targetWidth, targetHeight);
        }
        catch (Exception e) {
            DirectGPUMod.error("decodeAndScaleJPEG error: " + e.getMessage());
            throw new LuaException("Failed to decode and scale JPEG: " + e.getMessage());
        }
    }

    @LuaFunction
    public final Map<String, Object> getJPEGDimensions(byte[] jpegData) throws LuaException {
        try {
            return DirectGPUImageDecoder.getJPEGDimensions(jpegData);
        }
        catch (Exception e) {
            throw new LuaException("Failed to get JPEG dimensions: " + e.getMessage());
        }
    }

    @LuaFunction
    public final Map<String, Object> compressWithDict(byte[] data) throws LuaException {
        try {
            return DirectGPUDictionary.compressWithDict(data);
        }
        catch (Exception e) {
            throw new LuaException("Failed to compress with dictionary: " + e.getMessage());
        }
    }

    @LuaFunction
    public final byte[] decompressFromDict(long[] hashes) throws LuaException {
        try {
            return DirectGPUDictionary.decompressFromDict(hashes);
        }
        catch (Exception e) {
            throw new LuaException("Failed to decompress from dictionary: " + e.getMessage());
        }
    }

    @LuaFunction
    public final boolean hasChunk(long hash) {
        return DirectGPUDictionary.hasChunk(hash);
    }

    @LuaFunction
    public final byte[] getChunk(long hash) throws LuaException {
        byte[] chunk = DirectGPUDictionary.getChunk(hash);
        if (chunk == null) {
            throw new LuaException("Chunk not found: " + hash);
        }
        return chunk;
    }

    @LuaFunction
    public final Map<String, Object> getDictionaryStats() {
        return DirectGPUDictionary.getStats();
    }

    @LuaFunction
    public final void clearDictionary() {
        DirectGPUDictionary.clear();
    }

    @LuaFunction
    public final boolean hasEvents(int displayId) throws LuaException {
        if (!DirectGPUManager.displayExists(displayId)) {
            throw new LuaException("Display " + displayId + " does not exist");
        }
        return DirectGPUInputHandler.hasEvents(displayId);
    }

    @LuaFunction
    public final Map<String, Object> pollEvent(int displayId) throws LuaException {
        if (!DirectGPUManager.displayExists(displayId)) {
            throw new LuaException("Display " + displayId + " does not exist");
        }
        DirectGPUInputHandler.DisplayInputEvent event = DirectGPUInputHandler.pollEvent(displayId);
        if (event == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("type", event.type);
        result.put("x", event.x);
        result.put("y", event.y);
        result.put("button", event.button);
        if (event.key != null) {
            result.put("key", event.key);
        }
        if (event.character != null) {
            result.put("character", event.character);
        }
        return result;
    }

    @LuaFunction
    public final void clearEvents(int displayId) throws LuaException {
        if (!DirectGPUManager.displayExists(displayId)) {
            throw new LuaException("Display " + displayId + " does not exist");
        }
        DirectGPUInputHandler.clearEvents(displayId);
    }

    @LuaFunction
    public final void sendKeyEvent(int displayId, String type, String key, String character) throws LuaException {
        if (!DirectGPUManager.displayExists(displayId)) {
            throw new LuaException("Display " + displayId + " does not exist");
        }
        DirectGPUKeyboardBridge.queueKeyEvent(displayId, type, key, character);
    }

    @LuaFunction
    public final void setCalibrationMode(boolean enabled, double divisor, double subtract) throws LuaException {
        if (divisor <= 0.0) {
            throw new LuaException("Divisor must be greater than 0");
        }
        DirectGPURenderer.setCalibrationMode(enabled, divisor, subtract);
    }

    @LuaFunction
    public final Map<String, Object> getCalibrationValues() {
        double[] values = DirectGPURenderer.getCalibrationValues();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("enabled", values[0] > 0.0);
        result.put("divisor", values[1]);
        result.put("subtract", values[2]);
        return result;
    }

    @LuaFunction
    public final Map<String, Object> autoDetectMonitor() throws LuaException {
        try {
            DirectGPUMod.log("=== AUTO DETECT START ===");
            DirectGPUMod.log("Computer at: " + this.pos);
            BlockPos closestMonitor = null;
            double closestDist = Double.MAX_VALUE;
            for (int dx = -16; dx <= 16; ++dx) {
                for (int dy = -16; dy <= 16; ++dy) {
                    for (int dz = -16; dz <= 16; ++dz) {
                        double dist;
                        BlockPos checkPos = this.pos.m_7918_(dx, dy, dz);
                        if (!this.isMonitorBlock(checkPos) || !((dist = Math.sqrt(dx * dx + dy * dy + dz * dz)) < closestDist)) continue;
                        closestDist = dist;
                        closestMonitor = checkPos;
                        DirectGPUMod.log("Found monitor at: " + checkPos + " (distance: " + dist + ")");
                    }
                }
            }
            if (closestMonitor == null) {
                DirectGPUMod.log("No monitor found within 16 blocks");
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("found", false);
                return result;
            }
            DirectGPUMod.log("Closest monitor: " + closestMonitor);
            MonitorInfo info = this.detectMonitorSize(closestMonitor);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("found", true);
            result.put("x", info.x);
            result.put("y", info.y);
            result.put("z", info.z);
            result.put("width", info.width);
            result.put("height", info.height);
            result.put("facing", info.facing);
            DirectGPUMod.log("=== AUTO DETECT END ===");
            return result;
        }
        catch (Exception e) {
            DirectGPUMod.error("Monitor detection failed: " + e.getMessage());
            e.printStackTrace();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("found", false);
            return result;
        }
    }

    @LuaFunction
    public final int autoDetectAndCreateDisplay() throws LuaException {
        return this.autoDetectAndCreateDisplayWithResolution(1);
    }

    @LuaFunction
    public final int autoDetectAndCreateDisplayWithResolution(int resolutionMultiplier) throws LuaException {
        try {
            Map<String, Object> monitorInfo = this.autoDetectMonitor();
            if (!((Boolean)monitorInfo.get("found")).booleanValue()) {
                throw new LuaException("No monitor found within 16 blocks");
            }
            int x = ((Number)monitorInfo.get("x")).intValue();
            int y = ((Number)monitorInfo.get("y")).intValue();
            int z = ((Number)monitorInfo.get("z")).intValue();
            int width = ((Number)monitorInfo.get("width")).intValue();
            int height = ((Number)monitorInfo.get("height")).intValue();
            String facing = (String)monitorInfo.get("facing");
            DirectGPUMod.log("Auto-creating display with " + resolutionMultiplier + "x resolution multiplier");
            return this.createDisplayWithResolution(x, y, z, facing, width, height, resolutionMultiplier);
        }
        catch (LuaException e) {
            throw e;
        }
        catch (Exception e) {
            DirectGPUMod.error("Auto-detect and create failed: " + e.getMessage());
            throw new LuaException("Failed to auto-detect and create display: " + e.getMessage());
        }
    }

    private void blitFlatPixelsToDisplay(DirectGPUDisplay display, byte[] srcPixels, int srcW, int srcH, int destX, int destY) {
        byte[] displayPixels = display.getPixels();
        for (int y = 0; y < srcH; ++y) {
            int dstY = destY + y;
            if (dstY < 0 || dstY >= display.getPixelHeight()) continue;
            for (int x = 0; x < srcW; ++x) {
                int dstX = destX + x;
                if (dstX < 0 || dstX >= display.getPixelWidth()) continue;
                int srcIndex = (y * srcW + x) * 3;
                int dstIndex = (dstY * display.getPixelWidth() + dstX) * 3;
                if (srcIndex + 2 >= srcPixels.length || dstIndex + 2 >= displayPixels.length) continue;
                displayPixels[dstIndex] = srcPixels[srcIndex];
                displayPixels[dstIndex + 1] = srcPixels[srcIndex + 1];
                displayPixels[dstIndex + 2] = srcPixels[srcIndex + 2];
            }
        }
    }

    private boolean isMonitorBlock(BlockPos pos) {
        try {
            BlockState state = this.world.m_8055_(pos);
            String name = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString();
            boolean isMonitor = name.contains("monitor") && (name.contains("computercraft") || name.contains("cc:"));
            return isMonitor;
        }
        catch (Exception e) {
            return false;
        }
    }

    private MonitorInfo detectMonitorSize(BlockPos start) {
        DirectGPUMod.log("=== MONITOR SIZE DETECTION ===");
        DirectGPUMod.log("Starting from: " + start);
        Direction facing = Direction.NORTH;
        try {
            BlockState state = this.world.m_8055_(start);
            if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            }
        }
        catch (Exception state) {
            // empty catch block
        }
        DirectGPUMod.log("Monitor facing: " + facing.m_122433_());
        BlockPos pos = start;
        while (this.isMonitorBlock(pos.m_7495_())) {
            pos = pos.m_7495_();
        }
        DirectGPUMod.log("Bottom: " + pos);
        switch (facing) {
            case NORTH: {
                while (this.isMonitorBlock(pos.m_122029_())) {
                    pos = pos.m_122029_();
                }
                break;
            }
            case SOUTH: {
                while (this.isMonitorBlock(pos.m_122024_())) {
                    pos = pos.m_122024_();
                }
                break;
            }
            case EAST: {
                while (this.isMonitorBlock(pos.m_122019_())) {
                    pos = pos.m_122019_();
                }
                break;
            }
            case WEST: {
                while (this.isMonitorBlock(pos.m_122012_())) {
                    pos = pos.m_122012_();
                }
                break;
            }
        }
        BlockPos origin = pos;
        DirectGPUMod.log("Origin (bottom-left): " + origin);
        int width = 0;
        int height = 0;
        BlockPos testPos = origin;
        switch (facing) {
            case NORTH: {
                while (width < 8 && this.isMonitorBlock(testPos)) {
                    ++width;
                    testPos = testPos.m_122024_();
                }
                break;
            }
            case SOUTH: {
                while (width < 8 && this.isMonitorBlock(testPos)) {
                    ++width;
                    testPos = testPos.m_122029_();
                }
                break;
            }
            case EAST: {
                while (width < 8 && this.isMonitorBlock(testPos)) {
                    ++width;
                    testPos = testPos.m_122012_();
                }
                break;
            }
            case WEST: {
                while (width < 8 && this.isMonitorBlock(testPos)) {
                    ++width;
                    testPos = testPos.m_122019_();
                }
                break;
            }
        }
        testPos = origin;
        while (height < 6 && this.isMonitorBlock(testPos)) {
            ++height;
            testPos = testPos.m_7494_();
        }
        DirectGPUMod.log("Detected size: " + width + "x" + height);
        HashSet<BlockPos> validatedBlocks = new HashSet<BlockPos>();
        boolean allValid = true;
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                BlockPos checkPos = switch (facing) {
                    case Direction.NORTH -> origin.m_7918_(-w, h, 0);
                    case Direction.SOUTH -> origin.m_7918_(w, h, 0);
                    case Direction.EAST -> origin.m_7918_(0, h, -w);
                    case Direction.WEST -> origin.m_7918_(0, h, w);
                    default -> origin.m_7918_(w, h, 0);
                };
                if (!this.isMonitorBlock(checkPos)) {
                    DirectGPUMod.warn("Missing monitor block at: " + checkPos);
                    allValid = false;
                    break;
                }
                validatedBlocks.add(checkPos);
            }
            if (!allValid) break;
        }
        if (!allValid) {
            DirectGPUMod.warn("Monitor array is not a complete rectangle!");
        }
        DirectGPUMod.log("Validated " + validatedBlocks.size() + " monitor blocks");
        int cx = origin.m_123341_();
        int cy = origin.m_123342_();
        int cz = origin.m_123343_();
        String flippedFacing = switch (facing) {
            case Direction.NORTH -> "south";
            case Direction.SOUTH -> "north";
            case Direction.EAST -> "west";
            case Direction.WEST -> "east";
            default -> facing.m_122433_().toLowerCase();
        };
        DirectGPUMod.log("Final - Size: " + width + "x" + height + " | Origin: (" + cx + "," + cy + "," + cz + ") | Detected Facing: " + facing.m_122433_() + " | Flipped to: " + flippedFacing);
        DirectGPUMod.log("=== DETECTION COMPLETE ===");
        return new MonitorInfo(cx, cy, cz, width, height, flippedFacing);
    }

    private static class MonitorInfo {
        final int x;
        final int y;
        final int z;
        final int width;
        final int height;
        final String facing;

        MonitorInfo(int x, int y, int z, int w, int h, String f) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.width = w;
            this.height = h;
            this.facing = f;
        }
    }
}

