/*
 * Decompiled with CFR 0.152.
 */
package com.tom.directgpu;

import com.tom.directgpu.DirectGPUCreativeTabs;
import com.tom.directgpu.DirectGPUInputHandler;
import com.tom.directgpu.DirectGPURegistry;
import com.tom.directgpu.DirectGPURenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="directgpu")
public class DirectGPUMod {
    public static final String MOD_ID = "directgpu";

    public DirectGPUMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DirectGPURegistry.BLOCKS.register(modEventBus);
        DirectGPURegistry.ITEMS.register(modEventBus);
        DirectGPURegistry.BLOCK_ENTITIES.register(modEventBus);
        DirectGPUCreativeTabs.register(modEventBus);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DirectGPUInputHandler());
        DirectGPUMod.log("DirectGPU mod constructor called");
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DirectGPUMod.log("========================================");
            DirectGPUMod.log("DirectGPU Setup Starting...");
            DirectGPUMod.log("GPU Block registered!");
            DirectGPUMod.log("Peripheral integration via Forge Capabilities");
            DirectGPUMod.log("Setup complete!");
            DirectGPUMod.log("========================================");
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            DirectGPUMod.log("Client setup - initializing renderer...");
            DirectGPURenderer.init();
            DirectGPUMod.log("Renderer initialized!");
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            DirectGPURenderer.tick();
            DirectGPUInputHandler.handleMouseMove();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            DirectGPURenderer.render(event.getPoseStack(), event.getCamera());
        }
    }

    public static void log(String message) {
        System.out.println("[DirectGPU] " + message);
    }

    public static void error(String message) {
        System.err.println("[DirectGPU ERROR] " + message);
    }

    public static void warn(String message) {
        System.err.println("[DirectGPU WARN] " + message);
    }
}

