/*
 * Decompiled with CFR 0.152.
 */
package com.tom.directgpu;

import com.tom.directgpu.DirectGPUDisplay;
import com.tom.directgpu.DirectGPUInputHandler;
import com.tom.directgpu.DirectGPUKeyboardBridge;
import com.tom.directgpu.DirectGPUMod;
import com.tom.directgpu.DirectGPURenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DirectGPUManager {
    private static final ConcurrentHashMap<Integer, DirectGPUDisplay> displays = new ConcurrentHashMap();
    private static final AtomicInteger nextId = new AtomicInteger(0);
    private static final int MAX_DISPLAYS = 50;
    private static final long MAX_TOTAL_PIXELS = 10000000L;
    private static long lastResourceWarning = 0L;

    public static int createDisplay(int x, int y, int z, String facing, int width, int height, int resolutionMultiplier) {
        try {
            long now;
            long newPixels;
            if (displays.size() >= 50) {
                DirectGPUMod.error("Cannot create display: maximum of 50 displays reached");
                return -1;
            }
            int pixelsPerBlockW = 164 * resolutionMultiplier;
            int pixelsPerBlockH = 81 * resolutionMultiplier;
            long currentPixels = DirectGPUManager.getTotalPixelCount();
            if (currentPixels + (newPixels = (long)width * (long)pixelsPerBlockW * (long)height * (long)pixelsPerBlockH) > 10000000L) {
                DirectGPUMod.error("Cannot create display: would exceed maximum total pixels (10000000). Current: " + currentPixels + ", New: " + newPixels);
                return -1;
            }
            int id = nextId.getAndIncrement();
            DirectGPUDisplay display = new DirectGPUDisplay(id, x, y, z, facing, width, height, resolutionMultiplier);
            displays.put(id, display);
            DirectGPUMod.log("Created display " + id + " at (" + x + "," + y + "," + z + ") " + width + "x" + height + " facing " + facing + " [" + display.getPixelWidth() + "x" + display.getPixelHeight() + " pixels, " + resolutionMultiplier + "x multiplier]");
            long totalPixels = DirectGPUManager.getTotalPixelCount();
            if ((double)totalPixels > 8000000.0 && (now = System.currentTimeMillis()) - lastResourceWarning > 30000L) {
                DirectGPUMod.warn("High pixel usage: " + totalPixels + "/10000000 (" + totalPixels * 100L / 10000000L + "%)");
                lastResourceWarning = now;
            }
            return id;
        }
        catch (Exception e) {
            DirectGPUMod.error("Failed to create display: " + e.getMessage());
            e.printStackTrace();
            return -1;
        }
    }

    public static int createDisplay(int x, int y, int z, String facing, int width, int height) {
        return DirectGPUManager.createDisplay(x, y, z, facing, width, height, 1);
    }

    public static boolean removeDisplay(int id) {
        try {
            DirectGPUDisplay display = displays.remove(id);
            if (display != null) {
                if (display.textureId != -1) {
                    DirectGPURenderer.queueTextureCleanup(display.textureId);
                }
                DirectGPUInputHandler.removeDisplayEvents(id);
                DirectGPUKeyboardBridge.clearKeyEvents(id);
                DirectGPUMod.log("Removed display " + id);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            DirectGPUMod.error("Failed to remove display " + id + ": " + e.getMessage());
            return false;
        }
    }

    public static DirectGPUDisplay getDisplay(int id) {
        try {
            return displays.get(id);
        }
        catch (Exception e) {
            DirectGPUMod.error("Failed to get display " + id + ": " + e.getMessage());
            return null;
        }
    }

    public static List<DirectGPUDisplay> getAllDisplays() {
        try {
            return new ArrayList<DirectGPUDisplay>(displays.values());
        }
        catch (Exception e) {
            DirectGPUMod.error("Failed to get all displays: " + e.getMessage());
            return new ArrayList<DirectGPUDisplay>();
        }
    }

    public static List<Integer> listDisplays() {
        try {
            return new ArrayList<Integer>(displays.keySet());
        }
        catch (Exception e) {
            DirectGPUMod.error("Failed to list displays: " + e.getMessage());
            return new ArrayList<Integer>();
        }
    }

    public static int getDisplayCount() {
        return displays.size();
    }

    public static long getTotalPixelCount() {
        try {
            long total = 0L;
            for (DirectGPUDisplay display : displays.values()) {
                total += (long)display.getPixelWidth() * (long)display.getPixelHeight();
            }
            return total;
        }
        catch (Exception e) {
            DirectGPUMod.error("Failed to count pixels: " + e.getMessage());
            return 0L;
        }
    }

    public static void clearAll() {
        try {
            DirectGPUMod.log("Clearing all displays (" + displays.size() + " total)");
            ArrayList displayIds = new ArrayList(displays.keySet());
            for (Integer id : displayIds) {
                DirectGPUManager.removeDisplay(id);
            }
            displays.clear();
            DirectGPUMod.log("All displays cleared");
        }
        catch (Exception e) {
            DirectGPUMod.error("Failed to clear all displays: " + e.getMessage());
        }
    }

    public static boolean displayExists(int id) {
        return displays.containsKey(id);
    }

    public static Map<String, Object> getResourceStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("displays", DirectGPUManager.getDisplayCount());
        stats.put("maxDisplays", 50);
        stats.put("totalPixels", DirectGPUManager.getTotalPixelCount());
        stats.put("maxTotalPixels", 10000000L);
        stats.put("pixelUsagePercent", (double)DirectGPUManager.getTotalPixelCount() * 100.0 / 1.0E7);
        return stats;
    }
}

