/*
 * Decompiled with CFR 0.152.
 */
package com.tom.directgpu;

import com.tom.directgpu.DirectGPUInputHandler;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DirectGPUKeyboardBridge {
    private static final Map<Integer, Queue<KeyEvent>> keyEventQueues = new ConcurrentHashMap<Integer, Queue<KeyEvent>>();

    public static void queueKeyEvent(int displayId, String type, String key, String character) {
        KeyEvent event = new KeyEvent();
        event.type = type;
        event.key = key;
        event.character = character;
        keyEventQueues.computeIfAbsent(displayId, k -> new ConcurrentLinkedQueue()).offer(event);
        DirectGPUInputHandler.DisplayInputEvent inputEvent = new DirectGPUInputHandler.DisplayInputEvent();
        inputEvent.type = type;
        inputEvent.displayId = displayId;
        inputEvent.key = key;
        inputEvent.character = character;
        DirectGPUInputHandler.queueEvent(displayId, inputEvent);
    }

    public static KeyEvent pollKeyEvent(int displayId) {
        Queue<KeyEvent> queue = keyEventQueues.get(displayId);
        return queue != null ? queue.poll() : null;
    }

    public static boolean hasKeyEvents(int displayId) {
        Queue<KeyEvent> queue = keyEventQueues.get(displayId);
        return queue != null && !queue.isEmpty();
    }

    public static void clearKeyEvents(int displayId) {
        Queue<KeyEvent> queue = keyEventQueues.get(displayId);
        if (queue != null) {
            queue.clear();
        }
    }

    public static class KeyEvent {
        public String type;
        public String key;
        public String character;
    }
}

