/*
 * Decompiled with CFR 0.152.
 */
package com.tom.directgpu;

import com.tom.directgpu.DirectGPUDisplay;
import com.tom.directgpu.DirectGPUManager;
import com.tom.directgpu.DirectGPUMod;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DirectGPUInputHandler {
    private static final Map<Integer, Queue<DisplayInputEvent>> eventQueues = new ConcurrentHashMap<Integer, Queue<DisplayInputEvent>>();
    private static final int MAX_QUEUE_SIZE = 100;
    private static Integer draggedDisplayId = null;
    private static boolean isLeftDragging = false;
    private static boolean isRightDragging = false;
    private static int lastDragX = -1;
    private static int lastDragY = -1;
    private static long lastMouseMoveTime = 0L;
    private static final long MOUSE_MOVE_THROTTLE_MS = 16L;

    @SubscribeEvent
    public void onMouseClick(InputEvent.MouseButton.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        if (mc.f_91080_ != null || mc.m_91104_()) {
            if (draggedDisplayId != null) {
                DirectGPUInputHandler.resetDragState();
            }
            return;
        }
        try {
            Camera camera = mc.f_91063_.m_109153_();
            RaycastResult result = DirectGPUInputHandler.raycastDisplays(camera);
            if (result != null) {
                DirectGPUDisplay display = DirectGPUManager.getDisplay(result.displayId);
                if (display == null) {
                    if (draggedDisplayId != null && draggedDisplayId == result.displayId) {
                        DirectGPUInputHandler.resetDragState();
                    }
                    return;
                }
                event.setCanceled(true);
                int button = event.getButton();
                int action = event.getAction();
                if (action == 1) {
                    DisplayInputEvent inputEvent = new DisplayInputEvent();
                    inputEvent.type = button == 1 ? "mouse_click_right" : "mouse_click";
                    inputEvent.displayId = result.displayId;
                    inputEvent.x = result.pixelX;
                    inputEvent.y = result.pixelY;
                    inputEvent.button = button + 1;
                    DirectGPUInputHandler.queueEvent(result.displayId, inputEvent);
                    draggedDisplayId = result.displayId;
                    if (button == 0) {
                        isLeftDragging = true;
                    } else if (button == 1) {
                        isRightDragging = true;
                    }
                    lastDragX = result.pixelX;
                    lastDragY = result.pixelY;
                } else {
                    DisplayInputEvent inputEvent = new DisplayInputEvent();
                    inputEvent.type = button == 1 ? "mouse_up_right" : "mouse_up";
                    inputEvent.displayId = result.displayId;
                    inputEvent.x = result.pixelX;
                    inputEvent.y = result.pixelY;
                    inputEvent.button = button + 1;
                    DirectGPUInputHandler.queueEvent(result.displayId, inputEvent);
                    if (button == 0) {
                        isLeftDragging = false;
                    } else if (button == 1) {
                        isRightDragging = false;
                    }
                    if (!isLeftDragging && !isRightDragging) {
                        draggedDisplayId = null;
                    }
                }
            }
        }
        catch (Exception e) {
            DirectGPUMod.error("Error in mouse click handler: " + e.getMessage());
            DirectGPUInputHandler.resetDragState();
        }
    }

    public static void handleMouseMove() {
        if (draggedDisplayId == null || !isLeftDragging && !isRightDragging) {
            return;
        }
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null || mc.f_91074_ == null) {
                return;
            }
            if (mc.f_91080_ != null || mc.m_91104_()) {
                DirectGPUInputHandler.resetDragState();
                return;
            }
            long now = System.currentTimeMillis();
            if (now - lastMouseMoveTime < 16L) {
                return;
            }
            lastMouseMoveTime = now;
            DirectGPUDisplay display = DirectGPUManager.getDisplay(draggedDisplayId);
            if (display == null) {
                DirectGPUInputHandler.resetDragState();
                return;
            }
            Camera camera = mc.f_91063_.m_109153_();
            RaycastResult result = DirectGPUInputHandler.raycastDisplays(camera);
            if (result != null && result.displayId == draggedDisplayId && (result.pixelX != lastDragX || result.pixelY != lastDragY)) {
                DisplayInputEvent inputEvent = new DisplayInputEvent();
                inputEvent.type = isRightDragging ? "mouse_drag_right" : "mouse_drag";
                inputEvent.displayId = result.displayId;
                inputEvent.x = result.pixelX;
                inputEvent.y = result.pixelY;
                inputEvent.button = isRightDragging ? 2 : 1;
                DirectGPUInputHandler.queueEvent(result.displayId, inputEvent);
                lastDragX = result.pixelX;
                lastDragY = result.pixelY;
            }
        }
        catch (Exception e) {
            DirectGPUMod.error("Error in mouse move handler: " + e.getMessage());
            DirectGPUInputHandler.resetDragState();
        }
    }

    private static void resetDragState() {
        isLeftDragging = false;
        isRightDragging = false;
        draggedDisplayId = null;
        lastDragX = -1;
        lastDragY = -1;
    }

    public static void queueEvent(int displayId, DisplayInputEvent event) {
        try {
            Queue queue = eventQueues.computeIfAbsent(displayId, k -> new ConcurrentLinkedQueue());
            if (queue.size() >= 100) {
                queue.poll();
            }
            queue.offer(event);
        }
        catch (Exception e) {
            DirectGPUMod.error("Failed to queue event: " + e.getMessage());
        }
    }

    public static DisplayInputEvent pollEvent(int displayId) {
        try {
            Queue<DisplayInputEvent> queue = eventQueues.get(displayId);
            return queue != null ? queue.poll() : null;
        }
        catch (Exception e) {
            DirectGPUMod.error("Failed to poll event: " + e.getMessage());
            return null;
        }
    }

    public static boolean hasEvents(int displayId) {
        try {
            Queue<DisplayInputEvent> queue = eventQueues.get(displayId);
            return queue != null && !queue.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void clearEvents(int displayId) {
        try {
            Queue<DisplayInputEvent> queue = eventQueues.get(displayId);
            if (queue != null) {
                queue.clear();
            }
            if (draggedDisplayId != null && draggedDisplayId == displayId) {
                DirectGPUInputHandler.resetDragState();
            }
        }
        catch (Exception e) {
            DirectGPUMod.error("Failed to clear events: " + e.getMessage());
        }
    }

    public static void removeDisplayEvents(int displayId) {
        try {
            eventQueues.remove(displayId);
            if (draggedDisplayId != null && draggedDisplayId == displayId) {
                DirectGPUInputHandler.resetDragState();
            }
        }
        catch (Exception e) {
            DirectGPUMod.error("Failed to remove display events: " + e.getMessage());
        }
    }

    private static RaycastResult raycastDisplays(Camera camera) {
        try {
            Vec3 cameraPos = camera.m_90583_();
            Vector3f lookVecJoml = camera.m_253058_();
            Vec3 lookVec = new Vec3((double)lookVecJoml.x(), (double)lookVecJoml.y(), (double)lookVecJoml.z());
            RaycastResult closest = null;
            double closestDist = Double.MAX_VALUE;
            for (DirectGPUDisplay display : DirectGPUManager.getAllDisplays()) {
                try {
                    RaycastResult result = DirectGPUInputHandler.raycastDisplay(display, cameraPos, lookVec);
                    if (result == null || !(result.distance < closestDist)) continue;
                    closest = result;
                    closestDist = result.distance;
                }
                catch (Exception e) {}
            }
            return closest;
        }
        catch (Exception e) {
            DirectGPUMod.error("Raycast failed: " + e.getMessage());
            return null;
        }
    }

    private static RaycastResult raycastDisplay(DirectGPUDisplay display, Vec3 cameraPos, Vec3 lookVec) {
        double centerX = (double)display.x + (double)(display.width - 1) / 2.0;
        double centerY = (double)display.y + (double)(display.height - 1) / 2.0;
        double centerZ = display.z;
        if (display.facing.equals("east") || display.facing.equals("west")) {
            centerZ = (double)display.z + (double)(display.width - 1) / 2.0;
            centerX = display.x;
        }
        double worldX = centerX + 0.5;
        double worldY = centerY + 0.5;
        double worldZ = centerZ + 0.5;
        Vector3f planeNormal = DirectGPUInputHandler.getFacingNormal(display.facing);
        Vector3f planePoint = new Vector3f((float)worldX, (float)worldY, (float)worldZ);
        planePoint.add(planeNormal.x * 0.502f, planeNormal.y * 0.502f, planeNormal.z * 0.502f);
        Vector3f rayOrigin = new Vector3f((float)cameraPos.f_82479_, (float)cameraPos.f_82480_, (float)cameraPos.f_82481_);
        Vector3f rayDir = new Vector3f((float)lookVec.f_82479_, (float)lookVec.f_82480_, (float)lookVec.f_82481_);
        float denom = planeNormal.dot((Vector3fc)rayDir);
        if (Math.abs(denom) < 1.0E-4f) {
            return null;
        }
        Vector3f diff = new Vector3f((Vector3fc)planePoint).sub((Vector3fc)rayOrigin);
        float t = diff.dot((Vector3fc)planeNormal) / denom;
        if (t < 0.0f) {
            return null;
        }
        Vector3f hitPoint = new Vector3f((Vector3fc)rayOrigin).add(rayDir.x * t, rayDir.y * t, rayDir.z * t);
        Vector3f localHit = new Vector3f((Vector3fc)hitPoint).sub((Vector3fc)planePoint);
        Vector2f localCoords = DirectGPUInputHandler.getLocalCoordinates(localHit, display.facing);
        float bezelInset = 0.12f;
        float insetWidth = (float)display.width - bezelInset * 2.0f;
        float insetHeight = (float)display.height - bezelInset * 2.0f;
        float halfWidth = insetWidth / 2.0f;
        float halfHeight = insetHeight / 2.0f;
        if (Math.abs(localCoords.x) > halfWidth || Math.abs(localCoords.y) > halfHeight) {
            return null;
        }
        int pixelX = (int)((localCoords.x + halfWidth) / insetWidth * (float)display.getPixelWidth());
        int pixelY = (int)((halfHeight - localCoords.y) / insetHeight * (float)display.getPixelHeight());
        pixelX = Math.max(0, Math.min(display.getPixelWidth() - 1, pixelX));
        pixelY = Math.max(0, Math.min(display.getPixelHeight() - 1, pixelY));
        RaycastResult result = new RaycastResult();
        result.displayId = display.id;
        result.pixelX = pixelX;
        result.pixelY = pixelY;
        result.distance = t;
        return result;
    }

    private static Vector3f getFacingNormal(String facing) {
        switch (facing) {
            case "north": {
                return new Vector3f(0.0f, 0.0f, -1.0f);
            }
            case "south": {
                return new Vector3f(0.0f, 0.0f, 1.0f);
            }
            case "east": {
                return new Vector3f(1.0f, 0.0f, 0.0f);
            }
            case "west": {
                return new Vector3f(-1.0f, 0.0f, 0.0f);
            }
            case "up": {
                return new Vector3f(0.0f, 1.0f, 0.0f);
            }
            case "down": {
                return new Vector3f(0.0f, -1.0f, 0.0f);
            }
        }
        return new Vector3f(0.0f, 0.0f, 1.0f);
    }

    private static Vector2f getLocalCoordinates(Vector3f localHit, String facing) {
        switch (facing) {
            case "north": {
                return new Vector2f(-localHit.x, localHit.y);
            }
            case "south": {
                return new Vector2f(localHit.x, localHit.y);
            }
            case "east": {
                return new Vector2f(localHit.z, localHit.y);
            }
            case "west": {
                return new Vector2f(-localHit.z, localHit.y);
            }
            case "up": {
                return new Vector2f(localHit.x, -localHit.z);
            }
            case "down": {
                return new Vector2f(localHit.x, localHit.z);
            }
        }
        return new Vector2f(localHit.x, localHit.y);
    }

    private static class RaycastResult {
        int displayId;
        int pixelX;
        int pixelY;
        double distance;

        private RaycastResult() {
        }
    }

    public static class DisplayInputEvent {
        public String type;
        public int displayId;
        public int x;
        public int y;
        public int button;
        public String key;
        public String character;
    }
}

