/*
 * Decompiled with CFR 0.152.
 */
package com.tom.directgpu;

import com.tom.directgpu.DirectGPUMod;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class DirectGPUImageDecoder {
    private static ImageReader jpegReader = null;
    private static final Object READER_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageReader getJpegReader() {
        if (jpegReader == null) {
            Object object = READER_LOCK;
            synchronized (object) {
                Iterator<ImageReader> readers;
                if (jpegReader == null && (readers = ImageIO.getImageReadersByFormatName("JPEG")).hasNext()) {
                    jpegReader = readers.next();
                    DirectGPUMod.log("Initialized fast JPEG reader: " + jpegReader.getClass().getName());
                }
            }
        }
        return jpegReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> decodeJPEG(byte[] jpegData) throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            ImageReader reader = DirectGPUImageDecoder.getJpegReader();
            if (reader == null) {
                throw new Exception("No JPEG decoder available");
            }
            Object object = READER_LOCK;
            synchronized (object) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(jpegData);
                MemoryCacheImageInputStream imageInputStream = new MemoryCacheImageInputStream(inputStream);
                reader.setInput(imageInputStream, true, true);
                BufferedImage image = reader.read(0, null);
                imageInputStream.close();
                reader.reset();
                int width = image.getWidth();
                int height = image.getHeight();
                byte[] pixels = new byte[width * height * 3];
                int[] rgbArray = new int[width * height];
                image.getRGB(0, 0, width, height, rgbArray, 0, width);
                int pixelIndex = 0;
                for (int rgb : rgbArray) {
                    pixels[pixelIndex++] = (byte)(rgb >> 16 & 0xFF);
                    pixels[pixelIndex++] = (byte)(rgb >> 8 & 0xFF);
                    pixels[pixelIndex++] = (byte)(rgb & 0xFF);
                }
                long elapsed = System.currentTimeMillis() - startTime;
                DirectGPUMod.log(String.format("Decoded JPEG: %dx%d in %dms", width, height, elapsed));
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("width", width);
                result.put("height", height);
                result.put("pixels", pixels);
                result.put("decodeTime", elapsed);
                return result;
            }
        }
        catch (Exception e) {
            long elapsed = System.currentTimeMillis() - startTime;
            DirectGPUMod.error("JPEG decode failed after " + elapsed + "ms: " + e.getMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> decodeAndScaleJPEG(byte[] jpegData, int targetWidth, int targetHeight) throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            ImageReader reader = DirectGPUImageDecoder.getJpegReader();
            if (reader == null) {
                throw new Exception("No JPEG decoder available");
            }
            Object object = READER_LOCK;
            synchronized (object) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(jpegData);
                MemoryCacheImageInputStream imageInputStream = new MemoryCacheImageInputStream(inputStream);
                reader.setInput(imageInputStream, true, true);
                BufferedImage originalImage = reader.read(0, null);
                imageInputStream.close();
                reader.reset();
                int origWidth = originalImage.getWidth();
                int origHeight = originalImage.getHeight();
                BufferedImage scaledImage = new BufferedImage(targetWidth, targetHeight, 1);
                Graphics2D g = scaledImage.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                g.drawImage(originalImage, 0, 0, targetWidth, targetHeight, null);
                g.dispose();
                byte[] pixels = new byte[targetWidth * targetHeight * 3];
                int[] rgbArray = new int[targetWidth * targetHeight];
                scaledImage.getRGB(0, 0, targetWidth, targetHeight, rgbArray, 0, targetWidth);
                int pixelIndex = 0;
                for (int rgb : rgbArray) {
                    pixels[pixelIndex++] = (byte)(rgb >> 16 & 0xFF);
                    pixels[pixelIndex++] = (byte)(rgb >> 8 & 0xFF);
                    pixels[pixelIndex++] = (byte)(rgb & 0xFF);
                }
                long elapsed = System.currentTimeMillis() - startTime;
                DirectGPUMod.log(String.format("Decoded+scaled JPEG: %dx%d -> %dx%d in %dms", origWidth, origHeight, targetWidth, targetHeight, elapsed));
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("width", targetWidth);
                result.put("height", targetHeight);
                result.put("pixels", pixels);
                result.put("originalWidth", origWidth);
                result.put("originalHeight", origHeight);
                result.put("decodeTime", elapsed);
                return result;
            }
        }
        catch (Exception e) {
            long elapsed = System.currentTimeMillis() - startTime;
            DirectGPUMod.error("JPEG decode+scale failed after " + elapsed + "ms: " + e.getMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getJPEGDimensions(byte[] jpegData) throws Exception {
        try {
            ImageReader reader = DirectGPUImageDecoder.getJpegReader();
            if (reader == null) {
                throw new Exception("No JPEG decoder available");
            }
            Object object = READER_LOCK;
            synchronized (object) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(jpegData);
                MemoryCacheImageInputStream imageInputStream = new MemoryCacheImageInputStream(inputStream);
                reader.setInput(imageInputStream, true, true);
                int width = reader.getWidth(0);
                int height = reader.getHeight(0);
                imageInputStream.close();
                reader.reset();
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("width", width);
                result.put("height", height);
                return result;
            }
        }
        catch (Exception e) {
            DirectGPUMod.error("Failed to get JPEG dimensions: " + e.getMessage());
            throw e;
        }
    }
}

