/*
 * Decompiled with CFR 0.152.
 */
package com.tom.directgpu;

import com.tom.directgpu.DirectGPUMod;
import java.util.List;
import java.util.Map;

public class DirectGPUDisplay {
    public static final int PIXELS_PER_BLOCK_WIDTH = 164;
    public static final int PIXELS_PER_BLOCK_HEIGHT = 81;
    public final int id;
    public final int x;
    public final int y;
    public final int z;
    public final String facing;
    public final int width;
    public final int height;
    public final int resolutionMultiplier;
    private final int pixelWidth;
    private final int pixelHeight;
    private final byte[] pixels;
    public int textureId = -1;
    private volatile boolean dirty = true;

    public DirectGPUDisplay(int id, int x, int y, int z, String facing, int width, int height, int resolutionMultiplier) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.facing = facing.toLowerCase();
        this.width = width;
        this.height = height;
        this.resolutionMultiplier = Math.max(1, Math.min(4, resolutionMultiplier));
        this.pixelWidth = width * 164 * this.resolutionMultiplier;
        this.pixelHeight = height * 81 * this.resolutionMultiplier;
        this.pixels = new byte[this.pixelWidth * this.pixelHeight * 3];
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = 0;
        }
        DirectGPUMod.log("Created display with " + this.resolutionMultiplier + "x resolution multiplier");
    }

    public DirectGPUDisplay(int id, int x, int y, int z, String facing, int width, int height) {
        this(id, x, y, z, facing, width, height, 1);
    }

    public int getPixelWidth() {
        return this.pixelWidth;
    }

    public int getPixelHeight() {
        return this.pixelHeight;
    }

    public byte[] getPixels() {
        return this.pixels;
    }

    public synchronized byte[] getPixelsCopy() {
        return (byte[])this.pixels.clone();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void markClean() {
        this.dirty = false;
    }

    public synchronized void setPixel(int px, int py, int r, int g, int b) {
        if (px < 0 || px >= this.pixelWidth || py < 0 || py >= this.pixelHeight) {
            return;
        }
        int index = (py * this.pixelWidth + px) * 3;
        this.pixels[index] = (byte)r;
        this.pixels[index + 1] = (byte)g;
        this.pixels[index + 2] = (byte)b;
        this.markDirty();
    }

    public synchronized int[] getPixel(int px, int py) {
        if (px < 0 || px >= this.pixelWidth || py < 0 || py >= this.pixelHeight) {
            return new int[]{0, 0, 0};
        }
        int index = (py * this.pixelWidth + px) * 3;
        return new int[]{this.pixels[index] & 0xFF, this.pixels[index + 1] & 0xFF, this.pixels[index + 2] & 0xFF};
    }

    public synchronized void clear(int r, int g, int b) {
        byte rb = (byte)r;
        byte gb = (byte)g;
        byte bb = (byte)b;
        for (int i = 0; i < this.pixels.length; i += 3) {
            this.pixels[i] = rb;
            this.pixels[i + 1] = gb;
            this.pixels[i + 2] = bb;
        }
        this.markDirty();
    }

    public synchronized void fillRect(int x, int y, int w, int h, int r, int g, int b) {
        byte rb = (byte)r;
        byte gb = (byte)g;
        byte bb = (byte)b;
        for (int py = y; py < y + h && py < this.pixelHeight; ++py) {
            if (py < 0) continue;
            for (int px = x; px < x + w && px < this.pixelWidth; ++px) {
                if (px < 0) continue;
                int index = (py * this.pixelWidth + px) * 3;
                this.pixels[index] = rb;
                this.pixels[index + 1] = gb;
                this.pixels[index + 2] = bb;
            }
        }
        this.markDirty();
    }

    public synchronized void drawLine(int x1, int y1, int x2, int y2, int r, int g, int b) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            if (x1 >= 0 && x1 < this.pixelWidth && y1 >= 0 && y1 < this.pixelHeight) {
                int index = (y1 * this.pixelWidth + x1) * 3;
                this.pixels[index] = (byte)r;
                this.pixels[index + 1] = (byte)g;
                this.pixels[index + 2] = (byte)b;
            }
            if (x1 == x2 && y1 == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x1 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y1 += sy;
        }
        this.markDirty();
    }

    public synchronized void loadImageFromDict(Map<?, ?> imageData) throws Exception {
        Object widthObj = imageData.get("width");
        Object heightObj = imageData.get("height");
        Object pixelsObj = imageData.get("pixels");
        if (widthObj == null || heightObj == null || pixelsObj == null) {
            throw new Exception("Image data must contain 'width', 'height', and 'pixels' fields");
        }
        int imgWidth = ((Number)widthObj).intValue();
        int imgHeight = ((Number)heightObj).intValue();
        DirectGPUMod.log("Loading image: " + imgWidth + "x" + imgHeight);
        DirectGPUMod.log("Pixels object type: " + pixelsObj.getClass().getName());
        if (pixelsObj instanceof Map) {
            DirectGPUMod.log("Detected Map format (Lua table) - converting to nested format");
            this.loadFromMap((Map)pixelsObj, imgWidth, imgHeight);
        } else if (pixelsObj instanceof List) {
            List pixelsList = (List)pixelsObj;
            if (pixelsList.isEmpty()) {
                throw new Exception("'pixels' list is empty");
            }
            Object firstElement = pixelsList.get(0);
            boolean isNested = firstElement instanceof List || firstElement instanceof Map;
            DirectGPUMod.log("Detected List format, nested: " + isNested);
            if (isNested) {
                this.loadNestedFormat(pixelsList, imgWidth, imgHeight);
            } else {
                this.loadFlatFormat(pixelsList, imgWidth, imgHeight);
            }
        } else {
            throw new Exception("'pixels' must be a list or map, got: " + pixelsObj.getClass().getName());
        }
        this.markDirty();
    }

    private void loadFromMap(Map<?, ?> pixelsMap, int imgWidth, int imgHeight) throws Exception {
        this.clear(0, 0, 0);
        int scaledWidth = this.pixelWidth;
        int scaledHeight = this.pixelHeight;
        int offsetX = 0;
        int offsetY = 0;
        for (int srcY = 0; srcY < imgHeight; ++srcY) {
            Object rowObj = pixelsMap.get(srcY + 1);
            if (rowObj == null) {
                rowObj = pixelsMap.get(srcY + 1);
            }
            if (rowObj == null) continue;
            Map row = null;
            if (!(rowObj instanceof Map)) continue;
            row = (Map)rowObj;
            for (int srcX = 0; srcX < imgWidth; ++srcX) {
                List pixel;
                Object pixelObj = row.get(srcX + 1);
                if (pixelObj == null) {
                    pixelObj = row.get(srcX + 1);
                }
                if (pixelObj == null) continue;
                int r = 0;
                int g = 0;
                int b = 0;
                if (pixelObj instanceof Map) {
                    Map pixel2 = (Map)pixelObj;
                    r = ((Number)pixel2.get(1.0)).intValue();
                    g = ((Number)pixel2.get(2.0)).intValue();
                    b = ((Number)pixel2.get(3.0)).intValue();
                } else if (pixelObj instanceof List && (pixel = (List)pixelObj).size() >= 3) {
                    r = ((Number)pixel.get(0)).intValue();
                    g = ((Number)pixel.get(1)).intValue();
                    b = ((Number)pixel.get(2)).intValue();
                }
                int dstX = offsetX + srcX * scaledWidth / imgWidth;
                int dstY = offsetY + srcY * scaledHeight / imgHeight;
                if (dstX < 0 || dstX >= this.pixelWidth || dstY < 0 || dstY >= this.pixelHeight) continue;
                int index = (dstY * this.pixelWidth + dstX) * 3;
                this.pixels[index] = (byte)r;
                this.pixels[index + 1] = (byte)g;
                this.pixels[index + 2] = (byte)b;
            }
        }
        DirectGPUMod.log("Successfully loaded from Map format");
    }

    private void loadNestedFormat(List<?> pixelsList, int imgWidth, int imgHeight) throws Exception {
        int scaledHeight;
        int scaledWidth;
        this.clear(0, 0, 0);
        double sourceAspect = (double)imgWidth / (double)imgHeight;
        double targetAspect = (double)this.pixelWidth / (double)this.pixelHeight;
        int offsetX = 0;
        int offsetY = 0;
        if (sourceAspect > targetAspect) {
            scaledWidth = this.pixelWidth;
            scaledHeight = (int)((double)this.pixelWidth / sourceAspect);
            offsetY = (this.pixelHeight - scaledHeight) / 2;
        } else {
            scaledHeight = this.pixelHeight;
            scaledWidth = (int)((double)this.pixelHeight * sourceAspect);
            offsetX = (this.pixelWidth - scaledWidth) / 2;
        }
        for (int srcY = 0; srcY < imgHeight && srcY < pixelsList.size(); ++srcY) {
            Object pixelObj;
            int srcX;
            Object row;
            Object rowObj = pixelsList.get(srcY);
            if (rowObj == null) continue;
            if (rowObj instanceof List) {
                row = (List)rowObj;
                for (srcX = 0; srcX < imgWidth && srcX < row.size(); ++srcX) {
                    List pixel;
                    pixelObj = row.get(srcX);
                    if (!(pixelObj instanceof List) || (pixel = (List)pixelObj).size() < 3) continue;
                    int r = ((Number)pixel.get(0)).intValue();
                    int g = ((Number)pixel.get(1)).intValue();
                    int b = ((Number)pixel.get(2)).intValue();
                    int dstX = offsetX + srcX * scaledWidth / imgWidth;
                    int dstY = offsetY + srcY * scaledHeight / imgHeight;
                    if (dstX < 0 || dstX >= this.pixelWidth || dstY < 0 || dstY >= this.pixelHeight) continue;
                    int index = (dstY * this.pixelWidth + dstX) * 3;
                    this.pixels[index] = (byte)r;
                    this.pixels[index + 1] = (byte)g;
                    this.pixels[index + 2] = (byte)b;
                }
                continue;
            }
            if (!(rowObj instanceof Map)) continue;
            row = (Map)rowObj;
            for (srcX = 0; srcX < imgWidth; ++srcX) {
                List pixel;
                pixelObj = row.get(srcX + 1);
                if (pixelObj == null) {
                    pixelObj = row.get(srcX + 1);
                }
                if (pixelObj == null) continue;
                int r = 0;
                int g = 0;
                int b = 0;
                if (pixelObj instanceof List && (pixel = (List)pixelObj).size() >= 3) {
                    r = ((Number)pixel.get(0)).intValue();
                    g = ((Number)pixel.get(1)).intValue();
                    b = ((Number)pixel.get(2)).intValue();
                }
                int dstX = offsetX + srcX * scaledWidth / imgWidth;
                int dstY = offsetY + srcY * scaledHeight / imgHeight;
                if (dstX < 0 || dstX >= this.pixelWidth || dstY < 0 || dstY >= this.pixelHeight) continue;
                int index = (dstY * this.pixelWidth + dstX) * 3;
                this.pixels[index] = (byte)r;
                this.pixels[index + 1] = (byte)g;
                this.pixels[index + 2] = (byte)b;
            }
        }
    }

    private void loadFlatFormat(List<?> pixelsList, int imgWidth, int imgHeight) throws Exception {
        int scaledHeight;
        int scaledWidth;
        this.clear(0, 0, 0);
        int expectedSize = imgWidth * imgHeight * 3;
        DirectGPUMod.log("Flat format validation: expected " + expectedSize + " elements, got " + pixelsList.size());
        if (pixelsList.size() < expectedSize) {
            throw new Exception("Flat pixel array too small: expected at least " + expectedSize + ", got " + pixelsList.size());
        }
        Object testElement = pixelsList.get(0);
        if (!(testElement instanceof Number)) {
            throw new Exception("Flat format expects numbers, got: " + testElement.getClass().getName());
        }
        double sourceAspect = (double)imgWidth / (double)imgHeight;
        double targetAspect = (double)this.pixelWidth / (double)this.pixelHeight;
        int offsetX = 0;
        int offsetY = 0;
        if (sourceAspect > targetAspect) {
            scaledWidth = this.pixelWidth;
            scaledHeight = (int)((double)this.pixelWidth / sourceAspect);
            offsetY = (this.pixelHeight - scaledHeight) / 2;
        } else {
            scaledHeight = this.pixelHeight;
            scaledWidth = (int)((double)this.pixelHeight * sourceAspect);
            offsetX = (this.pixelWidth - scaledWidth) / 2;
        }
        for (int srcY = 0; srcY < imgHeight; ++srcY) {
            for (int srcX = 0; srcX < imgWidth; ++srcX) {
                int srcIndex = (srcY * imgWidth + srcX) * 3;
                if (srcIndex + 2 >= pixelsList.size()) {
                    DirectGPUMod.warn("Pixel index out of bounds at (" + srcX + "," + srcY + "): " + srcIndex);
                    continue;
                }
                int r = ((Number)pixelsList.get(srcIndex)).intValue();
                int g = ((Number)pixelsList.get(srcIndex + 1)).intValue();
                int b = ((Number)pixelsList.get(srcIndex + 2)).intValue();
                int dstX = offsetX + srcX * scaledWidth / imgWidth;
                int dstY = offsetY + srcY * scaledHeight / imgHeight;
                if (dstX < 0 || dstX >= this.pixelWidth || dstY < 0 || dstY >= this.pixelHeight) continue;
                int index = (dstY * this.pixelWidth + dstX) * 3;
                this.pixels[index] = (byte)r;
                this.pixels[index + 1] = (byte)g;
                this.pixels[index + 2] = (byte)b;
            }
        }
        DirectGPUMod.log("Successfully loaded flat format image");
    }
}

