/*
 * Decompiled with CFR 0.152.
 */
package com.tom.directgpu;

import com.tom.directgpu.DirectGPUMod;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.CRC32;

public class DirectGPUDictionary {
    private static final int CHUNK_SIZE = 8192;
    private static final int MAX_DICT_SIZE = 10000;
    private static final Map<Long, byte[]> dictionary = new ConcurrentHashMap<Long, byte[]>();

    public static long hashChunk(byte[] data) {
        CRC32 crc = new CRC32();
        crc.update(data);
        return crc.getValue();
    }

    public static long addChunk(byte[] chunk) {
        long hash = DirectGPUDictionary.hashChunk(chunk);
        if (dictionary.size() >= 10000) {
            Long firstKey = dictionary.keySet().iterator().next();
            dictionary.remove(firstKey);
        }
        dictionary.put(hash, chunk);
        return hash;
    }

    public static boolean hasChunk(long hash) {
        return dictionary.containsKey(hash);
    }

    public static byte[] getChunk(long hash) {
        return dictionary.get(hash);
    }

    public static Map<String, Object> compressWithDict(byte[] data) {
        int numChunks = (data.length + 8192 - 1) / 8192;
        long[] hashes = new long[numChunks];
        int newChunks = 0;
        int cachedChunks = 0;
        for (int i = 0; i < numChunks; ++i) {
            long hash;
            int offset = i * 8192;
            int length = Math.min(8192, data.length - offset);
            byte[] chunk = new byte[length];
            System.arraycopy(data, offset, chunk, 0, length);
            hashes[i] = hash = DirectGPUDictionary.hashChunk(chunk);
            if (!DirectGPUDictionary.hasChunk(hash)) {
                DirectGPUDictionary.addChunk(chunk);
                ++newChunks;
                continue;
            }
            ++cachedChunks;
        }
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        result.put("hashes", hashes);
        result.put("totalChunks", numChunks);
        result.put("newChunks", newChunks);
        result.put("cachedChunks", cachedChunks);
        result.put("chunkSize", 8192);
        return result;
    }

    public static byte[] decompressFromDict(long[] hashes) throws Exception {
        int totalSize = 0;
        byte[][] chunks = new byte[hashes.length][];
        for (int i = 0; i < hashes.length; ++i) {
            byte[] chunk = DirectGPUDictionary.getChunk(hashes[i]);
            if (chunk == null) {
                throw new Exception("Missing chunk with hash: " + hashes[i]);
            }
            chunks[i] = chunk;
            totalSize += chunk.length;
        }
        byte[] result = new byte[totalSize];
        int offset = 0;
        for (byte[] chunk : chunks) {
            System.arraycopy(chunk, 0, result, offset, chunk.length);
            offset += chunk.length;
        }
        return result;
    }

    public static Map<String, Object> getStats() {
        ConcurrentHashMap<String, Object> stats = new ConcurrentHashMap<String, Object>();
        stats.put("dictionarySize", dictionary.size());
        stats.put("maxDictionarySize", 10000);
        stats.put("chunkSize", 8192);
        long totalBytes = 0L;
        for (byte[] chunk : dictionary.values()) {
            totalBytes += (long)chunk.length;
        }
        stats.put("totalBytes", totalBytes);
        stats.put("totalMB", (double)totalBytes / 1048576.0);
        return stats;
    }

    public static void clear() {
        dictionary.clear();
        DirectGPUMod.log("Dictionary cleared");
    }

    public static byte[] getChunkBytes(long hash) {
        return dictionary.get(hash);
    }
}

