/*
 * Decompiled with CFR 0.152.
 */
package com.tom.directgpu;

import com.tom.directgpu.DirectGPUManager;
import com.tom.directgpu.DirectGPUMod;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DirectGPUCleanupManager {
    private static final Map<String, Set<Integer>> computerToDisplay = new ConcurrentHashMap<String, Set<Integer>>();

    public static void registerDisplay(String computerKey, int displayId) {
        Set displayIds = computerToDisplay.computeIfAbsent(computerKey, k -> ConcurrentHashMap.newKeySet());
        displayIds.add(displayId);
        DirectGPUMod.log("Registered display " + displayId + " for computer " + computerKey + " (Total: " + displayIds.size() + ")");
    }

    public static void unregisterDisplay(String computerKey) {
        Set<Integer> displayIds = computerToDisplay.remove(computerKey);
        if (displayIds != null) {
            DirectGPUMod.log("Unregistering " + displayIds.size() + " displays for computer " + computerKey);
            for (Integer displayId : displayIds) {
                DirectGPUManager.removeDisplay(displayId);
                DirectGPUMod.log("Unregistered and removed display " + displayId + " for computer " + computerKey);
            }
        }
    }

    public static String makeComputerKey(int x, int y, int z) {
        return x + "," + y + "," + z;
    }

    public static void clearAllForComputer(String computerKey) {
        DirectGPUCleanupManager.unregisterDisplay(computerKey);
    }
}

