/*
 * Decompiled with CFR 0.152.
 */
package com.tom.directgpu;

import com.tom.directgpu.DirectGPUMod;
import com.tom.directgpu.DirectGPUPeripheral;
import com.tom.directgpu.DirectGPURegistry;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class DirectGPUBlockEntity
extends BlockEntity {
    private DirectGPUPeripheral peripheral;
    private LazyOptional<IPeripheral> peripheralCap = LazyOptional.empty();

    public DirectGPUBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DirectGPURegistry.GPU_BLOCK_ENTITY.get(), pos, state);
    }

    private void ensurePeripheralCreated() {
        if (this.peripheral == null && this.f_58857_ != null) {
            DirectGPUMod.log("Creating peripheral for block entity at " + this.f_58858_);
            this.peripheral = new DirectGPUPeripheral(this.f_58858_, this.f_58857_);
            this.peripheralCap = LazyOptional.of(() -> this.peripheral);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        this.ensurePeripheralCreated();
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            DirectGPUMod.log("Peripheral capability requested on side: " + (side != null ? side.m_122433_() : "internal"));
            return this.peripheralCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.peripheralCap.invalidate();
        if (this.peripheral != null) {
            this.peripheral.cleanup();
        }
    }

    public DirectGPUPeripheral getPeripheral() {
        this.ensurePeripheralCreated();
        return this.peripheral;
    }
}

