/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.railwayteam.railways.content.coupling.TrainUtils;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Train;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5242;

public class SplitTrainCommand {
    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"split_train").requires(cs -> cs.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"train_id", (ArgumentType)class_5242.method_27643()).executes(ctx -> {
            UUID trainId = class_5242.method_27645((CommandContext)ctx, (String)"train_id");
            return SplitTrainCommand.execute((CommandContext<class_2168>)ctx, trainId, 1);
        })).then(class_2170.method_9244((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            UUID trainId = class_5242.method_27645((CommandContext)ctx, (String)"train_id");
            int number = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"number");
            return SplitTrainCommand.execute((CommandContext<class_2168>)ctx, trainId, number);
        })))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"train_name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"train_name");
            UUID trainId = Create.RAILWAYS.trains.values().stream().filter(t -> t.name.getString().equals(name)).findFirst().map(t -> t.id).orElse(null);
            return SplitTrainCommand.execute((CommandContext<class_2168>)ctx, trainId, 1);
        })).then(class_2170.method_9244((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"train_name");
            UUID trainId = Create.RAILWAYS.trains.values().stream().filter(t -> t.name.getString().equals(name)).findFirst().map(t -> t.id).orElse(null);
            int number = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"number");
            return SplitTrainCommand.execute((CommandContext<class_2168>)ctx, trainId, number);
        })));
    }

    private static int execute(CommandContext<class_2168> ctx, UUID trainId, int numberOffEnd) {
        if (trainId == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No trains were found."));
            return 0;
        }
        Train train = (Train)Create.RAILWAYS.trains.get(trainId);
        if (train == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("No Train with id " + trainId.toString().substring(0, 5) + "[...] was found")));
            return 0;
        }
        try {
            TrainUtils.splitTrain(train, numberOffEnd);
        }
        catch (Exception e) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Failed to split train: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Train '").method_10852(train.name).method_27693("' split successfully"), true);
        return 1;
    }
}

