/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.railwayteam.railways.content.custom_tracks.casing.CasingRenderUtils;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.content.trains.track.TrackVisual;
import dev.engine_room.flywheel.api.visual.BlockEntityVisual;
import dev.engine_room.flywheel.api.visual.ShaderLightVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.visual.AbstractVisual;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TrackVisual.class}, remap=false)
public abstract class MixinTrackVisual
extends AbstractVisual
implements BlockEntityVisual<TrackBlockEntity>,
ShaderLightVisual {
    @Shadow
    @Final
    protected TrackBlockEntity blockEntity;
    @Shadow
    @Final
    protected class_2338 visualPos;
    @Shadow
    @Final
    protected class_2338 pos;
    private final List<Pair<TransformedInstance, class_2338>> casingData = new ArrayList<Pair<TransformedInstance, class_2338>>();

    public MixinTrackVisual(VisualizationContext ctx, class_1937 level, float partialTick) {
        super(ctx, level, partialTick);
    }

    @Shadow
    public abstract void _delete();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onCtor(VisualizationContext context, TrackBlockEntity track, float partialTick, CallbackInfo ci) {
        this.railways$makeCasingData(true);
    }

    @Inject(method={"update"}, at={@At(value="RETURN", ordinal=0)})
    private void updateWithoutConnections(CallbackInfo ci) {
        this._delete();
        this.railways$makeCasingData(false);
    }

    @Inject(method={"update"}, at={@At(value="RETURN", ordinal=1)})
    private void updateWithConnections(CallbackInfo ci) {
        this.railways$makeCasingData(true);
    }

    @Inject(method={"_delete"}, at={@At(value="HEAD")})
    private void railways$_delete(CallbackInfo ci) {
        this.casingData.forEach(data -> ((TransformedInstance)data.getFirst()).delete());
        this.casingData.clear();
    }

    @ModifyReturnValue(method={"collectLightSections"}, at={@At(value="RETURN")})
    private LongSet collectCasingLightSections(LongSet original) {
        if (original.isEmpty()) {
            return LongSet.of((long)class_4076.method_33706((class_2338)this.blockEntity.method_11016()));
        }
        original.add(class_4076.method_33706((class_2338)this.blockEntity.method_11016()));
        return original;
    }

    @Unique
    private void railways$makeCasingData(boolean connections) {
        class_2680 state;
        TrackShape shape;
        class_4587 ms = new class_4587();
        ((PoseTransformStack)TransformStack.of((class_4587)ms).translate((class_2382)this.visualPos)).nudge((int)this.pos.method_10063());
        class_2482 casingBlock = ((IHasTrackCasing)this.blockEntity).getTrackCasing();
        if (casingBlock != null && CRBlockPartials.TRACK_CASINGS.containsKey(shape = (TrackShape)(state = this.blockEntity.method_11010()).method_11654((class_2769)TrackBlock.SHAPE))) {
            ms.method_22903();
            if (this.blockEntity.isTilted()) {
                double angle = (Double)this.blockEntity.tilt.smoothingAngle.get();
                switch ((TrackShape)state.method_11654((class_2769)TrackBlock.SHAPE)) {
                    case ZO: {
                        TransformStack.of((class_4587)ms).rotateXDegrees((float)(-angle));
                        break;
                    }
                    case XO: {
                        TransformStack.of((class_4587)ms).rotateZDegrees((float)angle);
                    }
                }
            }
            TrackMaterial.TrackType trackType = null;
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof TrackBlock) {
                TrackBlock trackBlock = (TrackBlock)class_22482;
                trackType = trackBlock.getMaterial().trackType;
            }
            CRBlockPartials.TrackCasingSpec spec = CRBlockPartials.TRACK_CASINGS.get(shape);
            spec = ((IHasTrackCasing)this.blockEntity).isAlternate() ? spec.getNonNullAltSpec(trackType) : spec.getFor(trackType);
            PartialModel rawCasingModel = spec.model;
            CRBlockPartials.ModelTransform transform = spec.transform;
            TransformedInstance casingInstance = CasingRenderUtils.makeCasingInstance(rawCasingModel, casingBlock, this.instancerProvider());
            casingInstance.setTransform(ms).rotateX(transform.rx()).rotateY(transform.ry()).rotateZ(transform.rz()).translate(transform.x(), transform.y(), transform.z());
            this.casingData.add((Pair<TransformedInstance, class_2338>)Pair.of((Object)casingInstance, (Object)this.pos));
            for (CRBlockPartials.ModelTransform additionalTransform : spec.additionalTransforms) {
                TransformedInstance additionalInstance = CasingRenderUtils.makeCasingInstance(rawCasingModel, casingBlock, this.instancerProvider());
                additionalInstance.setTransform(ms).rotateX(additionalTransform.rx()).rotateY(additionalTransform.ry()).rotateZ(additionalTransform.rz()).translate(additionalTransform.x(), additionalTransform.y(), additionalTransform.z());
                this.casingData.add((Pair<TransformedInstance, class_2338>)Pair.of((Object)additionalInstance, (Object)this.pos.method_10069(class_3532.method_15357((double)additionalTransform.x()), class_3532.method_15357((double)additionalTransform.y()), class_3532.method_15357((double)additionalTransform.z()))));
            }
            ms.method_22909();
        }
        if (connections) {
            for (BezierConnection bc : this.blockEntity.getConnections().values()) {
                class_2338 relativePos;
                TransformedInstance casingInstance;
                double shiftDown;
                if (!bc.isPrimary() || (casingBlock = ((IHasTrackCasing)bc).getTrackCasing()) == null) continue;
                int heightDiff = Math.abs(((class_2338)bc.bePositions.get(false)).method_10264() - ((class_2338)bc.bePositions.get(true)).method_10264());
                double d = shiftDown = ((IHasTrackCasing)bc).isAlternate() && heightDiff > 0 ? -0.25 : 0.0;
                if ((double)heightDiff / bc.getLength() <= 0.13333333333333333) {
                    for (class_243 pos : CasingRenderUtils.casingPositions(bc)) {
                        casingInstance = CasingRenderUtils.makeCasingInstance(heightDiff == 0 ? CRBlockPartials.TRACK_CASING_FLAT : CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock, this.instancerProvider());
                        ((TransformedInstance)((TransformedInstance)casingInstance.setTransform(ms).translate(0.0, shiftDown, 0.0)).translate(pos.field_1352, pos.field_1351, pos.field_1350)).scale(1.001f);
                        relativePos = class_2338.method_49637((double)((double)this.pos.method_10263() + pos.field_1352), (double)((double)this.pos.method_10264() + pos.field_1351), (double)((double)this.pos.method_10260() + pos.field_1350));
                        this.casingData.add((Pair<TransformedInstance, class_2338>)Pair.of((Object)casingInstance, (Object)relativePos));
                    }
                    continue;
                }
                BezierConnection.SegmentAngles segments = bc.getBakedSegments();
                for (int i = 1; i < segments.length; ++i) {
                    if (i % 2 == 0) continue;
                    casingInstance = CasingRenderUtils.makeCasingInstance(heightDiff == 0 ? CRBlockPartials.TRACK_CASING_FLAT : CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock, this.instancerProvider());
                    ((TransformedInstance)casingInstance.setTransform(ms).mul(segments.tieTransform[i]).translate(0.0f, (float)(i % 4) * 0.001f, 0.0f).translate(0.0, shiftDown, 0.0)).scale(1.001f);
                    relativePos = segments.lightPosition[i].method_10081((class_2382)this.pos);
                    this.casingData.add((Pair<TransformedInstance, class_2338>)Pair.of((Object)casingInstance, (Object)relativePos));
                    TrackMaterial.TrackType trackType = bc.getMaterial().trackType;
                    if (trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE) {
                        for (boolean first : Iterate.trueAndFalse) {
                            for (boolean inner : Iterate.trueAndFalse) {
                                class_4587.class_4665 transform = (class_4587.class_4665)segments.railTransforms[i].get(first);
                                TransformedInstance casingInstance2 = CasingRenderUtils.makeCasingInstance(heightDiff == 0 ? CRBlockPartials.TRACK_CASING_FLAT : CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock, this.instancerProvider());
                                casingInstance2.setTransform(ms).mul(transform).translate(0.0f, (float)(i % 4) * 0.001f, 0.0f).translate((first ? -0.953125 : -0.03125) + (double)(inner ? 0 : (first ? 1 : -1)), shiftDown, 0.0);
                                class_2338 relativePos2 = segments.lightPosition[i].method_10081((class_2382)this.pos);
                                this.casingData.add((Pair<TransformedInstance, class_2338>)Pair.of((Object)casingInstance2, (Object)relativePos2));
                            }
                        }
                        continue;
                    }
                    for (boolean first : Iterate.trueAndFalse) {
                        class_4587.class_4665 transform = (class_4587.class_4665)segments.railTransforms[i].get(first);
                        TransformedInstance casingInstance2 = CasingRenderUtils.makeCasingInstance(heightDiff == 0 ? CRBlockPartials.TRACK_CASING_FLAT : CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock, this.instancerProvider());
                        casingInstance2.setTransform(ms).mul(transform).translate(0.0f, (float)(i % 4) * 0.001f, 0.0f).translate(-0.5 + (trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE ? (first ? 0.5 : -0.5) : 0.0), shiftDown, 0.0);
                        class_2338 relativePos2 = segments.lightPosition[i].method_10081((class_2382)this.pos);
                        this.casingData.add((Pair<TransformedInstance, class_2338>)Pair.of((Object)casingInstance2, (Object)relativePos2));
                    }
                }
            }
        }
    }
}

