/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import com.railwayteam.railways.content.custom_tracks.phantom.PhantomSpriteManager;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.Affine;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TrackBlock.class})
public class MixinTrackBlockClient {
    @Inject(method={"prepareTrackOverlay"}, at={@At(value="INVOKE_ASSIGN", target="Ldev/engine_room/flywheel/lib/transform/Affine;translate(FFF)Ldev/engine_room/flywheel/lib/transform/Translate;", ordinal=0)}, remap=false)
    private <Self extends Affine<Self>> void bezierShiftTrackOverlay(Affine<Self> affine, class_1922 world, class_2338 pos, class_2680 state, BezierTrackPointLocation bezierPoint, class_2350.class_2352 direction, TrackTargetingBehaviour.RenderedTrackOverlayType type, CallbackInfoReturnable<PartialModel> cir, @Local BezierConnection bc) {
        IHasTrackCasing casingBc = (IHasTrackCasing)bc;
        if (bc.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
            affine.translate(0.0f, 0.875f, 0.0f);
            return;
        }
        if (casingBc.getTrackCasing() != null) {
            if (((class_2338)bc.bePositions.getFirst()).method_10264() == ((class_2338)bc.bePositions.getSecond()).method_10264()) {
                affine.translate(0.0f, 0.0625f, 0.0f);
            } else if (!casingBc.isAlternate()) {
                affine.translate(0.0f, 0.25f, 0.0f);
            }
        }
    }

    @Inject(method={"prepareTrackOverlay"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/track/TrackRenderer;getModelAngles(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", remap=true)}, remap=false)
    private <Self extends Affine<Self>> void blockShiftTrackOverlay(Affine<Self> affine, class_1922 world, class_2338 pos, class_2680 state, BezierTrackPointLocation bezierPoint, class_2350.class_2352 direction, TrackTargetingBehaviour.RenderedTrackOverlayType type, CallbackInfoReturnable<PartialModel> cir) {
        class_2586 class_25862;
        class_2248 class_22482;
        if (bezierPoint == null && (class_22482 = state.method_26204()) instanceof TrackBlock) {
            TrackBlock trackBlock = (TrackBlock)class_22482;
            if (trackBlock.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
                affine.translate(0.0f, 0.875f, 0.0f);
                return;
            }
        }
        if (bezierPoint == null && (class_25862 = world.method_8321(pos)) instanceof TrackBlockEntity) {
            TrackBlockEntity trackTE = (TrackBlockEntity)class_25862;
            class_25862 = state.method_26204();
            if (class_25862 instanceof TrackBlock) {
                TrackBlock trackBlock = (TrackBlock)class_25862;
                IHasTrackCasing casingTE = (IHasTrackCasing)trackTE;
                TrackShape shape = (TrackShape)state.method_11654((class_2769)TrackBlock.SHAPE);
                if (casingTE.getTrackCasing() != null) {
                    CRBlockPartials.TrackCasingSpec spec = CRBlockPartials.TRACK_CASINGS.get(shape);
                    TrackMaterial.TrackType trackType = trackBlock.getMaterial().trackType;
                    if (spec != null) {
                        affine.translate(spec.getXShift(trackType), (double)((float)(spec.getTopSurfacePixelHeight(trackType, casingTE.isAlternate()) - 2) / 16.0f), spec.getZShift(trackType));
                    }
                }
            }
        }
    }

    @Inject(method={"prepareTrackOverlay"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;floor(D)I")}, cancellable=true)
    private <Self extends Affine<Self>> void skipInvisiblePhantoms(Affine<Self> affine, class_1922 world, class_2338 pos, class_2680 state, BezierTrackPointLocation bezierPoint, class_2350.class_2352 direction, TrackTargetingBehaviour.RenderedTrackOverlayType type, CallbackInfoReturnable<PartialModel> cir, @Local BezierConnection bc) {
        if (bc.getMaterial() == CRTrackMaterials.PHANTOM && !PhantomSpriteManager.isVisible()) {
            cir.setReturnValue(null);
        }
    }
}

