/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.unified.impl;

import com.railwayteam.railways.content.custom_bogeys.renderer.unified.BogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.BogeyDisplayHolder;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.impl.VisualElementProvider;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import com.simibubi.create.content.trains.bogey.BogeyVisualizer;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class UnifiedBogeyVisual
implements BogeyVisual,
BogeyDisplayHolder {
    private final BogeyDisplay display;
    private final List<TransformedInstance> instances = new ArrayList<TransformedInstance>();
    @Nullable
    private final BogeyVisual customVisual;

    public static BogeyVisualizer create(BogeyDisplay.Factory factory) {
        return (ctx, partialTick, inContraption) -> new UnifiedBogeyVisual(ctx, partialTick, inContraption, factory);
    }

    private UnifiedBogeyVisual(VisualizationContext ctx, float partialTick, boolean inContraption, BogeyDisplay.Factory displayFactory) {
        VisualElementProvider prov = new VisualElementProvider(ctx, this.instances);
        this.display = displayFactory.create(prov, inContraption);
        prov.freeze();
        BogeyVisualizer customVisualizer = displayFactory.createCustomVisualizer();
        this.customVisual = customVisualizer != null ? customVisualizer.createVisual(ctx, partialTick, inContraption) : null;
    }

    @Override
    public void runWithDisplay(Consumer<BogeyDisplay> consumer) {
        consumer.accept(this.display);
        BogeyVisual bogeyVisual = this.customVisual;
        if (bogeyVisual instanceof BogeyDisplayHolder) {
            BogeyDisplayHolder customDisplayHolder = (BogeyDisplayHolder)bogeyVisual;
            customDisplayHolder.runWithDisplay(consumer);
        }
    }

    public void update(class_2487 bogeyData, float wheelAngle, class_4587 poseStack) {
        for (TransformedInstance i : this.instances) {
            i.setTransform(poseStack);
        }
        this.display.update(bogeyData, wheelAngle);
        for (TransformedInstance i : this.instances) {
            i.setChanged();
        }
        if (this.customVisual != null) {
            this.customVisual.update(bogeyData, wheelAngle, poseStack);
        }
    }

    public void hide() {
        for (TransformedInstance i : this.instances) {
            i.setZeroTransform().setChanged();
        }
        if (this.customVisual != null) {
            this.customVisual.hide();
        }
    }

    public void updateLight(int packedLight) {
        for (TransformedInstance i : this.instances) {
            i.light(packedLight).setChanged();
        }
        if (this.customVisual != null) {
            this.customVisual.updateLight(packedLight);
        }
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        for (TransformedInstance i : this.instances) {
            consumer.accept((Instance)i);
        }
        if (this.customVisual != null) {
            this.customVisual.collectCrumblingInstances(consumer);
        }
    }

    public void delete() {
        for (TransformedInstance i : this.instances) {
            i.delete();
        }
        this.instances.clear();
        if (this.customVisual != null) {
            this.customVisual.delete();
        }
    }
}

