/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer;

import com.railwayteam.railways.Railways;
import java.util.EnumMap;
import java.util.List;
import java.util.function.UnaryOperator;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.render.StitchedSprite;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BufferModelUtils {
    public static final StitchedSprite SPRUCE_PLANKS_TEMPLATE = new StitchedSprite(new class_2960("block/spruce_planks"));
    public static final StitchedSprite BIG_BUFFER_TEMPLATE = new StitchedSprite(Railways.asResource("block/buffer/big_buffer"));
    public static final StitchedSprite SMALL_BUFFER_TEMPLATE = new StitchedSprite(Railways.asResource("block/buffer/small_buffer"));
    public static final StitchedSprite SMALL_BUFFER_MONORAIL_TEMPLATE = new StitchedSprite(Railways.asResource("block/buffer/small_buffer_monorail"));
    public static final EnumMap<class_1767, StitchedSprite> BIG_BUFFER_COLORS = new EnumMap(class_1767.class);
    public static final EnumMap<class_1767, StitchedSprite> SMALL_BUFFER_COLORS = new EnumMap(class_1767.class);

    public static UnaryOperator<class_1058> getSwapper(@Nullable class_2680 planksState) {
        if (planksState == null) {
            return sprite -> null;
        }
        class_2248 planksBlock = planksState.method_26204();
        class_2960 id = CatnipServices.REGISTRIES.getKeyOrThrow(planksBlock);
        String path = id.method_12832();
        if (path.endsWith("_planks")) {
            return sprite -> {
                if (sprite == SPRUCE_PLANKS_TEMPLATE.get()) {
                    return BufferModelUtils.getSpriteOnSide(planksState, class_2350.field_11036);
                }
                return null;
            };
        }
        return sprite -> null;
    }

    @SafeVarargs
    public static UnaryOperator<class_1058> combineSwappers(UnaryOperator<class_1058> ... swappers) {
        return sprite -> {
            for (UnaryOperator swapper : swappers) {
                class_1058 newSprite;
                if (swapper == null || (newSprite = (class_1058)swapper.apply(sprite)) == null) continue;
                return newSprite;
            }
            return null;
        };
    }

    public static UnaryOperator<class_1058> getSwapper(@Nullable class_1767 color) {
        if (color == null) {
            return sprite -> null;
        }
        return sprite -> {
            if (sprite == SMALL_BUFFER_TEMPLATE.get() || sprite == SMALL_BUFFER_MONORAIL_TEMPLATE.get()) {
                return SMALL_BUFFER_COLORS.get(color).get();
            }
            if (sprite == BIG_BUFFER_TEMPLATE.get()) {
                return BIG_BUFFER_COLORS.get(color).get();
            }
            return null;
        };
    }

    private static class_1058 getSpriteOnSide(class_2680 state, class_2350 side) {
        class_1087 model = class_310.method_1551().method_1541().method_3349(state);
        if (model == null) {
            return null;
        }
        class_5819 random = class_5819.method_43047();
        random.method_43052(42L);
        List quads = model.method_4707(state, side, random);
        if (!quads.isEmpty()) {
            return ((class_777)quads.get(0)).method_35788();
        }
        random.method_43052(42L);
        quads = model.method_4707(state, null, random);
        if (!quads.isEmpty()) {
            for (class_777 quad : quads) {
                if (quad.method_3358() != side) continue;
                return quad.method_35788();
            }
        }
        return model.method_4711();
    }

    public static void register() {
    }

    static {
        for (class_1767 color : class_1767.values()) {
            BIG_BUFFER_COLORS.put(color, new StitchedSprite(Railways.asResource("block/buffer/big_buffer/big_buffer_" + color.method_7792())));
            SMALL_BUFFER_COLORS.put(color, new StitchedSprite(Railways.asResource("block/buffer/small_buffer/small_buffer_" + color.method_7792())));
        }
    }
}

