/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.baked;

import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.lib.model.ModelUtil;
import dev.engine_room.flywheel.lib.model.SimpleModel;
import dev.engine_room.flywheel.lib.model.SimpleQuadMesh;
import dev.engine_room.flywheel.lib.model.baked.BakedModelBufferer;
import dev.engine_room.flywheel.lib.model.baked.BakedModelBuilder;
import dev.engine_room.flywheel.lib.model.baked.ChunkLayerSortedListBuilder;
import dev.engine_room.flywheel.lib.model.baked.EmptyVirtualBlockGetter;
import dev.engine_room.flywheel.lib.model.baked.MeshHelper;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4587;

public final class FabricBakedModelBuilder
extends BakedModelBuilder {
    public FabricBakedModelBuilder(class_1087 bakedModel) {
        super(bakedModel);
    }

    @Override
    public FabricBakedModelBuilder level(class_1920 level) {
        super.level(level);
        return this;
    }

    @Override
    public FabricBakedModelBuilder pos(class_2338 pos) {
        super.pos(pos);
        return this;
    }

    @Override
    public FabricBakedModelBuilder poseStack(class_4587 poseStack) {
        super.poseStack(poseStack);
        return this;
    }

    @Override
    public FabricBakedModelBuilder materialFunc(BiFunction<class_1921, Boolean, Material> materialFunc) {
        super.materialFunc(materialFunc);
        return this;
    }

    @Override
    public SimpleModel build() {
        if (this.level == null) {
            this.level = EmptyVirtualBlockGetter.FULL_DARK;
        }
        if (this.pos == null) {
            this.pos = class_2338.field_10980;
        }
        if (this.materialFunc == null) {
            this.materialFunc = ModelUtil::getMaterial;
        }
        class_2680 blockState = this.level.method_8320(this.pos);
        ChunkLayerSortedListBuilder builder = ChunkLayerSortedListBuilder.getThreadLocal();
        BakedModelBufferer.bufferModel(this.bakedModel, this.pos, this.level, blockState, this.poseStack, (renderType, shaded, data) -> {
            Material material = (Material)this.materialFunc.apply(renderType, shaded);
            if (material != null) {
                SimpleQuadMesh mesh = MeshHelper.blockVerticesToMesh(data, "source=BakedModelBuilder,bakedModel=" + this.bakedModel + ",renderType=" + renderType + ",shaded=" + shaded);
                builder.add(renderType, new Model.ConfiguredMesh(material, mesh));
            }
        });
        return new SimpleModel((List<Model.ConfiguredMesh>)builder.build());
    }
}

