/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.baked;

import com.google.common.collect.ImmutableList;
import dev.engine_room.flywheel.lib.model.baked.BakedModelBufferer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.List;
import net.minecraft.class_1921;

class ChunkLayerSortedListBuilder<T> {
    private static final ThreadLocal<ChunkLayerSortedListBuilder<?>> THREAD_LOCAL = ThreadLocal.withInitial(ChunkLayerSortedListBuilder::new);
    private final ObjectArrayList<T>[] lists = new ObjectArrayList[BakedModelBufferer.CHUNK_LAYER_AMOUNT];
    private final Reference2ReferenceMap<class_1921, ObjectArrayList<T>> map = new Reference2ReferenceOpenHashMap();

    private ChunkLayerSortedListBuilder() {
        for (int layerIndex = 0; layerIndex < BakedModelBufferer.CHUNK_LAYER_AMOUNT; ++layerIndex) {
            ObjectArrayList list;
            class_1921 renderType = BakedModelBufferer.CHUNK_LAYERS[layerIndex];
            this.lists[layerIndex] = list = new ObjectArrayList();
            this.map.put((Object)renderType, (Object)list);
        }
    }

    public static <T> ChunkLayerSortedListBuilder<T> getThreadLocal() {
        return THREAD_LOCAL.get();
    }

    public void add(class_1921 renderType, T obj) {
        List list = (List)this.map.get((Object)renderType);
        if (list == null) {
            throw new IllegalArgumentException("RenderType '" + renderType + "' is not a chunk layer");
        }
        list.add(obj);
    }

    public ImmutableList<T> build() {
        int size = 0;
        for (ObjectArrayList<T> list : this.lists) {
            size += list.size();
        }
        Object[] array = new Object[size];
        int destPos = 0;
        for (ObjectArrayList<T> list : this.lists) {
            System.arraycopy(list.elements(), 0, array, destPos, list.size());
            destPos += list.size();
            list.clear();
        }
        return ImmutableList.copyOf((Object[])array);
    }
}

