/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.fixes.chunkio.threading_issues.common;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.locks.ReentrantLock;

public class SynchronizedCodec<A>
implements Codec<A> {
    private final ReentrantLock lock = new ReentrantLock(false);
    private final Codec<A> delegate;

    public SynchronizedCodec(Codec<A> delegate) {
        this.delegate = delegate;
    }

    public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
        try {
            this.lock.lockInterruptibly();
            DataResult dataResult = this.delegate.decode(ops, input);
            return dataResult;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
        try {
            this.lock.lockInterruptibly();
            DataResult dataResult = this.delegate.encode(input, ops, prefix);
            return dataResult;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    class ManagedLocker
    implements ForkJoinPool.ManagedBlocker {
        boolean hasLock = false;

        ManagedLocker() {
        }

        @Override
        public boolean block() {
            if (!this.hasLock) {
                SynchronizedCodec.this.lock.lock();
            }
            return true;
        }

        @Override
        public boolean isReleasable() {
            return this.hasLock || (this.hasLock = SynchronizedCodec.this.lock.tryLock());
        }
    }
}

