/*
 * Decompiled with CFR 0.152.
 */
package ace.actually.ccdrones.entities;

import ace.actually.ccdrones.entities.DroneEntity;
import dan200.computercraft.api.detail.BlockReference;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.filesystem.MountConstants;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.core.filesystem.FileSystemException;
import dan200.computercraft.core.filesystem.FileSystemWrapper;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class DroneAPI
implements ILuaAPI {
    DroneEntity drone;

    public DroneAPI(DroneEntity entity) {
        this.drone = entity;
    }

    public String[] getNames() {
        return new String[]{"drone"};
    }

    @LuaFunction
    public final void debug() {
        System.out.println(this.drone.method_23312().method_23854());
    }

    @LuaFunction
    public final void engineOn(boolean on) {
        this.drone.setEngineOn(on);
        if (!on) {
            this.drone.method_18799(class_243.field_1353);
        }
    }

    @LuaFunction
    public final void hoverOn(boolean on) {
        this.drone.method_5875(on);
    }

    @LuaFunction
    public final void right(int deg) {
        this.drone.method_5872(deg, 0.0);
    }

    @LuaFunction
    public final void left(int deg) {
        this.right(-deg);
    }

    @LuaFunction
    public final boolean isColliding() {
        return this.drone.field_5976;
    }

    @LuaFunction
    public final void up(int amount) {
        this.drone.method_45319(class_243.field_1353.method_1031(0.0, (double)amount / 10.0, 0.0));
    }

    @LuaFunction
    public final void down(int amount) {
        this.up(-amount);
    }

    @LuaFunction
    public final MethodResult lookForward() {
        class_3959 context = new class_3959(this.drone.method_23312().method_46558(), this.drone.method_23312().method_46558().method_1019(this.drone.method_5663().method_18805(3.0, 3.0, 3.0)), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)this.drone);
        class_3965 result = this.drone.method_37908().method_17742(context);
        return MethodResult.of((Object)VanillaDetailRegistries.BLOCK_IN_WORLD.getDetails((Object)new BlockReference(this.drone.method_37908(), result.method_17777())));
    }

    @LuaFunction
    public final float rotation() {
        return this.drone.field_5982;
    }

    @LuaFunction
    public final MethodResult lookBack() {
        class_3959 context = new class_3959(this.drone.method_23312().method_46558(), this.drone.method_23312().method_46558().method_1019(this.drone.method_5663().method_18805(-3.0, -3.0, -3.0)), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)this.drone);
        class_3965 result = this.drone.method_37908().method_17742(context);
        return MethodResult.of((Object)VanillaDetailRegistries.BLOCK_IN_WORLD.getDetails((Object)new BlockReference(this.drone.method_37908(), result.method_17777())));
    }

    @LuaFunction
    public final void breakForward() {
        class_3959 context = new class_3959(this.drone.method_23312().method_46558(), this.drone.method_23312().method_46558().method_1019(this.drone.method_5663().method_18805(3.0, 3.0, 3.0)), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)this.drone);
        class_3965 result = this.drone.method_37908().method_17742(context);
        this.drone.method_37908().method_8651(result.method_17777(), true, (class_1297)this.drone);
    }

    @LuaFunction(mainThread=true)
    public final void pickupBlock() {
        class_3959 context = new class_3959(this.drone.method_23312().method_46558(), this.drone.method_23312().method_46558().method_1031(0.0, -2.0, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)this.drone);
        class_3965 result = this.drone.method_37908().method_17742(context);
        this.drone.setCarrying(result.method_17777());
    }

    @LuaFunction(mainThread=true)
    public final void dropBlock() {
        class_3959 context = new class_3959(this.drone.method_23312().method_46558(), this.drone.method_23312().method_46558().method_1031(0.0, -2.0, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)this.drone);
        class_3965 result = this.drone.method_37908().method_17742(context);
        this.drone.dropCarrying(result.method_17777().method_10084());
    }

    @LuaFunction(mainThread=true)
    public final void pickUpEntity() {
        class_3959 context = new class_3959(this.drone.method_23312().method_46558(), this.drone.method_23312().method_46558().method_1031(0.0, -3.0, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)this.drone);
        class_3965 result = this.drone.method_37908().method_17742(context);
        List targets = this.drone.method_37908().method_18467(class_1297.class, new class_238(result.method_17777().method_10069(-2, -2, -2), result.method_17777().method_10069(2, 2, 2)));
        if (!targets.isEmpty()) {
            ((class_1297)targets.get(this.drone.method_6051().method_43048(targets.size()))).method_5804((class_1297)this.drone);
        }
    }

    @LuaFunction(mainThread=true)
    public final void dropEntity() {
        if (!this.drone.method_5685().isEmpty()) {
            this.drone.method_5772();
        }
    }

    public static void initDrive(ServerComputer computer) {
        try {
            if (!computer.getAPIEnvironment().getFileSystem().exists("/startup/go.lua")) {
                FileSystemWrapper file = computer.getAPIEnvironment().getFileSystem().openForWrite("/startup/go.lua", MountConstants.WRITE_OPTIONS);
                ((SeekableByteChannel)file.get()).write(ByteBuffer.wrap("drone.debug()\ndrone.engineOn(true)\ndrone.hoverOn(true)\ndrone.left(20)\ndrone.up(16)\nwhile true do\n\tdrone.lookForward()\nend".getBytes(StandardCharsets.UTF_8)));
                file.close();
                computer.reboot();
            }
        }
        catch (FileSystemException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

