/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.client;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.impl.networking.AbstractChanneledNetworkAddon;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class ClientPlayNetworkAddon
extends AbstractChanneledNetworkAddon<ClientPlayNetworking.PlayChannelHandler> {
    private final class_634 handler;
    private final class_310 client;
    private boolean sentInitialRegisterPacket;
    private static final Logger LOGGER = LogUtils.getLogger();

    public ClientPlayNetworkAddon(class_634 handler, class_310 client) {
        super(ClientNetworkingImpl.PLAY, handler.method_48296(), "ClientPlayNetworkAddon for " + handler.method_2879().getName());
        this.handler = handler;
        this.client = client;
        this.registerPendingChannels((ChannelInfoHolder)this.connection);
        this.receiver.startSession(this);
    }

    @Override
    public void lateInit() {
        for (Map.Entry entry : this.receiver.getHandlers().entrySet()) {
            this.registerChannel(entry.getKey(), (ClientPlayNetworking.PlayChannelHandler)entry.getValue());
        }
        ((ClientPlayConnectionEvents.Init)ClientPlayConnectionEvents.INIT.invoker()).onPlayInit(this.handler, this.client);
    }

    public void onServerReady() {
        try {
            ((ClientPlayConnectionEvents.Join)ClientPlayConnectionEvents.JOIN.invoker()).onPlayReady(this.handler, this, this.client);
        }
        catch (RuntimeException e) {
            LOGGER.error("Exception thrown while invoking ClientPlayConnectionEvents.JOIN", (Throwable)e);
        }
        this.sendInitialChannelRegistrationPacket();
        this.sentInitialRegisterPacket = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(class_2658 packet) {
        class_2540 buf = packet.method_11458();
        try {
            boolean bl = this.handle(packet.method_11456(), buf);
            return bl;
        }
        finally {
            buf.release();
        }
    }

    @Override
    protected void receive(ClientPlayNetworking.PlayChannelHandler handler, class_2540 buf) {
        handler.receive(this.client, this.handler, buf, this);
    }

    @Override
    protected void schedule(Runnable task) {
        class_310.method_1551().execute(task);
    }

    @Override
    public class_2596<?> createPacket(class_2960 channelName, class_2540 buf) {
        return ClientPlayNetworking.createC2SPacket(channelName, buf);
    }

    @Override
    protected void invokeRegisterEvent(List<class_2960> ids) {
        ((C2SPlayChannelEvents.Register)C2SPlayChannelEvents.REGISTER.invoker()).onChannelRegister(this.handler, this, this.client, ids);
    }

    @Override
    protected void invokeUnregisterEvent(List<class_2960> ids) {
        ((C2SPlayChannelEvents.Unregister)C2SPlayChannelEvents.UNREGISTER.invoker()).onChannelUnregister(this.handler, this, this.client, ids);
    }

    @Override
    protected void handleRegistration(class_2960 channelName) {
        class_2540 buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.REGISTER_CHANNEL, buf);
        }
    }

    @Override
    protected void handleUnregistration(class_2960 channelName) {
        class_2540 buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.UNREGISTER_CHANNEL, buf);
        }
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ClientPlayConnectionEvents.Disconnect)ClientPlayConnectionEvents.DISCONNECT.invoker()).onPlayDisconnect(this.handler, this.client);
        this.receiver.endSession(this);
    }

    @Override
    protected boolean isReservedChannel(class_2960 channelName) {
        return NetworkingImpl.isReservedPlayChannel(channelName);
    }
}

