/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.data;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_173;
import net.minecraft.class_2405;
import net.minecraft.class_2438;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_58;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7791;
import net.minecraft.class_8488;
import net.minecraft.class_8489;
import net.minecraft.class_8490;
import net.minecraft.class_8564;
import org.slf4j.Logger;

public class ModdedLootTableProvider
extends class_2438 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Set<class_2960> requiredTables;
    private final List<class_2438.class_7790> subProviders;

    public ModdedLootTableProvider(class_7784 packOutput, Set<class_2960> requiredTables, List<class_2438.class_7790> subProviders) {
        super(packOutput, requiredTables, subProviders);
        this.requiredTables = requiredTables;
        this.subProviders = subProviders;
    }

    public CompletableFuture<?> method_10319(class_7403 pOutput) {
        final HashMap map = Maps.newHashMap();
        Object2ObjectOpenHashMap map1 = new Object2ObjectOpenHashMap();
        this.getTables().forEach(arg_0 -> ModdedLootTableProvider.lambda$run$1((Map)map1, map, arg_0));
        class_58 validationcontext = new class_58(class_173.field_1177, new class_8489(){

            @Nullable
            public <T> T getElement(class_8488<T> p_279283_) {
                return (T)(p_279283_.comp_1474() == class_8490.field_44498 ? (class_52)map.get(p_279283_.comp_1475()) : null);
            }
        });
        this.validate(map, validationcontext);
        Multimap multimap = validationcontext.method_361();
        if (!multimap.isEmpty()) {
            multimap.forEach((p_124446_, p_124447_) -> LOGGER.warn("Found validation problem in {}: {}", p_124446_, p_124447_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(lootTableEntry -> {
            class_2960 lootTableId = (class_2960)lootTableEntry.getKey();
            class_52 loottable = (class_52)lootTableEntry.getValue();
            Path path = this.field_39374.method_44107(lootTableId);
            return class_2405.method_10320((class_7403)pOutput, (JsonElement)class_8490.field_44498.method_51203().toJsonTree((Object)loottable), (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public List<class_2438.class_7790> getTables() {
        return this.subProviders;
    }

    protected void validate(Map<class_2960, class_52> map, class_58 validationcontext) {
        for (class_2960 resourcelocation : Sets.difference(this.requiredTables, map.keySet())) {
            validationcontext.method_360("Missing built-in table: " + String.valueOf(resourcelocation));
        }
        map.forEach((id, lootTable) -> lootTable.method_330(validationcontext.method_22568(lootTable.method_322()).method_51219("{" + String.valueOf(id) + "}", new class_8488(class_8490.field_44498, id))));
    }

    public String method_10321() {
        return "LootTables";
    }

    private static /* synthetic */ void lambda$run$1(Map map1, Map map, class_2438.class_7790 entry) {
        ((class_7791)entry.comp_1068().get()).method_10399((key, builder) -> {
            class_2960 id = map1.put(class_8564.method_52171((class_2960)key), key);
            if (id != null) {
                class_156.method_33559((String)("Loot table random sequence seed collision on " + String.valueOf(id) + " and " + String.valueOf(key)));
            }
            builder.method_51883(key);
            if (map.put(key, builder.method_334(entry.comp_1069()).method_338()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(key));
            }
        });
    }
}

