/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunk_serializer.common;

import com.ishland.c2me.base.mixin.access.IBelowZeroRetrogen;
import com.ishland.c2me.base.mixin.access.IBlendingData;
import com.ishland.c2me.base.mixin.access.IChunkSection;
import com.ishland.c2me.base.mixin.access.IChunkTickScheduler;
import com.ishland.c2me.base.mixin.access.ISimpleTickScheduler;
import com.ishland.c2me.base.mixin.access.IState;
import com.ishland.c2me.base.mixin.access.IStructurePiece;
import com.ishland.c2me.base.mixin.access.IStructureStart;
import com.ishland.c2me.base.mixin.access.IUpgradeData;
import com.ishland.c2me.rewrites.chunk_serializer.common.ChunkStatusAccessor;
import com.ishland.c2me.rewrites.chunk_serializer.common.GenerationStepCarverAccessor;
import com.ishland.c2me.rewrites.chunk_serializer.common.HeightMapTypeAccessor;
import com.ishland.c2me.rewrites.chunk_serializer.common.NbtWriter;
import com.ishland.c2me.rewrites.chunk_serializer.common.utils.LithiumUtil;
import com.ishland.c2me.rewrites.chunk_serializer.common.utils.StarLightUtil;
import com.ishland.c2me.rewrites.chunk_serializer.mixin.IStarlightSaveState;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.LongStream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_155;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_1953;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2355;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2516;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_2839;
import net.minecraft.class_2841;
import net.minecraft.class_2843;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3227;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_6624;
import net.minecraft.class_6625;
import net.minecraft.class_6643;
import net.minecraft.class_6746;
import net.minecraft.class_6749;
import net.minecraft.class_6759;
import net.minecraft.class_6760;
import net.minecraft.class_6761;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class ChunkDataSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final byte[] STRING_DATA_VERSION = NbtWriter.getAsciiStringBytes("DataVersion");
    private static final byte[] STRING_X_POS = NbtWriter.getAsciiStringBytes("xPos");
    private static final byte[] STRING_Y_POS = NbtWriter.getAsciiStringBytes("yPos");
    private static final byte[] STRING_Z_POS = NbtWriter.getAsciiStringBytes("zPos");
    private static final byte[] STRING_LAST_UPDATE = NbtWriter.getAsciiStringBytes("LastUpdate");
    private static final byte[] STRING_INHABITED_TIME = NbtWriter.getAsciiStringBytes("InhabitedTime");
    private static final byte[] STRING_STATUS = NbtWriter.getAsciiStringBytes("Status");
    private static final byte[] STRING_BLENDING_DATA = NbtWriter.getAsciiStringBytes("blending_data");
    private static final byte[] STRING_BELOW_ZERO_RETROGEN = NbtWriter.getAsciiStringBytes("below_zero_retrogen");
    private static final byte[] STRING_UPGRADE_DATA = NbtWriter.getAsciiStringBytes("upgrade_data");
    private static final byte[] STRING_IS_LIGHT_ON = NbtWriter.getAsciiStringBytes("isLightOn");
    private static final byte[] STRING_BLOCK_ENTITIES = NbtWriter.getAsciiStringBytes("block_entities");
    private static final byte[] STRING_PALETTE = NbtWriter.getAsciiStringBytes("palette");
    private static final byte[] STRING_DATA = NbtWriter.getAsciiStringBytes("data");
    private static final byte[] STRING_SECTIONS = NbtWriter.getAsciiStringBytes("sections");
    private static final byte[] STRING_BLOCK_STATES = NbtWriter.getAsciiStringBytes("block_states");
    private static final byte[] STRING_BIOMES = NbtWriter.getAsciiStringBytes("biomes");
    private static final byte[] STRING_BLOCK_LIGHT = NbtWriter.getAsciiStringBytes("BlockLight");
    private static final byte[] STRING_SKY_LIGHT = NbtWriter.getAsciiStringBytes("SkyLight");
    private static final byte[] STRING_OLD_NOISE = NbtWriter.getAsciiStringBytes("old_noise");
    private static final byte[] STRING_HEIGHTS = NbtWriter.getAsciiStringBytes("heights");
    private static final byte[] STRING_MIN_SECTION = NbtWriter.getAsciiStringBytes("min_section");
    private static final byte[] STRING_MAX_SECTION = NbtWriter.getAsciiStringBytes("max_section");
    private static final byte[] STRING_TARGET_STATUS = NbtWriter.getAsciiStringBytes("target_status");
    private static final byte[] STRING_MISSING_BEDROCK = NbtWriter.getAsciiStringBytes("missing_bedrock");
    private static final byte[] STRING_INDICES = NbtWriter.getAsciiStringBytes("Indices");
    private static final byte[] STRING_SIDES = NbtWriter.getAsciiStringBytes("Sides");
    private static final byte[] STRING_ENTITIES = NbtWriter.getAsciiStringBytes("entities");
    private static final byte[] STRING_LIGHTS = NbtWriter.getAsciiStringBytes("Lights");
    private static final byte[] STRING_CARVING_MASKS = NbtWriter.getAsciiStringBytes("CarvingMasks");
    private static final byte[] STRING_HEIGHTMAPS = NbtWriter.getAsciiStringBytes("Heightmaps");
    private static final byte[] STRING_POST_PROCESSING = NbtWriter.getAsciiStringBytes("PostProcessing");
    private static final byte[] STRING_BLOCK_TICKS = NbtWriter.getAsciiStringBytes("block_ticks");
    private static final byte[] STRING_FLUID_TICKS = NbtWriter.getAsciiStringBytes("fluid_ticks");
    private static final byte[] STRING_STRUCTURES = NbtWriter.getAsciiStringBytes("structures");
    private static final byte[] STRING_STARTS = NbtWriter.getAsciiStringBytes("starts");
    private static final byte[] STRING_BIG_REFERENCES = NbtWriter.getAsciiStringBytes("References");
    private static final byte[] STRING_ID = NbtWriter.getAsciiStringBytes("id");
    private static final byte[] STRING_CHUNK_X = NbtWriter.getAsciiStringBytes("ChunkX");
    private static final byte[] STRING_CHUNK_Z = NbtWriter.getAsciiStringBytes("ChunkZ");
    private static final byte[] STRING_SMALL_REFERENCES = NbtWriter.getAsciiStringBytes("references");
    private static final byte[] STRING_CHILDREN = NbtWriter.getAsciiStringBytes("Children");
    private static final byte[] STRING_INVALID = NbtWriter.getAsciiStringBytes("INVALID");
    private static final byte[] STRING_BB = NbtWriter.getAsciiStringBytes("BB");
    private static final byte[] STRING_O = NbtWriter.getAsciiStringBytes("O");
    private static final byte[] STRING_GD = NbtWriter.getAsciiStringBytes("GD");
    private static final byte[] STRING_NAME = NbtWriter.getAsciiStringBytes("Name");
    private static final byte[] STRING_PROPERTIES = NbtWriter.getAsciiStringBytes("Properties");
    private static final byte[] STRING_CHAR_BIG_Y = NbtWriter.getAsciiStringBytes("Y");
    private static final byte[] STRING_CHAR_SMALL_I = NbtWriter.getAsciiStringBytes("i");
    private static final byte[] STRING_CHAR_SMALL_P = NbtWriter.getAsciiStringBytes("p");
    private static final byte[] STRING_CHAR_SMALL_T = NbtWriter.getAsciiStringBytes("t");
    private static final byte[] STRING_CHAR_SMALL_X = NbtWriter.getAsciiStringBytes("x");
    private static final byte[] STRING_CHAR_SMALL_Y = NbtWriter.getAsciiStringBytes("y");
    private static final byte[] STRING_CHAR_SMALL_Z = NbtWriter.getAsciiStringBytes("z");
    private static final byte[] STRING_C2ME = NbtWriter.getAsciiStringBytes("C2ME");
    private static final byte[] STRING_KROPPEB = NbtWriter.getAsciiStringBytes("Kroppeb was here :); Version: 0.3.0");
    private static final byte[] STRING_C2ME_MARK_A = NbtWriter.getAsciiStringBytes("C2ME::MarkA");
    private static final byte[] STRING_MARKER_FLUID_PROTO = NbtWriter.getAsciiStringBytes("fluid:proto");
    private static final byte[] STRING_MARKER_FLUID_FULL = NbtWriter.getAsciiStringBytes("fluid:full");
    private static final byte[] STRING_MARKER_FLUID_FALLBACK = NbtWriter.getAsciiStringBytes("fluid:fallback");
    private static final byte[] STRING_BLOCKLIGHT_STATE_TAG = NbtWriter.getAsciiStringBytes("starlight.blocklight_state");
    private static final byte[] STRING_SKYLIGHT_STATE_TAG = NbtWriter.getAsciiStringBytes("starlight.skylight_state");
    private static final byte[] STRING_STARLIGHT_VERSION_TAG = NbtWriter.getAsciiStringBytes("starlight.light_version");
    private static final int STARLIGHT_LIGHT_VERSION = 8;
    private static final boolean STARLIGHT = FabricLoader.getInstance().isModLoaded("starlight");

    public static void write(class_3218 world, class_2791 chunk, NbtWriter writer) {
        class_2843 upgradeData;
        class_6746 belowZeroRetrogen;
        class_1923 chunkPos = chunk.method_12004();
        writer.putString(STRING_C2ME, STRING_KROPPEB);
        writer.putInt(STRING_DATA_VERSION, class_155.method_16673().method_37912().method_38494());
        writer.putInt(STRING_X_POS, chunkPos.field_9181);
        writer.putInt(STRING_Y_POS, chunk.method_32891());
        writer.putInt(STRING_Z_POS, chunkPos.field_9180);
        writer.putLong(STRING_LAST_UPDATE, world.method_8510());
        writer.putLong(STRING_INHABITED_TIME, chunk.method_12033());
        writer.putString(STRING_STATUS, ((ChunkStatusAccessor)chunk.method_12009()).getIdBytes());
        class_6749 blendingData = chunk.method_39299();
        if (blendingData != null) {
            writer.startCompound(STRING_BLENDING_DATA);
            ChunkDataSerializer.writeBlendingData(writer, (IBlendingData)blendingData);
            writer.finishCompound();
        }
        if ((belowZeroRetrogen = chunk.method_39300()) != null) {
            writer.startCompound(STRING_BELOW_ZERO_RETROGEN);
            ChunkDataSerializer.writeBelowZeroRetrogen(writer, (IBelowZeroRetrogen)belowZeroRetrogen);
            writer.finishCompound();
        }
        if (!(upgradeData = chunk.method_12003()).method_12349()) {
            writer.startCompound(STRING_UPGRADE_DATA);
            ChunkDataSerializer.writeUpgradeData(writer, (IUpgradeData)upgradeData);
            writer.finishCompound();
        }
        class_2826[] chunkSections = chunk.method_12006();
        class_3227 lightingProvider = world.method_14178().method_17293();
        class_2378 biomeRegistry = world.method_30349().method_30530(class_7924.field_41236);
        ChunkDataSerializer.checkLightFlag(chunk, writer, world);
        ChunkDataSerializer.writeSectionData(writer, chunk, chunkPos, (IChunkSection[])chunkSections, (class_3568)lightingProvider, (class_2378<class_1959>)biomeRegistry);
        long blockEntitiesStart = writer.startList(STRING_BLOCK_ENTITIES, (byte)10);
        int blockEntitiesCount = 0;
        for (class_2338 bl2 : chunk.method_12021()) {
            class_2487 chunkNibbleArray = chunk.method_20598(bl2);
            if (chunkNibbleArray == null) continue;
            writer.putElementEntry((class_2520)chunkNibbleArray);
            ++blockEntitiesCount;
        }
        writer.finishList(blockEntitiesStart, blockEntitiesCount);
        if (chunk.method_12009().method_12164() == class_2806.class_2808.field_12808) {
            class_2839 j = (class_2839)chunk;
            List entities = j.method_12295();
            writer.startFixedList(STRING_ENTITIES, entities.size(), (byte)10);
            for (class_2487 entity : entities) {
                writer.putElementEntry((class_2520)entity);
            }
            writer.startCompound(STRING_CARVING_MASKS);
            for (class_2893.class_2894 carver : class_2893.class_2894.values()) {
                class_6643 carvingMask = j.method_12025(carver);
                if (carvingMask == null) continue;
                writer.putLongArray(((GenerationStepCarverAccessor)carver).getNameBytes(), carvingMask.method_38864());
            }
            writer.finishCompound();
        }
        ChunkDataSerializer.serializeTicks(writer, world, chunk.method_39296());
        ShortList[] postProcessingLists = chunk.method_12012();
        ChunkDataSerializer.putShortListArray(postProcessingLists, writer, STRING_POST_PROCESSING);
        writer.startCompound(STRING_HEIGHTMAPS);
        for (Map.Entry entry : chunk.method_12011()) {
            if (!chunk.method_12009().method_12160().contains(entry.getKey())) continue;
            writer.putLongArray(((HeightMapTypeAccessor)entry.getKey()).getNameBytes(), ((class_2902)entry.getValue()).method_12598());
        }
        writer.finishCompound();
        ChunkDataSerializer.writeStructures(writer, class_6625.method_38713((class_3218)world), chunkPos, chunk.method_12016(), chunk.method_12179());
    }

    private static void checkLightFlag(class_2791 chunk, NbtWriter writer, class_3218 world) {
        if (STARLIGHT) {
            if (chunk.method_12038()) {
                writer.putBoolean(STRING_IS_LIGHT_ON, false);
            }
        } else if (chunk.method_12038()) {
            writer.putBoolean(STRING_IS_LIGHT_ON, true);
        }
    }

    private static void putShortListArray(ShortList[] data, NbtWriter writer, byte[] name) {
        writer.startFixedList(name, data.length, (byte)9);
        for (ShortList shortList : data) {
            if (shortList != null) {
                writer.startFixedListEntry(shortList.size(), (byte)2);
                for (Short short_ : shortList) {
                    writer.putShortEntry(short_);
                }
                continue;
            }
            writer.startFixedListEntry(0, (byte)0);
        }
    }

    private static void writeSectionData(NbtWriter writer, class_2791 chunk, class_1923 chunkPos, IChunkSection[] chunkSections, class_3568 lightingProvider, class_2378<class_1959> biomeRegistry) {
        if (STARLIGHT) {
            ChunkDataSerializer.writeSectionDataStarlight(writer, chunk, chunkPos, chunkSections, lightingProvider, biomeRegistry);
        } else {
            ChunkDataSerializer.writeSectionDataVanilla(writer, chunk, chunkPos, chunkSections, lightingProvider, biomeRegistry);
        }
    }

    private static void writeSectionDataVanilla(NbtWriter writer, class_2791 chunk, class_1923 chunkPos, IChunkSection[] chunkSections, class_3568 lightingProvider, class_2378<class_1959> biomeRegistry) {
        long sectionsStart = writer.startList(STRING_SECTIONS, (byte)10);
        int sectionCount = 0;
        for (int i = lightingProvider.method_31929(); i < lightingProvider.method_31930(); ++i) {
            int index = chunk.method_31603(i);
            boolean bl2 = index >= 0 && index < chunkSections.length;
            class_2804 blockLight = lightingProvider.method_15562(class_1944.field_9282).method_15544(class_4076.method_18681((class_1923)chunkPos, (int)i));
            class_2804 skyLight = lightingProvider.method_15562(class_1944.field_9284).method_15544(class_4076.method_18681((class_1923)chunkPos, (int)i));
            if (!bl2 && blockLight == null && skyLight == null) continue;
            boolean hasInner = false;
            if (bl2) {
                hasInner = true;
                writer.compoundEntryStart();
                IChunkSection chunkSection = chunkSections[index];
                ChunkDataSerializer.writeBlockStates(writer, (class_2841<class_2680>)chunkSection.getBlockStateContainer());
                ChunkDataSerializer.writeBiomes(writer, (class_7522<class_6880<class_1959>>)chunkSection.getBiomeContainer(), biomeRegistry);
            }
            if (blockLight != null && !blockLight.method_12146()) {
                if (!hasInner) {
                    writer.compoundEntryStart();
                    hasInner = true;
                }
                writer.putByteArray(STRING_BLOCK_LIGHT, blockLight.method_12137());
            }
            if (skyLight != null && !skyLight.method_12146()) {
                if (!hasInner) {
                    writer.compoundEntryStart();
                    hasInner = true;
                }
                writer.putByteArray(STRING_SKY_LIGHT, skyLight.method_12137());
            }
            if (!hasInner) continue;
            writer.putByte(STRING_CHAR_BIG_Y, (byte)i);
            writer.finishCompound();
            ++sectionCount;
        }
        writer.finishList(sectionsStart, sectionCount);
    }

    private static void writeSectionDataStarlight(NbtWriter writer, class_2791 chunk, class_1923 chunkPos, IChunkSection[] chunkSections, class_3568 lightingProvider, class_2378<class_1959> biomeRegistry) {
        int minSection;
        boolean lit = chunk.method_12038();
        class_2806 status = chunk.method_12009();
        boolean shouldWrite = lit && status.method_12165(class_2806.field_12805);
        Object[] blockNibbles = StarLightUtil.getBlockNibbles(chunk);
        Object[] skyNibbles = StarLightUtil.getSkyNibbles(chunk);
        long sectionsStart = writer.startList(STRING_SECTIONS, (byte)10);
        int sectionCount = 0;
        for (int i = minSection = lightingProvider.method_31929(); i < lightingProvider.method_31930(); ++i) {
            IStarlightSaveState skyNibble;
            int index = chunk.method_31603(i);
            boolean bl2 = index >= 0 && index < chunkSections.length;
            IStarlightSaveState blockNibble = shouldWrite ? StarLightUtil.getSaveState(blockNibbles[i - minSection]) : null;
            IStarlightSaveState iStarlightSaveState = skyNibble = shouldWrite ? StarLightUtil.getSaveState(skyNibbles[i - minSection]) : null;
            if (!bl2 && blockNibble == null && skyNibble == null) continue;
            boolean hasInner = false;
            if (bl2) {
                hasInner = true;
                writer.compoundEntryStart();
                IChunkSection chunkSection = chunkSections[index];
                ChunkDataSerializer.writeBlockStates(writer, (class_2841<class_2680>)chunkSection.getBlockStateContainer());
                ChunkDataSerializer.writeBiomes(writer, (class_7522<class_6880<class_1959>>)chunkSection.getBiomeContainer(), biomeRegistry);
            }
            if (blockNibble != null) {
                if (blockNibble.getData() != null) {
                    writer.putByteArray(STRING_BLOCK_LIGHT, blockNibble.getData());
                }
                writer.putInt(STRING_BLOCKLIGHT_STATE_TAG, blockNibble.getState());
            }
            if (skyNibble != null) {
                if (skyNibble.getData() != null) {
                    writer.putByteArray(STRING_SKY_LIGHT, skyNibble.getData());
                }
                writer.putInt(STRING_SKYLIGHT_STATE_TAG, skyNibble.getState());
            }
            if (!hasInner) continue;
            writer.putByte(STRING_CHAR_BIG_Y, (byte)i);
            writer.finishCompound();
            ++sectionCount;
        }
        writer.finishList(sectionsStart, sectionCount);
        if (lit) {
            writer.putInt(STRING_STARLIGHT_VERSION_TAG, 8);
        }
    }

    private static void writeBlockStates(NbtWriter writer, class_2841<class_2680> blockStateContainer) {
        writer.startCompound(STRING_BLOCK_STATES);
        class_7522.class_6562 data = blockStateContainer.method_44345((class_2359)class_2248.field_10651, class_2841.class_6563.field_34569);
        List paletteEntries = data.comp_75();
        writer.startFixedList(STRING_PALETTE, paletteEntries.size(), (byte)10);
        for (class_2680 paletteEntry : paletteEntries) {
            writer.compoundEntryStart();
            writer.putRegistry(STRING_NAME, class_7923.field_41175, paletteEntry.method_26204());
            if (!paletteEntry.method_11656().isEmpty()) {
                writer.putElement(STRING_PROPERTIES, (class_2520)((IState)paletteEntry).getCodec().codec().encodeStart((DynamicOps)class_2509.field_11560, (Object)paletteEntry).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
            }
            writer.finishCompound();
        }
        Optional storage = data.comp_76();
        if (storage.isPresent()) {
            writer.putLongArray(STRING_DATA, ((LongStream)storage.get()).toArray());
        }
        writer.finishCompound();
    }

    private static void writeBiomes(NbtWriter writer, class_7522<class_6880<class_1959>> biomeContainer, class_2378<class_1959> biomeRegistry) {
        writer.startCompound(STRING_BIOMES);
        class_7522.class_6562 data = biomeContainer.method_44345(biomeRegistry.method_40295(), class_2841.class_6563.field_34570);
        List paletteEntries = data.comp_75();
        writer.startFixedList(STRING_PALETTE, paletteEntries.size(), (byte)8);
        for (class_6880 paletteEntry : paletteEntries) {
            writer.putRegistryEntry(paletteEntry);
        }
        Optional storage = data.comp_76();
        if (storage.isPresent()) {
            writer.putLongArray(STRING_DATA, ((LongStream)storage.get()).toArray());
        }
        writer.finishCompound();
    }

    private static void writeBlendingData(NbtWriter writer, IBlendingData blendingData) {
        double[] heights;
        writer.putInt(STRING_MIN_SECTION, blendingData.getOldHeightLimit().method_32891());
        writer.putInt(STRING_MAX_SECTION, blendingData.getOldHeightLimit().method_31597());
        for (double d : heights = blendingData.getSurfaceHeights()) {
            if (d == Double.MAX_VALUE) continue;
            writer.putDoubles(STRING_HEIGHTS, heights);
            return;
        }
        writer.startFixedList(STRING_HEIGHTS, 0, (byte)6);
    }

    private static void writeBelowZeroRetrogen(NbtWriter writer, IBelowZeroRetrogen belowZeroRetrogen) {
        writer.putRegistry(STRING_TARGET_STATUS, class_7923.field_41184, belowZeroRetrogen.invokeGetTargetStatus());
        BitSet missingBedrock = belowZeroRetrogen.getMissingBedrock();
        if (!missingBedrock.isEmpty()) {
            writer.putLongArray(STRING_MISSING_BEDROCK, missingBedrock.toLongArray());
        }
    }

    private static void writeUpgradeData(NbtWriter writer, IUpgradeData upgradeData) {
        int i;
        long indicesStart = -1L;
        int indicesCount = 0;
        int[][] centerIndicesToUpgrade = upgradeData.getCenterIndicesToUpgrade();
        for (i = 0; i < centerIndicesToUpgrade.length; ++i) {
            if (centerIndicesToUpgrade[i] == null || centerIndicesToUpgrade[i].length == 0) continue;
            String string = String.valueOf(i);
            if (indicesStart == -1L) {
                indicesStart = writer.startList(STRING_INDICES, (byte)11);
            }
            ++indicesCount;
            writer.putIntArray(NbtWriter.getAsciiStringBytes(string), centerIndicesToUpgrade[i]);
        }
        if (indicesStart != -1L) {
            writer.finishList(indicesStart, indicesCount);
        }
        i = 0;
        for (class_2355 eightWayDirection : upgradeData.getSidesToUpgrade()) {
            i |= 1 << eightWayDirection.ordinal();
        }
        writer.putByte(STRING_SIDES, (byte)i);
    }

    @Deprecated
    public static class_2499 toNbt(ShortList[] lists) {
        class_2499 nbtList = new class_2499();
        for (ShortList shortList : lists) {
            class_2499 nbtList2 = new class_2499();
            if (shortList != null) {
                for (Short short_ : shortList) {
                    nbtList2.add((Object)class_2516.method_23254((short)short_));
                }
            }
            nbtList.add((Object)nbtList2);
        }
        return nbtList;
    }

    private static void serializeTicks(NbtWriter writer, class_3218 world, class_2791.class_6745 tickSchedulers) {
        long time = world.method_8401().method_188();
        ChunkDataSerializer.writeTicks(writer, time, tickSchedulers.comp_239(), class_7923.field_41175, STRING_BLOCK_TICKS);
        ChunkDataSerializer.writeTicks(writer, time, tickSchedulers.comp_240(), class_7923.field_41173, STRING_FLUID_TICKS);
    }

    private static <T> void writeTicks(NbtWriter writer, long time, class_6761<T> scheduler, class_7922<T> reg, byte[] key) {
        if (scheduler instanceof ISimpleTickScheduler) {
            ISimpleTickScheduler simpleTickSchedulerAccessor = (ISimpleTickScheduler)scheduler;
            List scheduledTicks = simpleTickSchedulerAccessor.getScheduledTicks();
            writer.startFixedList(key, scheduledTicks.size(), (byte)10);
            for (class_6759 scheduledTick : scheduledTicks) {
                ChunkDataSerializer.writeTick(writer, scheduledTick, reg);
            }
        } else if (scheduler instanceof IChunkTickScheduler) {
            IChunkTickScheduler chunkTickSchedulerAccess = (IChunkTickScheduler)scheduler;
            int size = 0;
            long list = writer.startList(key, (byte)10);
            @Nullable List scheduledTicks = chunkTickSchedulerAccess.getTicks();
            if (scheduledTicks != null) {
                size += scheduledTicks.size();
                for (class_6759 scheduledTick : scheduledTicks) {
                    ChunkDataSerializer.writeTick(writer, scheduledTick, reg);
                }
            }
            if (LithiumUtil.IS_LITHIUM_TICK_QUEUE_ACTIVE) {
                Collection tickQueues = LithiumUtil.getTickQueueCollection(chunkTickSchedulerAccess);
                for (Collection tickQueue : tickQueues) {
                    size += tickQueue.size();
                    for (class_6760 orderedTick : tickQueue) {
                        ChunkDataSerializer.writeOrderedTick(writer, orderedTick, time, reg);
                    }
                }
            } else {
                Queue tickQueue = chunkTickSchedulerAccess.getTickQueue();
                size += tickQueue.size();
                for (class_6760 orderedTick : tickQueue) {
                    ChunkDataSerializer.writeOrderedTick(writer, orderedTick, time, reg);
                }
            }
            writer.finishList(list, size);
        } else {
            writer.putElement(key, scheduler.method_20463(time, block -> reg.method_10221(block).toString()));
        }
    }

    private static <T> void writeOrderedTick(NbtWriter writer, class_6760<T> orderedTick, long time, class_2378<T> reg) {
        writer.compoundEntryStart();
        writer.putRegistry(STRING_CHAR_SMALL_I, reg, orderedTick.comp_252());
        ChunkDataSerializer.writeGenericTickData(writer, orderedTick.comp_253(), (int)(orderedTick.comp_254() - time), orderedTick.comp_255());
        writer.finishCompound();
    }

    private static <T> void writeTick(NbtWriter writer, class_6759<T> scheduledTick, class_2378<T> reg) {
        writer.compoundEntryStart();
        writer.putRegistry(STRING_CHAR_SMALL_I, reg, scheduledTick.comp_248());
        ChunkDataSerializer.writeGenericTickData(writer, scheduledTick);
        writer.finishCompound();
    }

    private static void writeGenericTickData(NbtWriter writer, class_6759<?> scheduledTick) {
        ChunkDataSerializer.writeGenericTickData(writer, scheduledTick.comp_249(), scheduledTick.comp_250(), scheduledTick.comp_251());
    }

    private static void writeGenericTickData(NbtWriter writer, class_2338 pos, int delay, class_1953 priority) {
        writer.putInt(STRING_CHAR_SMALL_X, pos.method_10263());
        writer.putInt(STRING_CHAR_SMALL_Y, pos.method_10264());
        writer.putInt(STRING_CHAR_SMALL_Z, pos.method_10260());
        writer.putInt(STRING_CHAR_SMALL_T, delay);
        writer.putInt(STRING_CHAR_SMALL_P, priority.method_8681());
    }

    private static void writeStructures(NbtWriter writer, class_6625 context, class_1923 pos, Map<class_3195, class_3449> starts, Map<class_3195, LongSet> references) {
        writer.startCompound(STRING_STRUCTURES);
        writer.startCompound(STRING_STARTS);
        class_2378 configuredStructureFeatureRegistry = context.comp_134().method_30530(class_7924.field_41246);
        for (Map.Entry<class_3195, class_3449> entry : starts.entrySet()) {
            writer.startCompound(NbtWriter.getNameBytesFromRegistry(configuredStructureFeatureRegistry, entry.getKey()));
            IStructureStart value = (IStructureStart)ChunkDataSerializer.cast(entry.getValue());
            ChunkDataSerializer.writeStructureStart(writer, value, context, pos);
            writer.finishCompound();
        }
        writer.finishCompound();
        writer.startCompound(STRING_BIG_REFERENCES);
        for (Map.Entry<class_3195, class_3449> entry : references.entrySet()) {
            if (((LongSet)entry.getValue()).isEmpty()) continue;
            writer.putLongArray(NbtWriter.getNameBytesFromRegistry(configuredStructureFeatureRegistry, entry.getKey()), (LongCollection)entry.getValue());
        }
        writer.finishCompound();
        writer.finishCompound();
    }

    private static void writeStructureStart(NbtWriter writer, IStructureStart structureStart, class_6625 context, class_1923 pos) {
        class_6624 children = structureStart.getChildren();
        if (children.method_38708()) {
            writer.putString(STRING_ID, STRING_INVALID);
            return;
        }
        writer.putRegistry(STRING_ID, context.comp_134().method_30530(class_7924.field_41246), structureStart.getStructure());
        writer.putInt(STRING_CHUNK_X, pos.field_9181);
        writer.putInt(STRING_CHUNK_Z, pos.field_9180);
        writer.putInt(STRING_SMALL_REFERENCES, structureStart.getReferences());
        writer.startFixedList(STRING_CHILDREN, children.comp_132().size(), (byte)10);
        for (class_3443 piece : children.comp_132()) {
            writer.putElementEntry((class_2520)piece.method_14946(context));
        }
    }

    private static void writeStructurePiece(NbtWriter writer, IStructurePiece structurePiece, class_6625 context) {
        class_2350 direction;
        writer.compoundEntryStart();
        writer.putRegistry(STRING_ID, class_7923.field_41146, structurePiece.getType());
        Optional optional = class_3341.field_29325.encodeStart((DynamicOps)class_2509.field_11560, (Object)structurePiece.getBoundingBox()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
        if (optional.isPresent()) {
            writer.putElement(STRING_BB, (class_2520)optional.get());
        }
        writer.putInt(STRING_O, (direction = structurePiece.getFacing()) == null ? -1 : direction.method_10161());
        writer.putInt(STRING_GD, structurePiece.getChainLength());
        writer.finishCompound();
    }

    @Contract(value="null -> null; !null -> !null")
    private static <T> T cast(Object entry) {
        return (T)entry;
    }
}

