/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.conditions;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3505;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7696;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceConditionsImpl {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Fabric Resource Conditions");
    public static final ThreadLocal<Map<class_5321<?>, Map<class_2960, Collection<class_6880<?>>>>> LOADED_TAGS = new ThreadLocal();
    public static final ThreadLocal<class_7699> CURRENT_FEATURES = ThreadLocal.withInitial(() -> class_7701.field_40183);
    public static final ThreadLocal<class_5455.class_6890> CURRENT_REGISTRIES = new ThreadLocal();

    public static ConditionJsonProvider array(final class_2960 id, final ConditionJsonProvider ... values) {
        Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0, (Object)"Must register at least one value.");
        return new ConditionJsonProvider(){

            @Override
            public class_2960 getConditionId() {
                return id;
            }

            @Override
            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (ConditionJsonProvider provider : values) {
                    array.add((JsonElement)provider.toJson());
                }
                object.add("values", (JsonElement)array);
            }
        };
    }

    public static ConditionJsonProvider mods(final class_2960 id, final String ... modIds) {
        Preconditions.checkArgument((modIds.length > 0 ? 1 : 0) != 0, (Object)"Must register at least one mod id.");
        return new ConditionJsonProvider(){

            @Override
            public class_2960 getConditionId() {
                return id;
            }

            @Override
            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (String modId : modIds) {
                    array.add(modId);
                }
                object.add("values", (JsonElement)array);
            }
        };
    }

    @SafeVarargs
    public static <T> ConditionJsonProvider tagsPopulated(final class_2960 id, final boolean includeRegistry, final class_6862<T> ... tags) {
        Preconditions.checkArgument((tags.length > 0 ? 1 : 0) != 0, (Object)"Must register at least one tag.");
        final class_5321 registryRef = tags[0].comp_326();
        return new ConditionJsonProvider(){

            @Override
            public class_2960 getConditionId() {
                return id;
            }

            @Override
            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (class_6862 tag : tags) {
                    array.add(tag.comp_327().toString());
                }
                object.add("values", (JsonElement)array);
                if (includeRegistry && registryRef != class_7924.field_41197) {
                    object.addProperty("registry", registryRef.method_29177().toString());
                }
            }
        };
    }

    public static ConditionJsonProvider featuresEnabled(final class_2960 id, class_7696 ... features) {
        final TreeSet ids = new TreeSet(class_7701.field_40180.method_45392(class_7701.field_40180.method_45390(features)));
        return new ConditionJsonProvider(){

            @Override
            public class_2960 getConditionId() {
                return id;
            }

            @Override
            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (class_2960 id2 : ids) {
                    array.add(id2.toString());
                }
                object.add("features", (JsonElement)array);
            }
        };
    }

    public static ConditionJsonProvider registryContains(final class_2960 id, final class_2960 registry, final class_2960 ... entries) {
        Preconditions.checkArgument((entries.length > 0 ? 1 : 0) != 0, (Object)"Must register at least one entry.");
        return new ConditionJsonProvider(){

            @Override
            public class_2960 getConditionId() {
                return id;
            }

            @Override
            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (class_2960 entry : entries) {
                    array.add(entry.toString());
                }
                object.add("values", (JsonElement)array);
                if (!class_7924.field_41197.method_29177().equals((Object)registry)) {
                    object.addProperty("registry", registry.toString());
                }
            }
        };
    }

    public static boolean modsLoadedMatch(JsonObject object, boolean and) {
        JsonArray array = class_3518.method_15261((JsonObject)object, (String)"values");
        for (JsonElement element : array) {
            if (element.isJsonPrimitive()) {
                if (FabricLoader.getInstance().isModLoaded(element.getAsString()) == and) continue;
                return !and;
            }
            throw new JsonParseException("Invalid mod id entry: " + String.valueOf(element));
        }
        return and;
    }

    public static void setTags(List<class_3505.class_6863<?>> tags) {
        HashMap<class_5321, Map> tagMap = new HashMap<class_5321, Map>();
        for (class_3505.class_6863<?> registryTags : tags) {
            tagMap.put(registryTags.comp_328(), registryTags.comp_329());
        }
        LOADED_TAGS.set(tagMap);
    }

    public static boolean tagsPopulatedMatch(JsonObject object) {
        String key = class_3518.method_15253((JsonObject)object, (String)"registry", (String)"minecraft:item");
        class_5321 registryRef = class_5321.method_29180((class_2960)new class_2960(key));
        return ResourceConditionsImpl.tagsPopulatedMatch(object, registryRef);
    }

    public static boolean tagsPopulatedMatch(JsonObject object, class_5321<? extends class_2378<?>> registryKey) {
        JsonArray array = class_3518.method_15261((JsonObject)object, (String)"values");
        @Nullable Map<class_5321<?>, Map<class_2960, Collection<class_6880<?>>>> allTags = LOADED_TAGS.get();
        if (allTags == null) {
            LOGGER.warn("Can't retrieve deserialized tags. Failing tags_populated resource condition check.");
            return false;
        }
        Map<class_2960, Collection<class_6880<?>>> registryTags = allTags.get(registryKey);
        if (registryTags == null) {
            return array.isEmpty();
        }
        for (JsonElement element : array) {
            if (element.isJsonPrimitive()) {
                class_2960 id = new class_2960(element.getAsString());
                Collection<class_6880<?>> tags = registryTags.get(id);
                if (tags != null && !tags.isEmpty()) continue;
                return false;
            }
            throw new JsonParseException("Invalid tag id entry: " + String.valueOf(element));
        }
        return true;
    }

    public static boolean featuresEnabledMatch(JsonObject object) {
        List<class_2960> featureIds = class_3518.method_15261((JsonObject)object, (String)"features").asList().stream().map(element -> new class_2960(element.getAsString())).toList();
        class_7699 set = class_7701.field_40180.method_45388(featureIds, id -> {
            throw new JsonParseException("Unknown feature flag: " + String.valueOf(id));
        });
        return set.method_45400(CURRENT_FEATURES.get());
    }

    public static boolean registryContainsMatch(JsonObject object) {
        String key = class_3518.method_15253((JsonObject)object, (String)"registry", (String)"minecraft:item");
        class_5321 registryRef = class_5321.method_29180((class_2960)new class_2960(key));
        return ResourceConditionsImpl.registryContainsMatch(object, registryRef);
    }

    private static <E> boolean registryContainsMatch(JsonObject object, class_5321<? extends class_2378<? extends E>> registryRef) {
        JsonArray array = class_3518.method_15261((JsonObject)object, (String)"values");
        class_5455.class_6890 registries = CURRENT_REGISTRIES.get();
        if (registries == null) {
            LOGGER.warn("Can't retrieve current registries. Failing registry_contains resource condition check.");
            return false;
        }
        Optional registry = registries.method_33310(registryRef);
        if (registry.isEmpty()) {
            return array.isEmpty();
        }
        for (JsonElement element : array) {
            if (element.isJsonPrimitive()) {
                class_2960 id = new class_2960(element.getAsString());
                if (((class_2378)registry.get()).method_10250(id)) continue;
                return false;
            }
            throw new JsonParseException("Invalid registry entry id: " + String.valueOf(element));
        }
        return true;
    }
}

