/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.ui;

import java.util.Locale;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.foundation.PonderTag;
import net.minecraft.class_1799;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class PonderButton
extends BoxWidget {
    public static final Couple<Color> COLOR_IDLE = Couple.create(new Color(1623245055, true), new Color(817938687, true)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_HOVER = Couple.create(new Color(-255803137, true), new Color(-1597980417, true)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_CLICK = Couple.create(new Color(-1, true), new Color(-570425345, true)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_DISABLED = Couple.create(new Color(-2138009456, true), new Color(0x20909090, true)).map(Color::setImmutable);
    @Nullable
    protected class_1799 item;
    @Nullable
    protected PonderTag tag;
    @Nullable
    protected class_304 shortcut;
    protected LerpedFloat flash = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.EXP);

    public PonderButton(int x, int y) {
        this(x, y, 20, 20);
    }

    public PonderButton(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.z = 420.0f;
        this.paddingX = 2.0f;
        this.paddingY = 2.0f;
        this.colorIdle = COLOR_IDLE;
        this.colorHover = COLOR_HOVER;
        this.colorClick = COLOR_CLICK;
        this.colorDisabled = COLOR_DISABLED;
        this.updateGradientFromState();
    }

    public <T extends PonderButton> T withShortcut(class_304 key) {
        this.shortcut = key;
        return (T)this;
    }

    public <T extends PonderButton> T showingTag(PonderTag tag) {
        this.tag = tag;
        return (T)((PonderButton)this.showing(this.tag));
    }

    public <T extends PonderButton> T showing(class_1799 item) {
        this.item = item;
        return (T)((PonderButton)super.showingElement((RenderElement)GuiGameElement.of(item).scale(1.5).at(-4.0f, -4.0f)));
    }

    public void flash() {
        this.flash.updateChaseTarget(1.0f);
    }

    public void dim() {
        this.flash.updateChaseTarget(0.0f);
    }

    @Override
    public void tick() {
        super.tick();
        this.flash.tickChaser();
    }

    @Override
    protected void beforeRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.beforeRender(graphics, mouseX, mouseY, partialTicks);
        float flashValue = this.flash.getValue(partialTicks);
        if (flashValue > 0.1f) {
            float sin = 0.5f + 0.5f * class_3532.method_15374((float)(((float)AnimationTickHolder.getTicks(true) + partialTicks) / 10.0f));
            Color nc1 = new Color(255, 255, 255, class_3532.method_15340((int)(((Color)this.gradientColor.getFirst()).getAlpha() + 150), (int)0, (int)255));
            Color nc2 = new Color(155, 155, 155, class_3532.method_15340((int)(((Color)this.gradientColor.getSecond()).getAlpha() + 150), (int)0, (int)255));
            Couple<Color> newColors = Couple.create(nc1, nc2);
            float finalSin = sin *= flashValue;
            this.gradientColor = this.gradientColor.mapWithParams((color, other) -> color.mixWith((Color)other, finalSin), newColors);
        }
    }

    @Override
    public void doRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.doRender(graphics, mouseX, mouseY, partialTicks);
        if (!this.isVisible()) {
            return;
        }
        if (this.shortcut != null) {
            class_4587 poseStack = graphics.method_51448();
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, this.z + 10.0f);
            graphics.method_25300(class_310.method_1551().field_1772, this.shortcut.method_16007().getString().toLowerCase(Locale.ROOT), this.method_46426() + this.field_22758 / 2 + 8, this.method_46427() + this.field_22759 - 6, ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).scaleAlpha(this.fade.getValue()).getRGB());
            poseStack.method_22909();
        }
    }

    public boolean method_25370() {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.shortcut != null && this.shortcut.method_1417(keyCode, scanCode)) {
            this.gradientColor = this.getColorClick();
            this.startGradientAnimation(this.getColorForState(), 0.15);
            this.runCallback((float)this.field_22758 / 2.0f, (float)this.field_22759 / 2.0f);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected boolean method_25351(int i) {
        return this.isVisible();
    }

    @Nullable
    public class_1799 getItem() {
        return this.item;
    }

    @Nullable
    public PonderTag getTag() {
        return this.tag;
    }

    public boolean isVisible() {
        return !(this.fade.getValue() < 0.1f);
    }
}

