/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.element;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import javax.annotation.Nullable;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.InputElementBuilder;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.element.AnimatedOverlayElementBase;
import net.createmod.ponder.foundation.ui.PonderUI;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class InputWindowElement
extends AnimatedOverlayElementBase {
    private final class_243 sceneSpace;
    private final Pointing direction;
    @Nullable
    class_2960 key;
    @Nullable
    ScreenElement icon;
    class_1799 item = class_1799.field_8037;

    public InputWindowElement(class_243 sceneSpace, Pointing direction) {
        this.sceneSpace = sceneSpace;
        this.direction = direction;
    }

    public InputElementBuilder builder() {
        return new Builder();
    }

    @Override
    public void render(PonderScene scene, PonderUI screen, class_332 graphics, float partialTicks, float fade) {
        String text;
        float xFade;
        class_327 font = screen.getFontRenderer();
        int width = 0;
        int height = 0;
        float f = this.direction == Pointing.RIGHT ? -1.0f : (xFade = this.direction == Pointing.LEFT ? 1.0f : 0.0f);
        float yFade = this.direction == Pointing.DOWN ? -1.0f : (this.direction == Pointing.UP ? 1.0f : 0.0f);
        xFade *= 10.0f * (1.0f - fade);
        yFade *= 10.0f * (1.0f - fade);
        boolean hasItem = !this.item.method_7960();
        boolean hasText = this.key != null;
        boolean hasIcon = this.icon != null;
        int keyWidth = 0;
        String string = text = hasText ? PonderIndex.getLangAccess().getShared(this.key) : "";
        if (fade < 0.0625f) {
            return;
        }
        class_241 sceneToScreen = scene.getTransform().sceneToScreen(this.sceneSpace, partialTicks);
        if (hasIcon) {
            width += 24;
            height = 24;
        }
        if (hasText) {
            keyWidth = font.method_1727(text);
            width += keyWidth;
        }
        if (hasItem) {
            width += 24;
            height = 24;
        }
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(sceneToScreen.field_1343 + xFade, sceneToScreen.field_1342 + yFade, 400.0f);
        PonderUI.renderSpeechBox(graphics, 0, 0, width, height, false, this.direction, true);
        poseStack.method_46416(0.0f, 0.0f, 100.0f);
        if (hasText) {
            Objects.requireNonNull(font);
            graphics.method_51433(font, text, 2, (int)((float)(height - 9) / 2.0f + 2.0f), PonderPalette.WHITE.getColorObject().scaleAlpha(fade).getRGB(), false);
        }
        if (hasIcon) {
            poseStack.method_22903();
            poseStack.method_46416((float)keyWidth, 0.0f, 0.0f);
            poseStack.method_22905(1.5f, 1.5f, 1.5f);
            this.icon.render(graphics, 0, 0);
            poseStack.method_22909();
        }
        if (hasItem) {
            ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(this.item).at(keyWidth + (hasIcon ? 24 : 0), 0.0f)).scale(1.5).render(graphics);
            RenderSystem.disableDepthTest();
        }
        poseStack.method_22909();
    }

    private class Builder
    implements InputElementBuilder {
        private Builder() {
        }

        @Override
        public InputElementBuilder withItem(class_1799 stack) {
            InputWindowElement.this.item = stack;
            return this;
        }

        @Override
        public InputElementBuilder leftClick() {
            InputWindowElement.this.icon = PonderGuiTextures.ICON_LMB;
            return this;
        }

        @Override
        public InputElementBuilder scroll() {
            InputWindowElement.this.icon = PonderGuiTextures.ICON_SCROLL;
            return this;
        }

        @Override
        public InputElementBuilder rightClick() {
            InputWindowElement.this.icon = PonderGuiTextures.ICON_RMB;
            return this;
        }

        @Override
        public InputElementBuilder showing(ScreenElement icon) {
            InputWindowElement.this.icon = icon;
            return this;
        }

        @Override
        public InputElementBuilder whileSneaking() {
            InputWindowElement.this.key = Ponder.asResource("sneak_and");
            return this;
        }

        @Override
        public InputElementBuilder whileCTRL() {
            InputWindowElement.this.key = Ponder.asResource("ctrl_and");
            return this;
        }
    }
}

