/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.api.level;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.createmod.catnip.levelWrappers.WrappedClientLevel;
import net.createmod.catnip.platform.CatnipClientServices;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.createmod.ponder.api.VirtualBlockEntity;
import net.createmod.ponder.api.element.WorldSectionElement;
import net.createmod.ponder.api.scene.Selection;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.PonderWorldParticles;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_898;

public class PonderLevel
extends SchematicLevel {
    @Nullable
    public PonderScene scene;
    protected Map<class_2338, class_2680> originalBlocks;
    protected Map<class_2338, class_2487> originalBlockEntities;
    protected Map<class_2338, Integer> blockBreakingProgressions;
    protected List<class_1297> originalEntities;
    private final Supplier<class_638> asClientWorld = Suppliers.memoize(() -> WrappedClientLevel.of(this));
    protected PonderWorldParticles particles;
    int overrideLight;
    @Nullable
    Selection mask;
    boolean currentlyTickingEntities;

    public PonderLevel(class_2338 anchor, class_1937 original) {
        super(anchor, original);
        this.originalBlocks = new HashMap<class_2338, class_2680>();
        this.originalBlockEntities = new HashMap<class_2338, class_2487>();
        this.blockBreakingProgressions = new HashMap<class_2338, Integer>();
        this.originalEntities = new ArrayList<class_1297>();
        this.particles = new PonderWorldParticles(this);
        this.renderMode = true;
    }

    public void createBackup() {
        this.originalBlocks.clear();
        this.originalBlockEntities.clear();
        this.originalBlocks.putAll(this.blocks);
        this.blockEntities.forEach((k, v) -> this.originalBlockEntities.put((class_2338)k, v.method_38242()));
        this.entities.forEach(e -> {
            class_2487 tag = new class_2487();
            e.method_5662(tag);
            class_1299.method_5892((class_2487)tag, (class_1937)this).ifPresent(this.originalEntities::add);
        });
    }

    public void restore() {
        this.entities.clear();
        this.blocks.clear();
        this.blockEntities.clear();
        this.blockBreakingProgressions.clear();
        this.renderedBlockEntities.clear();
        this.blocks.putAll(this.originalBlocks);
        this.originalBlockEntities.forEach((k, v) -> {
            class_2586 blockEntity = class_2586.method_11005((class_2338)k, (class_2680)this.originalBlocks.get(k), (class_2487)v);
            this.onBEAdded(blockEntity, blockEntity.method_11016());
            this.blockEntities.put(k, blockEntity);
            this.renderedBlockEntities.add(blockEntity);
        });
        this.originalEntities.forEach(e -> {
            class_2487 tag = new class_2487();
            e.method_5662(tag);
            class_1299.method_5892((class_2487)tag, (class_1937)this).ifPresent(this.entities::add);
        });
        this.particles.clearEffects();
        PonderIndex.forEachPlugin(plugin -> plugin.onPonderLevelRestore(this));
    }

    public void restoreBlocks(Selection selection) {
        selection.forEach(p -> {
            class_2586 blockEntity;
            if (this.originalBlocks.containsKey(p)) {
                this.blocks.put(p, this.originalBlocks.get(p));
            }
            if (this.originalBlockEntities.containsKey(p) && (blockEntity = class_2586.method_11005((class_2338)p, (class_2680)this.originalBlocks.get(p), (class_2487)this.originalBlockEntities.get(p))) != null) {
                this.onBEAdded(blockEntity, blockEntity.method_11016());
                this.blockEntities.put(p, blockEntity);
            }
        });
        this.redraw();
    }

    private void redraw() {
        if (this.scene != null) {
            this.scene.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
        }
    }

    public void pushFakeLight(int light) {
        this.overrideLight = light;
    }

    public void popLight() {
        this.overrideLight = -1;
    }

    @Override
    public int method_8314(class_1944 p_226658_1_, class_2338 p_226658_2_) {
        return this.overrideLight == -1 ? 15 : this.overrideLight;
    }

    public void setMask(@Nullable Selection mask) {
        this.mask = mask;
    }

    public void clearMask() {
        this.mask = null;
    }

    @Override
    public class_2680 method_8320(class_2338 globalPos) {
        if (this.mask != null && !this.mask.test(globalPos.method_10059((class_2382)this.anchor))) {
            return class_2246.field_10124.method_9564();
        }
        if (this.currentlyTickingEntities && globalPos.method_10264() < 0) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_8320(globalPos);
    }

    public class_1922 method_22338(int p_225522_1_, int p_225522_2_) {
        return this;
    }

    public void renderEntities(class_4587 ms, SuperRenderTypeBuffer buffer, class_4184 ari, float pt) {
        class_243 Vector3d2 = ari.method_19326();
        double d0 = Vector3d2.method_10216();
        double d1 = Vector3d2.method_10214();
        double d2 = Vector3d2.method_10215();
        for (class_1297 entity : this.entities) {
            if (entity.field_6012 == 0) {
                entity.field_6038 = entity.method_23317();
                entity.field_5971 = entity.method_23318();
                entity.field_5989 = entity.method_23321();
            }
            this.renderEntity(entity, d0, d1, d2, pt, ms, buffer);
        }
        buffer.draw(class_1921.method_23572((class_2960)class_1723.field_21668));
        buffer.draw(class_1921.method_23576((class_2960)class_1723.field_21668));
        buffer.draw(class_1921.method_23578((class_2960)class_1723.field_21668));
        buffer.draw(class_1921.method_23584((class_2960)class_1723.field_21668));
    }

    private void renderEntity(class_1297 entity, double x, double y, double z, float pt, class_4587 ms, class_4597 buffer) {
        double d0 = class_3532.method_16436((double)pt, (double)entity.field_6038, (double)entity.method_23317());
        double d1 = class_3532.method_16436((double)pt, (double)entity.field_5971, (double)entity.method_23318());
        double d2 = class_3532.method_16436((double)pt, (double)entity.field_5989, (double)entity.method_23321());
        float f = class_3532.method_16439((float)pt, (float)entity.field_5982, (float)entity.method_36454());
        class_898 renderManager = class_310.method_1551().method_1561();
        int light = renderManager.method_3953(entity).method_24088(entity, pt);
        renderManager.method_3954(entity, d0 - x, d1 - y, d2 - z, f, pt, ms, buffer, light);
    }

    public void renderParticles(class_4587 ms, class_4597 buffer, class_4184 ari, float pt) {
        this.particles.renderParticles(ms, buffer, ari, pt);
    }

    public void tick() {
        this.currentlyTickingEntities = true;
        this.particles.tick();
        Iterator iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            class_1297 entity = (class_1297)iterator.next();
            ++entity.field_6012;
            entity.field_6038 = entity.method_23317();
            entity.field_5971 = entity.method_23318();
            entity.field_5989 = entity.method_23321();
            entity.method_5773();
            if (entity.method_23318() <= -0.5) {
                entity.method_31472();
            }
            if (entity.method_5805()) continue;
            iterator.remove();
        }
        this.currentlyTickingEntities = false;
    }

    public void method_8406(class_2394 data, double x, double y, double z, double mx, double my, double mz) {
        this.addParticle(this.makeParticle(data, x, y, z, mx, my, mz));
    }

    public void method_8494(class_2394 data, double x, double y, double z, double mx, double my, double mz) {
        this.method_8406(data, x, y, z, mx, my, mz);
    }

    @Nullable
    private <T extends class_2394> class_703 makeParticle(T data, double x, double y, double z, double mx, double my, double mz) {
        return CatnipClientServices.CLIENT_HOOKS.createParticleFromData(data, this.asClientWorld.get(), x, y, z, mx, my, mz);
    }

    @Override
    public boolean method_8652(class_2338 pos, class_2680 arg1, int arg2) {
        return super.method_8652(pos, arg1, arg2);
    }

    public void addParticle(@Nullable class_703 p) {
        if (p != null) {
            this.particles.addParticle(p);
        }
    }

    protected void onBEAdded(class_2586 blockEntity, class_2338 pos) {
        super.onBEadded(blockEntity, pos);
        if (!(blockEntity instanceof VirtualBlockEntity)) {
            return;
        }
        VirtualBlockEntity virtualBlockEntity = (VirtualBlockEntity)blockEntity;
        virtualBlockEntity.markVirtual();
    }

    public void setBlockBreakingProgress(class_2338 pos, int damage) {
        if (damage == 0) {
            this.blockBreakingProgressions.remove(pos);
        } else {
            this.blockBreakingProgressions.put(pos, damage - 1);
        }
    }

    public Map<class_2338, Integer> getBlockBreakingProgressions() {
        return this.blockBreakingProgressions;
    }

    public void addBlockDestroyEffects(class_2338 pos, class_2680 state) {
        class_265 voxelshape = state.method_26218((class_1922)this, pos);
        if (voxelshape.method_1110()) {
            return;
        }
        class_238 bb = voxelshape.method_1107();
        double d1 = Math.min(1.0, bb.field_1320 - bb.field_1323);
        double d2 = Math.min(1.0, bb.field_1325 - bb.field_1322);
        double d3 = Math.min(1.0, bb.field_1324 - bb.field_1321);
        int i = Math.max(2, class_3532.method_15384((double)(d1 / 0.25)));
        int j = Math.max(2, class_3532.method_15384((double)(d2 / 0.25)));
        int k = Math.max(2, class_3532.method_15384((double)(d3 / 0.25)));
        for (int l = 0; l < i; ++l) {
            for (int i1 = 0; i1 < j; ++i1) {
                for (int j1 = 0; j1 < k; ++j1) {
                    double d4 = ((double)l + 0.5) / (double)i;
                    double d5 = ((double)i1 + 0.5) / (double)j;
                    double d6 = ((double)j1 + 0.5) / (double)k;
                    double d7 = d4 * d1 + bb.field_1323;
                    double d8 = d5 * d2 + bb.field_1322;
                    double d9 = d6 * d3 + bb.field_1321;
                    this.method_8406((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + d7, (double)pos.method_10264() + d8, (double)pos.method_10260() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5);
                }
            }
        }
    }

    @Override
    protected class_2680 processBlockStateForPrinting(class_2680 state) {
        return state;
    }

    public boolean method_22340(class_2338 pos) {
        return true;
    }

    public boolean method_8393(int x, int y) {
        return true;
    }

    public boolean method_8477(class_2338 pos) {
        return true;
    }

    public boolean method_18458(double p_217358_1_, double p_217358_3_, double p_217358_5_, double p_217358_7_) {
        return true;
    }
}

