/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.outliner;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.outliner.AABBOutline;
import net.createmod.catnip.outliner.BlockClusterOutline;
import net.createmod.catnip.outliner.ChasingAABBOutline;
import net.createmod.catnip.outliner.ItemOutline;
import net.createmod.catnip.outliner.LineOutline;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class Outliner {
    private static final Outliner instance = new Outliner();
    private final Map<Object, OutlineEntry> outlines = Collections.synchronizedMap(new HashMap());
    private final Map<Object, OutlineEntry> outlinesView = Collections.unmodifiableMap(this.outlines);

    public static Outliner getInstance() {
        return instance;
    }

    public Outline.OutlineParams showOutline(Object slot, Outline outline) {
        this.outlines.put(slot, new OutlineEntry(outline));
        return outline.getParams();
    }

    public Outline.OutlineParams showLine(Object slot, class_243 start, class_243 end) {
        if (!this.outlines.containsKey(slot)) {
            LineOutline outline = new LineOutline();
            this.addOutline(slot, outline);
        }
        OutlineEntry entry = this.outlines.get(slot);
        entry.ticksTillRemoval = 1;
        ((LineOutline)entry.outline).set(start, end);
        return entry.outline.getParams();
    }

    public Outline.OutlineParams endChasingLine(Object slot, class_243 start, class_243 end, float chasingProgress, boolean lockStart) {
        if (!this.outlines.containsKey(slot)) {
            LineOutline.EndChasingLineOutline outline = new LineOutline.EndChasingLineOutline(lockStart);
            this.addOutline(slot, outline);
        }
        OutlineEntry entry = this.outlines.get(slot);
        entry.ticksTillRemoval = 1;
        ((LineOutline.EndChasingLineOutline)entry.outline).setProgress(chasingProgress).set(start, end);
        return entry.outline.getParams();
    }

    public Outline.OutlineParams showAABB(Object slot, class_238 bb, int ttl) {
        this.createAABBOutlineIfMissing(slot, bb);
        ChasingAABBOutline outline = this.getAndRefreshAABB(slot, ttl);
        outline.targetBB = outline.bb = bb;
        outline.prevBB = outline.bb;
        return outline.getParams();
    }

    public Outline.OutlineParams showAABB(Object slot, class_238 bb) {
        this.createAABBOutlineIfMissing(slot, bb);
        ChasingAABBOutline outline = this.getAndRefreshAABB(slot);
        outline.targetBB = outline.bb = bb;
        outline.prevBB = outline.bb;
        return outline.getParams();
    }

    public Outline.OutlineParams chaseAABB(Object slot, class_238 bb) {
        this.createAABBOutlineIfMissing(slot, bb);
        ChasingAABBOutline outline = this.getAndRefreshAABB(slot);
        outline.targetBB = bb;
        return outline.getParams();
    }

    public Outline.OutlineParams showCluster(Object slot, Iterable<class_2338> selection) {
        BlockClusterOutline outline = new BlockClusterOutline(selection);
        this.addOutline(slot, outline);
        return outline.getParams();
    }

    public Outline.OutlineParams showItem(Object slot, class_243 pos, class_1799 stack) {
        ItemOutline outline = new ItemOutline(pos, stack);
        OutlineEntry entry = new OutlineEntry(outline);
        this.outlines.put(slot, entry);
        return entry.getOutline().getParams();
    }

    public void keep(Object slot) {
        if (this.outlines.containsKey(slot)) {
            this.outlines.get((Object)slot).ticksTillRemoval = 1;
        }
    }

    public void remove(Object slot) {
        this.outlines.remove(slot);
    }

    public Optional<Outline.OutlineParams> edit(Object slot) {
        this.keep(slot);
        if (this.outlines.containsKey(slot)) {
            return Optional.of(this.outlines.get(slot).getOutline().getParams());
        }
        return Optional.empty();
    }

    public Map<Object, OutlineEntry> getOutlines() {
        return this.outlinesView;
    }

    private void addOutline(Object slot, Outline outline) {
        this.outlines.put(slot, new OutlineEntry(outline));
    }

    private void createAABBOutlineIfMissing(Object slot, class_238 bb) {
        if (!this.outlines.containsKey(slot) || !(this.outlines.get((Object)slot).outline instanceof AABBOutline)) {
            ChasingAABBOutline outline = new ChasingAABBOutline(bb);
            this.addOutline(slot, outline);
        }
    }

    private ChasingAABBOutline getAndRefreshAABB(Object slot) {
        return this.getAndRefreshAABB(slot, 1);
    }

    private ChasingAABBOutline getAndRefreshAABB(Object slot, int ttl) {
        OutlineEntry entry = this.outlines.get(slot);
        entry.ticksTillRemoval = ttl;
        return (ChasingAABBOutline)entry.getOutline();
    }

    public void tickOutlines() {
        Iterator<OutlineEntry> iterator = this.outlines.values().iterator();
        while (iterator.hasNext()) {
            OutlineEntry entry = iterator.next();
            entry.tick();
            if (entry.isAlive()) continue;
            iterator.remove();
        }
    }

    public void renderOutlines(class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, float pt) {
        this.outlines.forEach((key, entry) -> {
            Outline outline = entry.getOutline();
            Outline.OutlineParams params = outline.getParams();
            params.alpha = 1.0f;
            if (entry.isFading()) {
                int prevTicks = entry.ticksTillRemoval + 1;
                float fadeticks = 8.0f;
                float lastAlpha = prevTicks >= 0 ? 1.0f : 1.0f + (float)prevTicks / fadeticks;
                float currentAlpha = 1.0f + (float)entry.ticksTillRemoval / fadeticks;
                float alpha = class_3532.method_16439((float)pt, (float)lastAlpha, (float)currentAlpha);
                params.alpha = alpha * alpha * alpha;
                if (params.alpha < 0.125f) {
                    return;
                }
            }
            outline.render(ms, buffer, camera, pt);
        });
    }

    public static class OutlineEntry {
        public static final int FADE_TICKS = 8;
        private final Outline outline;
        private int ticksTillRemoval = 1;

        public OutlineEntry(Outline outline) {
            this.outline = outline;
        }

        public Outline getOutline() {
            return this.outline;
        }

        public int getTicksTillRemoval() {
            return this.ticksTillRemoval;
        }

        public boolean isAlive() {
            return this.ticksTillRemoval >= -8;
        }

        public boolean isFading() {
            return this.ticksTillRemoval < 0;
        }

        public void tick() {
            --this.ticksTillRemoval;
            this.outline.tick();
        }
    }
}

