/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.math;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import org.apache.commons.lang3.mutable.MutableObject;

public class VoxelShaper {
    private final Map<class_2350, class_265> shapes = new HashMap<class_2350, class_265>();

    public class_265 get(class_2350 direction) {
        return this.shapes.get(direction);
    }

    public class_265 get(class_2350.class_2351 axis) {
        return this.shapes.get(VoxelShaper.axisAsFace(axis));
    }

    public static VoxelShaper forHorizontal(class_265 shape, class_2350 facing) {
        return VoxelShaper.forDirectionsWithRotation(shape, facing, (Iterable<class_2350>)class_2350.class_2353.field_11062, new HorizontalRotationValues());
    }

    public static VoxelShaper forHorizontalAxis(class_265 shape, class_2350.class_2351 along) {
        return VoxelShaper.forDirectionsWithRotation(shape, VoxelShaper.axisAsFace(along), Arrays.asList(class_2350.field_11035, class_2350.field_11034), new HorizontalRotationValues());
    }

    public static VoxelShaper forDirectional(class_265 shape, class_2350 facing) {
        return VoxelShaper.forDirectionsWithRotation(shape, facing, Arrays.asList(Iterate.directions), new DefaultRotationValues());
    }

    public static VoxelShaper forAxis(class_265 shape, class_2350.class_2351 along) {
        return VoxelShaper.forDirectionsWithRotation(shape, VoxelShaper.axisAsFace(along), Arrays.asList(class_2350.field_11035, class_2350.field_11034, class_2350.field_11036), new DefaultRotationValues());
    }

    public VoxelShaper withVerticalShapes(class_265 upShape) {
        this.shapes.put(class_2350.field_11036, upShape);
        this.shapes.put(class_2350.field_11033, VoxelShaper.rotatedCopy(upShape, new class_243(180.0, 0.0, 0.0)));
        return this;
    }

    public VoxelShaper withShape(class_265 shape, class_2350 facing) {
        this.shapes.put(facing, shape);
        return this;
    }

    public static class_2350 axisAsFace(class_2350.class_2351 axis) {
        return class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
    }

    protected static float horizontalAngleFromDirection(class_2350 direction) {
        return (Math.max(direction.method_10161(), 0) & 3) * 90;
    }

    protected static VoxelShaper forDirectionsWithRotation(class_265 shape, class_2350 facing, Iterable<class_2350> directions, Function<class_2350, class_243> rotationValues) {
        VoxelShaper voxelShaper = new VoxelShaper();
        for (class_2350 dir : directions) {
            voxelShaper.shapes.put(dir, VoxelShaper.rotate(shape, facing, dir, rotationValues));
        }
        return voxelShaper;
    }

    protected static class_265 rotate(class_265 shape, class_2350 from, class_2350 to, Function<class_2350, class_243> usingValues) {
        if (from == to) {
            return shape;
        }
        return VoxelShaper.rotatedCopy(shape, usingValues.apply(from).method_22882().method_1019(usingValues.apply(to)));
    }

    protected static class_265 rotatedCopy(class_265 shape, class_243 rotation) {
        if (rotation.equals((Object)class_243.field_1353)) {
            return shape;
        }
        MutableObject result = new MutableObject((Object)class_259.method_1073());
        class_243 center = new class_243(8.0, 8.0, 8.0);
        shape.method_1089((x1, y1, z1, x2, y2, z2) -> {
            class_243 v1 = new class_243(x1, y1, z1).method_1021(16.0).method_1020(center);
            class_243 v2 = new class_243(x2, y2, z2).method_1021(16.0).method_1020(center);
            v1 = VecHelper.rotate(v1, (float)rotation.field_1352, class_2350.class_2351.field_11048);
            v1 = VecHelper.rotate(v1, (float)rotation.field_1351, class_2350.class_2351.field_11052);
            v1 = VecHelper.rotate(v1, (float)rotation.field_1350, class_2350.class_2351.field_11051).method_1019(center);
            v2 = VecHelper.rotate(v2, (float)rotation.field_1352, class_2350.class_2351.field_11048);
            v2 = VecHelper.rotate(v2, (float)rotation.field_1351, class_2350.class_2351.field_11052);
            v2 = VecHelper.rotate(v2, (float)rotation.field_1350, class_2350.class_2351.field_11051).method_1019(center);
            class_265 rotated = VoxelShaper.blockBox(v1, v2);
            result.setValue((Object)class_259.method_1084((class_265)((class_265)result.getValue()), (class_265)rotated));
        });
        return (class_265)result.getValue();
    }

    protected static class_265 blockBox(class_243 v1, class_243 v2) {
        return class_2248.method_9541((double)Math.min(v1.field_1352, v2.field_1352), (double)Math.min(v1.field_1351, v2.field_1351), (double)Math.min(v1.field_1350, v2.field_1350), (double)Math.max(v1.field_1352, v2.field_1352), (double)Math.max(v1.field_1351, v2.field_1351), (double)Math.max(v1.field_1350, v2.field_1350));
    }

    protected static class HorizontalRotationValues
    implements Function<class_2350, class_243> {
        protected HorizontalRotationValues() {
        }

        @Override
        public class_243 apply(class_2350 direction) {
            return new class_243(0.0, (double)(-VoxelShaper.horizontalAngleFromDirection(direction)), 0.0);
        }
    }

    protected static class DefaultRotationValues
    implements Function<class_2350, class_243> {
        protected DefaultRotationValues() {
        }

        @Override
        public class_243 apply(class_2350 direction) {
            return new class_243(direction == class_2350.field_11036 ? 0.0 : (double)(class_2350.class_2353.field_11064.method_10182(direction) ? 180 : 90), (double)(-VoxelShaper.horizontalAngleFromDirection(direction)), 0.0);
        }
    }
}

