/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.ghostblock;

import dev.engine_room.flywheel.lib.model.baked.EmptyVirtualBlockGetter;
import net.createmod.catnip.client.render.model.BakedModelBufferer;
import net.createmod.catnip.ghostblock.GhostBlockParams;
import net.createmod.catnip.impl.client.render.ColoringVertexConsumer;
import net.createmod.catnip.placement.PlacementClient;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public abstract class GhostBlockRenderer {
    private static final GhostBlockRenderer STANDARD = new DefaultGhostBlockRenderer();
    private static final GhostBlockRenderer TRANSPARENT = new TransparentGhostBlockRenderer();

    public static GhostBlockRenderer standard() {
        return STANDARD;
    }

    public static GhostBlockRenderer transparent() {
        return TRANSPARENT;
    }

    public abstract void render(class_4587 var1, SuperRenderTypeBuffer var2, class_243 var3, GhostBlockParams var4);

    private static class DefaultGhostBlockRenderer
    extends GhostBlockRenderer {
        private DefaultGhostBlockRenderer() {
        }

        @Override
        public void render(class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, GhostBlockParams params) {
            class_2680 state = params.state;
            class_1087 model = class_310.method_1551().method_1541().method_3349(state);
            class_2338 pos = params.pos;
            ms.method_22903();
            ms.method_22904((double)pos.method_10263() - camera.field_1352, (double)pos.method_10264() - camera.field_1351, (double)pos.method_10260() - camera.field_1350);
            BakedModelBufferer.bufferModel(model, pos, (class_1920)EmptyVirtualBlockGetter.FULL_BRIGHT, state, ms, (layer, shade) -> buffer.getEarlyBuffer(layer));
            ms.method_22909();
        }
    }

    private static class TransparentGhostBlockRenderer
    extends GhostBlockRenderer {
        private TransparentGhostBlockRenderer() {
        }

        @Override
        public void render(class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, GhostBlockParams params) {
            class_2680 state = params.state;
            class_1087 model = class_310.method_1551().method_1541().method_3349(state);
            class_2338 pos = params.pos;
            float alpha = params.alphaSupplier.get().floatValue() * 0.75f * PlacementClient.getCurrentAlpha();
            ColoringVertexConsumer vb = new ColoringVertexConsumer(buffer.getEarlyBuffer(class_1921.method_23583()), 1.0f, 1.0f, 1.0f, alpha);
            ms.method_22903();
            ms.method_22904((double)pos.method_10263() - camera.field_1352, (double)pos.method_10264() - camera.field_1351, (double)pos.method_10260() - camera.field_1350);
            ms.method_22904(0.5, 0.5, 0.5);
            ms.method_22905(0.85f, 0.85f, 0.85f);
            ms.method_22904(-0.5, -0.5, -0.5);
            BakedModelBufferer.bufferModel(model, pos, (class_1920)EmptyVirtualBlockGetter.FULL_BRIGHT, state, ms, (layer, shade) -> vb);
            ms.method_22909();
        }
    }
}

