/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.config.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.createmod.catnip.config.ui.ConfigHelper;
import net.createmod.catnip.config.ui.ConfigModListScreen;
import net.createmod.catnip.config.ui.ConfigScreen;
import net.createmod.catnip.config.ui.SubMenuConfigScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.FadableScreenElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.element.TextStencilElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.gui.widget.ElementWidget;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class BaseConfigScreen
extends ConfigScreen {
    public static final Color COLOR_TITLE_A = new Color(-3760196).setImmutable();
    public static final Color COLOR_TITLE_B = new Color(-608069).setImmutable();
    public static final Color COLOR_TITLE_C = new Color(-263788).setImmutable();
    public static final FadableScreenElement DISABLED_RENDERER = (ms, width, height, alpha) -> UIRenderHelper.angledGradient(ms, 0.0f, 0, height / 2, height, width, AbstractSimiWidget.COLOR_DISABLED);
    private static final Map<String, UnaryOperator<BaseConfigScreen>> DEFAULTS = new HashMap<String, UnaryOperator<BaseConfigScreen>>();
    @Nullable
    BoxWidget clientConfigWidget;
    @Nullable
    BoxWidget commonConfigWidget;
    @Nullable
    BoxWidget serverConfigWidget;
    @Nullable
    BoxWidget goBack;
    @Nullable
    BoxWidget others;
    @Nullable
    BoxWidget title;
    @Nullable
    ForgeConfigSpec clientSpec;
    @Nullable
    ForgeConfigSpec commonSpec;
    @Nullable
    ForgeConfigSpec serverSpec;
    String clientButtonLabel = "Client Config";
    String commonButtonLabel = "Common Config";
    String serverButtonLabel = "Server Config";
    String modID;
    protected boolean returnOnClose;

    public static void setDefaultActionFor(String modID, UnaryOperator<BaseConfigScreen> transform) {
        DEFAULTS.put(modID, transform);
    }

    public BaseConfigScreen(@Nullable class_437 parent, String modID) {
        super(parent);
        this.modID = modID;
        if (DEFAULTS.containsKey(modID)) {
            DEFAULTS.get(modID).apply(this);
        } else {
            this.searchForConfigSpecs();
        }
    }

    public BaseConfigScreen searchForConfigSpecs() {
        if (!ConfigHelper.hasAnyForgeConfig(this.modID)) {
            return this;
        }
        try {
            this.clientSpec = ConfigHelper.findForgeConfigSpecFor(ModConfig.Type.CLIENT, this.modID);
        }
        catch (ClassCastException | NullPointerException e) {
            Ponder.LOGGER.debug("Unable to find ClientConfigSpec for mod: " + this.modID);
        }
        try {
            this.commonSpec = ConfigHelper.findForgeConfigSpecFor(ModConfig.Type.COMMON, this.modID);
        }
        catch (ClassCastException | NullPointerException e) {
            Ponder.LOGGER.debug("Unable to find CommonConfigSpec for mod: " + this.modID);
        }
        try {
            this.serverSpec = ConfigHelper.findForgeConfigSpecFor(ModConfig.Type.SERVER, this.modID);
        }
        catch (ClassCastException | NullPointerException e) {
            Ponder.LOGGER.debug("Unable to find ServerConfigSpec for mod: " + this.modID);
        }
        return this;
    }

    public BaseConfigScreen withSpecs(@Nullable ForgeConfigSpec client, @Nullable ForgeConfigSpec common, @Nullable ForgeConfigSpec server) {
        this.clientSpec = client;
        this.commonSpec = common;
        this.serverSpec = server;
        return this;
    }

    public BaseConfigScreen withButtonLabels(@Nullable String client, @Nullable String common, @Nullable String server) {
        if (client != null) {
            this.clientButtonLabel = client;
        }
        if (common != null) {
            this.commonButtonLabel = common;
        }
        if (server != null) {
            this.serverButtonLabel = server;
        }
        return this;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.returnOnClose = true;
        TextStencilElement clientText = new TextStencilElement(this.field_22793, class_2561.method_43471((String)"catnip.ui.client_config_button_label")).centered(true, true);
        this.clientConfigWidget = (BoxWidget)new BoxWidget(this.field_22789 / 2 - 100, this.field_22790 / 2 - 15 - 30, 200, 16).showingElement(clientText);
        this.method_37063(this.clientConfigWidget);
        if (this.clientSpec != null) {
            this.clientConfigWidget.withCallback(() -> this.linkTo(new SubMenuConfigScreen(this, ModConfig.Type.CLIENT, this.clientSpec)));
            clientText.withElementRenderer(BoxWidget.gradientFactory.apply(this.clientConfigWidget));
        } else {
            this.clientConfigWidget.field_22763 = false;
            this.clientConfigWidget.updateGradientFromState();
            clientText.withElementRenderer(DISABLED_RENDERER);
        }
        TextStencilElement commonText = new TextStencilElement(this.field_22793, class_2561.method_43471((String)"catnip.ui.common_config_button_label")).centered(true, true);
        this.commonConfigWidget = (BoxWidget)new BoxWidget(this.field_22789 / 2 - 100, this.field_22790 / 2 - 15, 200, 16).showingElement(commonText);
        this.method_37063(this.commonConfigWidget);
        if (this.commonSpec != null) {
            this.commonConfigWidget.withCallback(() -> this.linkTo(new SubMenuConfigScreen(this, ModConfig.Type.COMMON, this.commonSpec)));
            commonText.withElementRenderer(BoxWidget.gradientFactory.apply(this.commonConfigWidget));
        } else {
            this.commonConfigWidget.field_22763 = false;
            this.commonConfigWidget.updateGradientFromState();
            commonText.withElementRenderer(DISABLED_RENDERER);
        }
        TextStencilElement serverText = new TextStencilElement(this.field_22793, class_2561.method_43471((String)"catnip.ui.server_config_button_label")).centered(true, true);
        this.serverConfigWidget = (BoxWidget)new BoxWidget(this.field_22789 / 2 - 100, this.field_22790 / 2 - 15 + 30, 200, 16).showingElement(serverText);
        this.method_37063(this.serverConfigWidget);
        if (this.serverSpec == null) {
            this.serverConfigWidget.field_22763 = false;
            this.serverConfigWidget.updateGradientFromState();
            serverText.withElementRenderer(DISABLED_RENDERER);
        } else if (this.field_22787.field_1687 == null) {
            serverText.withElementRenderer(DISABLED_RENDERER);
            this.serverConfigWidget.getToolTip().add((class_2561)class_2561.method_43471((String)"catnip.ui.server_config_unavailable"));
            this.serverConfigWidget.getToolTip().addAll(FontHelper.cutTextComponent((class_2561)class_2561.method_43471((String)"catnip.ui.server_config_unavailable_tooltip"), FontHelper.Palette.ALL_GRAY));
        } else {
            this.serverConfigWidget.withCallback(() -> this.linkTo(new SubMenuConfigScreen(this, ModConfig.Type.SERVER, this.serverSpec)));
            serverText.withElementRenderer(BoxWidget.gradientFactory.apply(this.serverConfigWidget));
        }
        TextStencilElement titleText = (TextStencilElement)new TextStencilElement(this.field_22793, CatnipServices.PLATFORM.getModDisplayName(this.modID)).centered(true, true).withElementRenderer((ms, w, h, alpha) -> {
            UIRenderHelper.angledGradient(ms, 0.0f, 0, h / 2, (float)h, (float)(w / 2), COLOR_TITLE_A, COLOR_TITLE_B);
            UIRenderHelper.angledGradient(ms, 0.0f, w / 2, h / 2, (float)h, (float)(w / 2), COLOR_TITLE_B, COLOR_TITLE_C);
        });
        int boxWidth = this.field_22789 + 10;
        int boxHeight = 39;
        int boxPadding = 4;
        this.title = (BoxWidget)((ElementWidget)((ElementWidget)((ElementWidget)((BoxWidget)new BoxWidget(-5, this.field_22790 / 2 - 110, boxWidth, boxHeight).setActive(false)).withBorderColors(AbstractSimiWidget.COLOR_IDLE)).withPadding(0.0f, boxPadding)).rescaleElement((float)boxWidth / 2.0f, (float)(boxHeight - 2 * boxPadding) / 2.0f)).showingElement((RenderElement)titleText.at(0.0f, 7.0f));
        this.method_37063(this.title);
        ConfigScreen.modID = this.modID;
        this.goBack = (BoxWidget)((AbstractSimiWidget)new BoxWidget(this.field_22789 / 2 - 134, this.field_22790 / 2, 20, 20).withPadding(2.0f, 2.0f)).withCallback(() -> this.linkTo(this.parent));
        this.goBack.showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_BACK.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.goBack)));
        this.goBack.getToolTip().add((class_2561)class_2561.method_43471((String)"catnip.ui.go_back_button"));
        this.method_37063(this.goBack);
        TextStencilElement othersText = new TextStencilElement(this.field_22793, class_2561.method_43471((String)"catnip.ui.other_mods_config_button_label")).centered(true, true);
        this.others = (BoxWidget)new BoxWidget(this.field_22789 / 2 - 100, this.field_22790 / 2 - 15 + 90, 200, 16).showingElement(othersText);
        othersText.withElementRenderer(BoxWidget.gradientFactory.apply(this.others));
        this.others.withCallback(() -> this.linkTo(new ConfigModListScreen(this)));
        this.method_37063(this.others);
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"catnip.ui.other_mods_config_title"), this.field_22789 / 2, this.field_22790 / 2 - 105, ((Color)UIRenderHelper.COLOR_TEXT_STRONG_ACCENT.getFirst()).getRGB());
    }

    private void linkTo(@Nullable class_437 screen) {
        this.returnOnClose = false;
        ScreenOpener.open(screen);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 259) {
            this.linkTo(this.parent);
        }
        return false;
    }
}

