/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.config;

import com.mikitellurium.telluriumforge.config.RangedConfigEntry;
import com.mikitellurium.telluriumforge.config.TelluriumConfig;
import com.mikitellurium.turtlechargingstation.common.blockentity.ThunderchargeDynamoBlockEntity;
import com.mikitellurium.turtlechargingstation.common.blockentity.TurtleChargingStationBlockEntity;
import com.mikitellurium.turtlechargingstation.util.FastId;

public class ModConfig {
    private static final TelluriumConfig COMMON_CONFIG = new TelluriumConfig(FastId.modId(), TelluriumConfig.Type.COMMON);

    public static void register() {
        ModConfig.setupConfig(COMMON_CONFIG);
    }

    private static void setupConfig(TelluriumConfig config) {
        config.comment("Turtle Charging Station Configuration");
        TurtleChargingStationBlockEntity.CAPACITY = (RangedConfigEntry)config.entryBuilder().defineInRange("chargingStationMaxCapacity", 64000L, 0L, Integer.MAX_VALUE).comment("The maximum amount of energy the charging station can hold");
        TurtleChargingStationBlockEntity.CONVERSION_RATE = (RangedConfigEntry)config.entryBuilder().defineInRange("chargingStationConversionRate", 256L, 0L, Integer.MAX_VALUE).comment("The amount of energy required to increase the turtle fuel level by 1");
        ThunderchargeDynamoBlockEntity.RECHARGE_AMOUNT = (RangedConfigEntry)config.entryBuilder().defineInRange("dynamoRechargeAmount", 1200, 0, Integer.MAX_VALUE).comment("The amount of time (in ticks) that is added to the charge when the thundercharge").comment("dynamo is struck by lightning.").comment("# 1 minute = 1200 in-game ticks");
        ThunderchargeDynamoBlockEntity.TRANSFER_RATE = (RangedConfigEntry)config.entryBuilder().defineInRange("dynamoTransferRate", 1024L, 0L, Integer.MAX_VALUE).comment("The amount of energy per tick generated by the thundercharge dynamo");
        config.build();
    }

    public static TelluriumConfig getCommon() {
        return COMMON_CONFIG;
    }
}

