/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.integration.computercraft;

import com.mikitellurium.turtlechargingstation.common.block.TurtleChargingStationBlock;
import com.mikitellurium.turtlechargingstation.common.blockentity.TurtleChargingStationBlockEntity;
import com.mikitellurium.turtlechargingstation.registry.ModBlocks;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.GenericPeripheral;
import dan200.computercraft.api.peripheral.PeripheralType;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7923;

public class TurtleChargingStationPeripheral
implements GenericPeripheral {
    public String id() {
        return class_7923.field_41175.method_10221((Object)ModBlocks.TURTLE_CHARGING_STATION).toString();
    }

    public PeripheralType getType() {
        return PeripheralType.ofAdditional((String[])new String[]{"turtle_charging_station"});
    }

    @LuaFunction(mainThread=true)
    public final boolean isEnabled(TurtleChargingStationBlockEntity.CCAccess access) {
        return (Boolean)access.getBlockState().method_11654((class_2769)TurtleChargingStationBlock.ENABLED);
    }

    @LuaFunction(mainThread=true)
    public final boolean isCharging(TurtleChargingStationBlockEntity.CCAccess access) {
        class_2680 blockState = access.getBlockState();
        return (Boolean)blockState.method_11654((class_2769)TurtleChargingStationBlock.ENABLED) != false && (Boolean)blockState.method_11654((class_2769)TurtleChargingStationBlock.CHARGING) != false;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getSide(TurtleChargingStationBlockEntity.CCAccess access, class_2350 side) {
        Optional<Object> optional = this.getSideData(access.getWorld(), access.getPos(), side);
        return MethodResult.of(optional.orElse(null));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getSides(TurtleChargingStationBlockEntity.CCAccess access) {
        HashMap results = new HashMap();
        for (class_2350 direction : class_2350.values()) {
            Optional<Object> optional = this.getSideData(access.getWorld(), access.getPos(), direction);
            optional.ifPresent(obj -> results.put(direction.method_10151(), obj));
        }
        return MethodResult.of(!results.isEmpty() ? results : null);
    }

    @LuaFunction(mainThread=true)
    public final long getEnergy(TurtleChargingStationBlockEntity.CCAccess access) {
        return access.getEnergy();
    }

    @LuaFunction(mainThread=true)
    public final long getEnergyCapacity(TurtleChargingStationBlockEntity.CCAccess access) {
        return access.getEnergyCapacity();
    }

    private Optional<Object> getSideData(class_1937 world, class_2338 pos, class_2350 side) {
        class_2586 blockEntity = world.method_8321(pos.method_10093(side));
        if (blockEntity instanceof TurtleBlockEntity) {
            TurtleBlockEntity turtle = (TurtleBlockEntity)blockEntity;
            String label = turtle.method_16914() ? turtle.getLabel() : String.valueOf(turtle.getComputerID());
            return Optional.of(Map.of("name", label, "fuelLevel", turtle.getAccess().getFuelLevel()));
        }
        return Optional.empty();
    }
}

