/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.energy;

import com.mikitellurium.turtlechargingstation.common.energy.CableNetwork;
import com.mikitellurium.turtlechargingstation.common.energy.NetworkNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import team.reborn.energy.api.EnergyStorage;

public class CableNetworkImpl
implements CableNetwork {
    private static int ids = 0;
    private final int id;
    private final Set<NetworkNode> nodes = new HashSet<NetworkNode>();
    private final Set<class_2586> receivers = new HashSet<class_2586>();

    private static int id() {
        return ++ids;
    }

    public CableNetworkImpl(NetworkNode node) {
        this.nodes.add(node);
        this.id = CableNetworkImpl.id();
    }

    public int getId() {
        return this.id;
    }

    @Override
    public int size() {
        return this.nodes.size() + this.receivers.size();
    }

    @Override
    public void update(NetworkNode startingPoint) {
        if (!startingPoint.getNodeWorld().field_9236) {
            this.receivers.clear();
            Set<NetworkNode> nodes = this.findConnectedNodes(startingPoint.getNodeWorld(), startingPoint.getBlockPos(), null, new HashSet<NetworkNode>());
            nodes.forEach(node -> {
                this.addNode((NetworkNode)node);
                this.findReceivers((NetworkNode)node);
            });
        }
    }

    private Set<NetworkNode> findConnectedNodes(class_1937 world, class_2338 startPos, class_2350 startDirection, Set<NetworkNode> foundNodes) {
        class_2586 blockEntity = world.method_8321(startPos);
        if (blockEntity instanceof NetworkNode) {
            NetworkNode node = (NetworkNode)blockEntity;
            if (foundNodes.contains(node) || node.ignoreOnUpdate()) {
                return foundNodes;
            }
            foundNodes.add(node);
            for (class_2350 direction : class_2350.values()) {
                class_2338 relativePos;
                class_2586 blockEntity1;
                if (startDirection != null && direction == startDirection.method_10153() || !((blockEntity1 = world.method_8321(relativePos = startPos.method_10093(direction))) instanceof NetworkNode)) continue;
                this.findConnectedNodes(world, relativePos, direction, foundNodes);
            }
        }
        return foundNodes;
    }

    private void findReceivers(NetworkNode node) {
        for (class_2350 direction : class_2350.values()) {
            class_2338 relativePos = node.getBlockPos().method_10093(direction);
            class_2586 blockEntity = node.getNodeWorld().method_8321(relativePos);
            if (blockEntity == null || blockEntity instanceof NetworkNode || EnergyStorage.SIDED.find(node.getNodeWorld(), blockEntity.method_11016(), blockEntity.method_11010(), blockEntity, (Object)direction) == null) continue;
            this.addReceiver(blockEntity);
        }
    }

    @Override
    public boolean addNode(NetworkNode node) {
        if (node != null) {
            node.setNetwork(this);
            return this.nodes.add(node);
        }
        return false;
    }

    @Override
    public void removeNode(NetworkNode node) {
        this.nodes.remove(node);
    }

    @Override
    public Collection<NetworkNode> getNodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    @Override
    public boolean addReceiver(class_2586 blockEntity) {
        if (blockEntity != null) {
            return this.receivers.add(blockEntity);
        }
        return false;
    }

    @Override
    public boolean removeReceiver(class_2586 blockEntity) {
        return this.receivers.remove(blockEntity);
    }

    @Override
    public Collection<class_2586> getReceivers() {
        return Collections.unmodifiableSet(this.receivers);
    }

    @Override
    public boolean contains(class_2586 blockEntity) {
        return blockEntity instanceof NetworkNode ? this.nodes.contains(blockEntity) : this.receivers.contains(blockEntity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[Id:" + this.id + ", Nodes:" + this.nodes.size() + ", Receivers:" + this.receivers.size() + "]";
    }
}

