/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.blockentity;

import com.mikitellurium.telluriumforge.blockentity.NameableBlockEntity;
import com.mikitellurium.telluriumforge.blockentity.TickingBlockEntity;
import com.mikitellurium.telluriumforge.config.RangedConfigEntry;
import com.mikitellurium.telluriumforge.networking.NetworkingHelper;
import com.mikitellurium.turtlechargingstation.client.gui.TurtleChargingStationScreenHandler;
import com.mikitellurium.turtlechargingstation.common.block.TurtleChargingStationBlock;
import com.mikitellurium.turtlechargingstation.common.blockentity.ThunderchargeDynamoBlockEntity;
import com.mikitellurium.turtlechargingstation.common.energy.ModEnergyStorage;
import com.mikitellurium.turtlechargingstation.networking.packets.EnergySyncPacket;
import com.mikitellurium.turtlechargingstation.networking.packets.TurtleFuelSyncPacket;
import com.mikitellurium.turtlechargingstation.registry.ModBlockEntities;
import com.mikitellurium.turtlechargingstation.util.FastId;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class TurtleChargingStationBlockEntity
extends NameableBlockEntity
implements ExtendedScreenHandlerFactory,
TickingBlockEntity {
    public static final BlockApiLookup<CCAccess, class_2350> ACCESS_LOOKUP = BlockApiLookup.get((class_2960)FastId.ofMod("cc_access"), CCAccess.class, class_2350.class);
    public static RangedConfigEntry<Long> CAPACITY;
    public static RangedConfigEntry<Long> CONVERSION_RATE;
    private final long maxReceive = (Long)CONVERSION_RATE.get() * 6L;
    private final ModEnergyStorage energyStorage = new ModEnergyStorage((long)((Long)CAPACITY.get()), this.maxReceive){

        @Override
        protected void onFinalCommit() {
            TurtleChargingStationBlockEntity.this.method_5431();
            if (!((TurtleChargingStationBlockEntity)TurtleChargingStationBlockEntity.this).field_11863.field_9236) {
                NetworkingHelper.sendToTrackingClients((class_3218)((class_3218)TurtleChargingStationBlockEntity.this.field_11863), (class_2338)TurtleChargingStationBlockEntity.this.field_11867, (FabricPacket)new EnergySyncPacket(TurtleChargingStationBlockEntity.this.field_11867, this.getAmount()));
            }
        }
    };
    private final class_1277 inventory = new class_1277(1){

        public void method_5431() {
            super.method_5431();
            TurtleChargingStationBlockEntity.this.method_5431();
        }
    };
    private final CCAccess access = new CCAccess(){

        @Override
        public class_2338 getPos() {
            return TurtleChargingStationBlockEntity.this.field_11867;
        }

        @Override
        public class_2680 getBlockState() {
            return TurtleChargingStationBlockEntity.this.method_11010();
        }

        @Override
        public class_1937 getWorld() {
            return TurtleChargingStationBlockEntity.this.field_11863;
        }

        @Override
        public long getEnergy() {
            return TurtleChargingStationBlockEntity.this.getEnergy();
        }

        @Override
        public long getEnergyCapacity() {
            return TurtleChargingStationBlockEntity.this.getEnergyCapacity();
        }
    };
    private final int textureChangeDelay = (int)Math.ceil((double)((Long)CONVERSION_RATE.get()).longValue() / (double)((Long)ThunderchargeDynamoBlockEntity.TRANSFER_RATE.get()).longValue()) + 1;
    private int textureTimer = 0;

    public TurtleChargingStationBlockEntity(class_2338 pPos, class_2680 pBlockState) {
        super(ModBlockEntities.TURTLE_CHARGING_STATION, pPos, pBlockState);
    }

    public void serverTick(class_3218 world, class_2338 pos, class_2680 state) {
        class_1799 itemStack = this.inventory.method_5438(0);
        EnergyStorage energyStorage1 = (EnergyStorage)EnergyStorage.ITEM.find(itemStack, (Object)ContainerItemContext.withConstant((class_1799)itemStack));
        if (energyStorage1 != null) {
            long extracted;
            try (Transaction transaction = Transaction.openOuter();){
                extracted = energyStorage1.extract(this.maxReceive, (TransactionContext)transaction);
                transaction.abort();
            }
            transaction = Transaction.openOuter();
            try {
                if (extracted > 0L && this.getEnergy() < this.getEnergyCapacity()) {
                    long energy = this.energyStorage.insert(extracted, (TransactionContext)transaction);
                    energyStorage1.extract(energy, (TransactionContext)transaction);
                    transaction.commit();
                }
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        ArrayList<TurtleBlockEntity> turtles = new ArrayList<TurtleBlockEntity>();
        for (class_2350 direction : class_2350.values()) {
            class_2586 be = world.method_8321(this.field_11867.method_10093(direction));
            if (be == null || !(be instanceof TurtleBlockEntity)) continue;
            turtles.add((TurtleBlockEntity)be);
        }
        boolean shouldCharge = !turtles.isEmpty() && this.hasChargeableTurtle(turtles) && this.energyStorage.getAmount() >= (Long)CONVERSION_RATE.get();
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)TurtleChargingStationBlock.CHARGING, (Comparable)Boolean.valueOf(shouldCharge || this.textureTimer > 0)), 2);
        if (shouldCharge && ((Boolean)this.method_11010().method_11654((class_2769)TurtleChargingStationBlock.ENABLED)).booleanValue()) {
            for (TurtleBlockEntity turtle : turtles) {
                if (!this.isChargeable(turtle) || this.energyStorage.getAmount() < (Long)CONVERSION_RATE.get()) continue;
                this.refuelTurtle(turtle);
                this.textureTimer = this.textureChangeDelay;
            }
        }
        if (this.textureTimer > 0) {
            --this.textureTimer;
        }
    }

    private boolean hasChargeableTurtle(List<TurtleBlockEntity> turtles) {
        for (TurtleBlockEntity turtle : turtles) {
            if (!this.isChargeable(turtle)) continue;
            return true;
        }
        return false;
    }

    private boolean isChargeable(TurtleBlockEntity turtle) {
        return turtle.getAccess().getFuelLevel() < turtle.getAccess().getFuelLimit();
    }

    private void refuelTurtle(TurtleBlockEntity turtle) {
        try (Transaction transaction = Transaction.openOuter();){
            if (this.energyStorage.extract((Long)CONVERSION_RATE.get(), (TransactionContext)transaction) == ((Long)CONVERSION_RATE.get()).longValue()) {
                turtle.getAccess().addFuel(1);
                transaction.commit();
                NetworkingHelper.sendToTrackingClients((class_3218)((class_3218)this.field_11863), (class_2338)this.field_11867, (FabricPacket)new TurtleFuelSyncPacket(turtle.method_11016(), turtle.getAccess().getFuelLevel()));
            }
        }
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public long getEnergy() {
        return this.energyStorage.getAmount();
    }

    public long getEnergyCapacity() {
        return this.energyStorage.getCapacity();
    }

    public void setAmount(long amount) {
        this.energyStorage.setAmount(amount);
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public EnergyStorage energyLookup(class_2350 side) {
        return this.energyStorage;
    }

    public InventoryStorage inventoryLookup(class_2350 side) {
        return InventoryStorage.of((class_1263)this.inventory, (class_2350)side);
    }

    public CCAccess accessLookup(class_2350 side) {
        return this.access;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new TurtleChargingStationScreenHandler(syncId, playerInventory, (class_2586)this);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
        buf.writeLong(this.energyStorage.getAmount());
    }

    protected class_2561 getDefaultName() {
        return class_2561.method_43471((String)"block.turtlechargingstation.turtle_charging_station");
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    public void method_11014(class_2487 nbt) {
        super.method_11007(nbt);
        this.energyStorage.setAmount(nbt.method_10537("energy"));
        this.inventory.method_7659(nbt.method_10554("inventory", 10));
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10544("energy", this.energyStorage.getAmount());
        nbt.method_10566("inventory", (class_2520)this.inventory.method_7660());
        super.method_11014(nbt);
    }

    public static interface CCAccess {
        public class_2338 getPos();

        public class_2680 getBlockState();

        public class_1937 getWorld();

        public long getEnergy();

        public long getEnergyCapacity();
    }
}

