/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.block;

import com.mikitellurium.telluriumforge.blockentity.TickingBlockEntity;
import com.mikitellurium.turtlechargingstation.common.blockentity.TurtleChargingStationBlockEntity;
import com.mikitellurium.turtlechargingstation.networking.packets.EnergySyncPacket;
import com.mikitellurium.turtlechargingstation.registry.ModBlockEntities;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3620;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class TurtleChargingStationBlock
extends class_2237 {
    public static final class_2746 ENABLED = class_2741.field_12515;
    public static final class_2746 CHARGING = class_2746.method_11825((String)"charging");

    public TurtleChargingStationBlock(class_4970.class_2251 settings) {
        super(settings.method_31710(class_3620.field_16009).method_29292().method_9629(3.0f, 6.0f).method_9626(class_2498.field_11533));
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)CHARGING, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TurtleChargingStationBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 blockState, class_2591<T> type) {
        return TurtleChargingStationBlock.method_31618(type, ModBlockEntities.TURTLE_CHARGING_STATION, (class_5558)TickingBlockEntity.getTicker());
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof TurtleChargingStationBlockEntity) {
                TurtleChargingStationBlockEntity stationBlockEntity = (TurtleChargingStationBlockEntity)entity;
                class_3908 screenHandlerFactory = state.method_26196(world, pos);
                if (screenHandlerFactory != null) {
                    player.method_17355(screenHandlerFactory);
                }
                ServerPlayNetworking.send((class_3222)((class_3222)player), (FabricPacket)new EnergySyncPacket(stationBlockEntity.method_11016(), stationBlockEntity.getEnergy()));
            } else {
                throw new IllegalStateException("Container provider is missing");
            }
        }
        return class_1269.method_29236((boolean)world.field_9236);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity;
        if (itemStack.method_7938() && (blockEntity = world.method_8321(pos)) instanceof TurtleChargingStationBlockEntity) {
            ((TurtleChargingStationBlockEntity)blockEntity).setCustomName(itemStack.method_7964());
        }
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (!oldState.method_27852(state.method_26204())) {
            this.checkPoweredState(world, pos, state);
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        this.checkPoweredState(world, pos, state);
    }

    private void checkPoweredState(class_1937 world, class_2338 pos, class_2680 state) {
        boolean flag;
        boolean bl = flag = !world.method_49803(pos);
        if (flag != (Boolean)state.method_11654((class_2769)ENABLED)) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (world.field_9236) {
            return;
        }
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockentity = world.method_8321(pos);
            if (blockentity instanceof TurtleChargingStationBlockEntity) {
                TurtleChargingStationBlockEntity turtleChargingStation = (TurtleChargingStationBlockEntity)blockentity;
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)turtleChargingStation.getInventory());
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{ENABLED});
        builder.method_11667(new class_2769[]{CHARGING});
    }
}

