/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.client.gui.element;

import com.mikitellurium.turtlechargingstation.common.blockentity.TurtleChargingStationBlockEntity;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_156;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_768;

public class TurtleInfoElement {
    private static final int WHITE = class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255);
    private final TurtleChargingStationBlockEntity station;
    private final class_768 area;
    private final Map<class_2350, TurtleData> turtleData = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.values()) {
            map.put(direction, new TurtleData());
        }
    });
    private final class_327 font;
    private int stringTimer;

    public TurtleInfoElement(TurtleChargingStationBlockEntity station, int xPos, int yPos) {
        this.font = class_310.method_1551().field_1772;
        this.stringTimer = 0;
        this.area = new class_768(xPos, yPos, 166, 87);
        this.station = station;
    }

    public void draw(class_332 context) {
        this.turtleData.forEach((direction, data) -> data.updateData(this.station, (class_2350)direction));
        int xPos = this.area.method_3321();
        int yPos = this.area.method_3322();
        int namePos = xPos + 75;
        int fuelPos = xPos + 143;
        class_5250 name = class_2561.method_43471((String)"gui.turtlechargingstation.turtle_charging_station.turtle_name");
        class_5250 fuelLevel = class_2561.method_43471((String)"gui.turtlechargingstation.turtle_charging_station.fuel_level");
        context.method_27534(this.font, (class_2561)name, namePos, yPos + 2, WHITE);
        context.method_27534(this.font, (class_2561)fuelLevel, fuelPos, yPos + 2, WHITE);
        int h = yPos + 2;
        for (class_2350 direction2 : class_2350.values()) {
            TurtleData data2 = this.turtleData.get(direction2);
            String directionName = this.getDirectionName(direction2);
            class_2561 turtleName = this.trimLabel(data2.getLabel());
            context.method_25303(this.font, directionName, this.alignString(directionName, xPos - 8), h += 12, WHITE);
            context.method_27534(this.font, turtleName, namePos, h, data2.turtleColor);
            context.method_25300(this.font, this.getFuelString(data2.turtleFuel), fuelPos, h, WHITE);
        }
    }

    private String getDirectionName(class_2350 direction) {
        String name = class_2561.method_43471((String)("gui.turtlechargingstation.turtle_charging_station." + direction.method_10151())).getString();
        String withColon = name + ":";
        int leadingSpace = 7 - withColon.length();
        return " ".repeat(Math.max(leadingSpace, 0)) + withColon;
    }

    private int alignString(String string, int xPos) {
        int width = this.font.method_1727(string);
        return Math.max(xPos + (40 - width), xPos);
    }

    public void updateStringTimer() {
        ++this.stringTimer;
    }

    private class_2561 trimLabel(class_2561 component) {
        String s;
        int maxWidth = 80;
        String finalString = s = component.getString();
        if (this.font.method_1727(s) > 80) {
            String sub = this.font.method_27523(s, 80);
            int maxLength = sub.length();
            int excessChars = s.length() - maxLength + 2;
            int index = this.stringTimer % excessChars;
            if (index > 0) {
                --index;
            }
            finalString = s.substring(index, maxLength + index);
        }
        return class_2561.method_43470((String)finalString);
    }

    private String getFuelString(int fuelLevel) {
        return fuelLevel == -1 ? "-" : String.valueOf(fuelLevel);
    }

    public class_768 getArea() {
        return this.area;
    }

    private static class TurtleData {
        private String label = "-";
        private int turtleColor = WHITE;
        private int turtleFuel = -1;

        private TurtleData() {
        }

        private void updateData(TurtleChargingStationBlockEntity station, class_2350 direction) {
            Optional<TurtleBlockEntity> optional = this.getAdjacentTurtle(station, direction);
            if (optional.isPresent()) {
                TurtleBlockEntity turtle = optional.get();
                this.label = turtle.method_16914() ? turtle.getLabel() : String.valueOf(turtle.getComputerID());
                this.turtleColor = turtle.getColour() == -1 ? WHITE : turtle.getColour();
                this.turtleFuel = turtle.getAccess().getFuelLevel();
            } else {
                this.label = "-";
                this.turtleColor = WHITE;
                this.turtleFuel = -1;
            }
        }

        private Optional<TurtleBlockEntity> getAdjacentTurtle(TurtleChargingStationBlockEntity station, class_2350 direction) {
            Optional<TurtleBlockEntity> optional;
            class_2586 blockEntity = station.method_10997().method_8321(station.method_11016().method_10093(direction));
            if (blockEntity instanceof TurtleBlockEntity) {
                TurtleBlockEntity turtle = (TurtleBlockEntity)blockEntity;
                optional = Optional.of(turtle);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }

        private class_2561 getLabel() {
            return class_2561.method_43470((String)this.label);
        }
    }
}

