/*
 * Decompiled with CFR 0.152.
 */
package ccchunkloader.niko.ink;

import ccchunkloader.niko.ink.ChunkLoaderPeripheral;
import ccchunkloader.niko.ink.ChunkManager;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurtleStateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TurtleStateManager.class);
    private final Map<UUID, TurtleState> allTurtleStates = new ConcurrentHashMap<UUID, TurtleState>();
    private final Object stateLock = new Object();

    public TurtleState getOrCreateState(UUID turtleId) {
        return this.allTurtleStates.computeIfAbsent(turtleId, id -> {
            LOGGER.debug("Created new turtle state for {}", id);
            return new TurtleState();
        });
    }

    public TurtleState getState(UUID turtleId) {
        return this.allTurtleStates.get(turtleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFromPeripheral(UUID turtleId, ChunkLoaderPeripheral.SavedState savedState, Integer computerId, class_5321<class_1937> worldKey) {
        Object object = this.stateLock;
        synchronized (object) {
            TurtleState state = this.getOrCreateState(turtleId);
            Double preservedRadiusOverride = state.getPendingRadiusOverride();
            Boolean preservedWakeOverride = state.getPendingWakeOverride();
            state.updateFromPeripheralState(savedState);
            state.setComputerId(computerId);
            state.setWorldKey(worldKey);
            state.setActive(true);
            state.setPendingRadiusOverride(preservedRadiusOverride);
            state.setPendingWakeOverride(preservedWakeOverride);
            LOGGER.debug("Updated turtle {} state from peripheral - preserved commands: radius={}, wake={}", new Object[]{turtleId, preservedRadiusOverride, preservedWakeOverride});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRadiusOverride(UUID turtleId, double radius) {
        Object object = this.stateLock;
        synchronized (object) {
            TurtleState state = this.getOrCreateState(turtleId);
            state.setPendingRadiusOverride(radius);
            LOGGER.info("Set radius override for turtle {}: {} (state: {})", new Object[]{turtleId, radius, state});
        }
    }

    public Double getRadiusOverride(UUID turtleId) {
        TurtleState state = this.getState(turtleId);
        Double override = state != null ? state.getPendingRadiusOverride() : null;
        LOGGER.debug("Get radius override for turtle {}: {} (state exists: {})", new Object[]{turtleId, override, state != null});
        return override;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRadiusOverride(UUID turtleId) {
        Object object = this.stateLock;
        synchronized (object) {
            TurtleState state = this.getState(turtleId);
            if (state != null) {
                Double oldOverride = state.getPendingRadiusOverride();
                state.clearRadiusOverride();
                LOGGER.info("Cleared radius override for turtle {}: {} -> null", (Object)turtleId, (Object)oldOverride);
            }
        }
    }

    public boolean hasRadiusOverride(UUID turtleId) {
        TurtleState state = this.getState(turtleId);
        return state != null && state.getPendingRadiusOverride() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTurtleActive(UUID turtleId, boolean active) {
        Object object = this.stateLock;
        synchronized (object) {
            TurtleState state = this.getOrCreateState(turtleId);
            state.setActive(active);
            LOGGER.debug("Set turtle {} active status: {}", (Object)turtleId, (Object)active);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTurtle(UUID turtleId) {
        Object object = this.stateLock;
        synchronized (object) {
            TurtleState removed = this.allTurtleStates.remove(turtleId);
            if (removed != null) {
                LOGGER.info("Removed turtle state: {}", (Object)turtleId);
            }
        }
    }

    public Set<UUID> getAllTurtleIds() {
        return new HashSet<UUID>(this.allTurtleStates.keySet());
    }

    public Set<UUID> getActiveTurtles() {
        return this.allTurtleStates.entrySet().stream().filter(entry -> ((TurtleState)entry.getValue()).isActive()).map(Map.Entry::getKey).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
    }

    public Set<UUID> getTurtlesWithPendingCommands() {
        return this.allTurtleStates.entrySet().stream().filter(entry -> ((TurtleState)entry.getValue()).hasPendingCommands()).map(Map.Entry::getKey).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
    }

    public Map<String, Object> getStatistics() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("totalTurtles", this.allTurtleStates.size());
        stats.put("activeTurtles", this.getActiveTurtles().size());
        stats.put("pendingCommands", this.getTurtlesWithPendingCommands().size());
        stats.put("memoryUsageKB", this.allTurtleStates.size() * 1);
        return stats;
    }

    public List<String> validateConsistency() {
        ArrayList<String> issues = new ArrayList<String>();
        for (Map.Entry<UUID, TurtleState> entry : this.allTurtleStates.entrySet()) {
            UUID id = entry.getKey();
            TurtleState state = entry.getValue();
            if (state.getRadius() < 0.0) {
                issues.add("Turtle " + String.valueOf(id) + " has negative radius: " + state.getRadius());
            }
            if (state.getFuelLevel() < 0) {
                issues.add("Turtle " + String.valueOf(id) + " has negative fuel: " + state.getFuelLevel());
            }
            if (state.getPosition() != null || !state.isActive()) continue;
            issues.add("Active turtle " + String.valueOf(id) + " has null position");
        }
        return issues;
    }

    public static class TurtleState {
        private double radius;
        private double fuelDebt;
        private class_1923 position;
        private int fuelLevel;
        private boolean wakeOnWorldLoad;
        private boolean randomTickEnabled;
        private class_5321<class_1937> worldKey;
        private Double pendingRadiusOverride;
        private Boolean pendingWakeOverride;
        private Integer computerId;
        private long lastSeenTimestamp;
        private Set<class_1923> loadedChunks = new HashSet<class_1923>();
        private boolean isActive = false;

        public TurtleState() {
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public TurtleState(ChunkLoaderPeripheral.SavedState savedState, Integer computerId, class_5321<class_1937> worldKey) {
            this();
            this.radius = savedState.radius;
            this.fuelDebt = savedState.fuelDebt;
            this.position = savedState.lastChunkPos;
            this.fuelLevel = savedState.fuelLevel;
            this.wakeOnWorldLoad = savedState.wakeOnWorldLoad;
            this.randomTickEnabled = savedState.randomTickEnabled;
            this.computerId = computerId;
            this.worldKey = worldKey;
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public double getRadius() {
            return this.radius;
        }

        public void setRadius(double radius) {
            this.radius = radius;
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public double getFuelDebt() {
            return this.fuelDebt;
        }

        public void setFuelDebt(double fuelDebt) {
            this.fuelDebt = fuelDebt;
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public class_1923 getPosition() {
            return this.position;
        }

        public void setPosition(class_1923 position) {
            this.position = position;
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public int getFuelLevel() {
            return this.fuelLevel;
        }

        public void setFuelLevel(int fuelLevel) {
            this.fuelLevel = fuelLevel;
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public boolean isWakeOnWorldLoad() {
            return this.wakeOnWorldLoad;
        }

        public void setWakeOnWorldLoad(boolean wakeOnWorldLoad) {
            this.wakeOnWorldLoad = wakeOnWorldLoad;
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public boolean isRandomTickEnabled() {
            return this.randomTickEnabled;
        }

        public void setRandomTickEnabled(boolean randomTickEnabled) {
            this.randomTickEnabled = randomTickEnabled;
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public class_5321<class_1937> getWorldKey() {
            return this.worldKey;
        }

        public void setWorldKey(class_5321<class_1937> worldKey) {
            this.worldKey = worldKey;
        }

        public Double getPendingRadiusOverride() {
            return this.pendingRadiusOverride;
        }

        public void setPendingRadiusOverride(Double pendingRadiusOverride) {
            this.pendingRadiusOverride = pendingRadiusOverride;
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public Boolean getPendingWakeOverride() {
            return this.pendingWakeOverride;
        }

        public void setPendingWakeOverride(Boolean pendingWakeOverride) {
            this.pendingWakeOverride = pendingWakeOverride;
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public Integer getComputerId() {
            return this.computerId;
        }

        public void setComputerId(Integer computerId) {
            this.computerId = computerId;
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public long getLastSeenTimestamp() {
            return this.lastSeenTimestamp;
        }

        public Set<class_1923> getLoadedChunks() {
            return new HashSet<class_1923>(this.loadedChunks);
        }

        public void setLoadedChunks(Set<class_1923> loadedChunks) {
            this.loadedChunks = new HashSet<class_1923>(loadedChunks);
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void setActive(boolean active) {
            this.isActive = active;
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public boolean hasPendingCommands() {
            return this.pendingRadiusOverride != null || this.pendingWakeOverride != null;
        }

        public double getEffectiveRadius() {
            return this.pendingRadiusOverride != null ? this.pendingRadiusOverride : this.radius;
        }

        public boolean getEffectiveWakeOnWorldLoad() {
            return this.pendingWakeOverride != null ? this.pendingWakeOverride : this.wakeOnWorldLoad;
        }

        public void clearRadiusOverride() {
            this.pendingRadiusOverride = null;
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public void clearWakeOverride() {
            this.pendingWakeOverride = null;
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public void updateFromPeripheralState(ChunkLoaderPeripheral.SavedState savedState) {
            this.radius = savedState.radius;
            this.fuelDebt = savedState.fuelDebt;
            this.position = savedState.lastChunkPos;
            this.fuelLevel = savedState.fuelLevel;
            this.wakeOnWorldLoad = savedState.wakeOnWorldLoad;
            this.randomTickEnabled = savedState.randomTickEnabled;
            this.lastSeenTimestamp = System.currentTimeMillis();
            LOGGER.debug("Updated turtle state from peripheral data - commands preserved: radiusOverride={}, wakeOverride={}", (Object)this.pendingRadiusOverride, (Object)this.pendingWakeOverride);
        }

        public ChunkManager.RemoteManagementState toRemoteManagementState() {
            return new ChunkManager.RemoteManagementState(this.position, this.fuelLevel, this.wakeOnWorldLoad, this.computerId, this.pendingRadiusOverride);
        }

        public String toString() {
            return String.format("TurtleState{radius=%.1f, position=%s, fuel=%d, active=%s, radiusOverride=%s, wakeOverride=%s, computerId=%d}", this.radius, this.position, this.fuelLevel, this.isActive, this.pendingRadiusOverride, this.pendingWakeOverride, this.computerId);
        }
    }
}

