/*
 * Decompiled with CFR 0.152.
 */
package ccchunkloader.niko.ink;

import ccchunkloader.niko.ink.ChunkLoaderPeripheral;
import ccchunkloader.niko.ink.TurtleCommandQueue;
import ccchunkloader.niko.ink.TurtleStateManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurtleStateEvents {
    private static final Logger LOGGER = LoggerFactory.getLogger(TurtleStateEvents.class);
    private final Map<Class<? extends TurtleEvent>, List<Consumer<? extends TurtleEvent>>> listeners = new ConcurrentHashMap<Class<? extends TurtleEvent>, List<Consumer<? extends TurtleEvent>>>();

    public <T extends TurtleEvent> void addEventListener(Class<T> eventType, Consumer<T> listener) {
        this.listeners.computeIfAbsent(eventType, k -> new CopyOnWriteArrayList()).add(listener);
        LOGGER.debug("Registered event listener for {}: {}", (Object)eventType.getSimpleName(), (Object)listener.getClass().getSimpleName());
    }

    public <T extends TurtleEvent> void fireEvent(T event) {
        List<Consumer<? extends TurtleEvent>> eventListeners = this.listeners.get(event.getClass());
        if (eventListeners != null && !eventListeners.isEmpty()) {
            LOGGER.debug("Firing event: {}", (Object)event.getDescription());
            for (Consumer<? extends TurtleEvent> listener : eventListeners) {
                try {
                    listener.accept(event);
                }
                catch (Exception e) {
                    LOGGER.error("Event listener failed for {}: {}", new Object[]{event.getClass().getSimpleName(), e.getMessage(), e});
                }
            }
        }
    }

    public <T extends TurtleEvent> void removeEventListener(Class<T> eventType, Consumer<T> listener) {
        List<Consumer<? extends TurtleEvent>> eventListeners = this.listeners.get(eventType);
        if (eventListeners != null) {
            eventListeners.remove(listener);
            LOGGER.debug("Removed event listener for {}", (Object)eventType.getSimpleName());
        }
    }

    public Map<String, Object> getStatistics() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        int totalListeners = this.listeners.values().stream().mapToInt(List::size).sum();
        stats.put("eventTypes", this.listeners.keySet().size());
        stats.put("totalListeners", totalListeners);
        HashMap<String, Integer> listenersByType = new HashMap<String, Integer>();
        for (Map.Entry<Class<? extends TurtleEvent>, List<Consumer<? extends TurtleEvent>>> entry : this.listeners.entrySet()) {
            listenersByType.put(entry.getKey().getSimpleName(), entry.getValue().size());
        }
        stats.put("listenersByType", listenersByType);
        return stats;
    }

    public static abstract class TurtleEvent {
        public final UUID turtleId;
        public final long timestamp;

        protected TurtleEvent(UUID turtleId) {
            this.turtleId = turtleId;
            this.timestamp = System.currentTimeMillis();
        }

        public abstract String getDescription();
    }

    public static class TurtleFuelExhaustedEvent
    extends TurtleEvent {
        public final double previousRadius;
        public final int fuelLevel;

        public TurtleFuelExhaustedEvent(UUID turtleId, double previousRadius, int fuelLevel) {
            super(turtleId);
            this.previousRadius = previousRadius;
            this.fuelLevel = fuelLevel;
        }

        @Override
        public String getDescription() {
            return String.format("Turtle %s fuel exhausted (was radius %.1f, fuel %d)", this.turtleId, this.previousRadius, this.fuelLevel);
        }
    }

    public static class TurtleMovedEvent
    extends TurtleEvent {
        public final class_1923 oldPosition;
        public final class_1923 newPosition;
        public final class_5321<class_1937> worldKey;

        public TurtleMovedEvent(UUID turtleId, class_1923 oldPosition, class_1923 newPosition, class_5321<class_1937> worldKey) {
            super(turtleId);
            this.oldPosition = oldPosition;
            this.newPosition = newPosition;
            this.worldKey = worldKey;
        }

        @Override
        public String getDescription() {
            return String.format("Turtle %s moved: %s -> %s", this.turtleId, this.oldPosition, this.newPosition);
        }
    }

    public static class CommandFailedEvent
    extends TurtleEvent {
        public final TurtleCommandQueue.TurtleCommand command;
        public final String errorMessage;
        public final boolean willRetry;

        public CommandFailedEvent(UUID turtleId, TurtleCommandQueue.TurtleCommand command, String errorMessage, boolean willRetry) {
            super(turtleId);
            this.command = command;
            this.errorMessage = errorMessage;
            this.willRetry = willRetry;
        }

        @Override
        public String getDescription() {
            return String.format("Command failed for turtle %s: %s - %s %s", this.turtleId, this.command.getDescription(), this.errorMessage, this.willRetry ? "(will retry)" : "(abandoned)");
        }
    }

    public static class CommandExecutedEvent
    extends TurtleEvent {
        public final TurtleCommandQueue.TurtleCommand command;
        public final TurtleStateManager.TurtleState resultingState;

        public CommandExecutedEvent(UUID turtleId, TurtleCommandQueue.TurtleCommand command, TurtleStateManager.TurtleState resultingState) {
            super(turtleId);
            this.command = command;
            this.resultingState = resultingState;
        }

        @Override
        public String getDescription() {
            return String.format("Command executed for turtle %s: %s", this.turtleId, this.command.getDescription());
        }
    }

    public static class CommandQueuedEvent
    extends TurtleEvent {
        public final TurtleCommandQueue.TurtleCommand command;
        public final String requestedBy;

        public CommandQueuedEvent(UUID turtleId, TurtleCommandQueue.TurtleCommand command, String requestedBy) {
            super(turtleId);
            this.command = command;
            this.requestedBy = requestedBy;
        }

        @Override
        public String getDescription() {
            return String.format("Command queued for turtle %s: %s (by %s)", this.turtleId, this.command.getDescription(), this.requestedBy);
        }
    }

    public static class TurtleStateChangedEvent
    extends TurtleEvent {
        public final TurtleStateManager.TurtleState oldState;
        public final TurtleStateManager.TurtleState newState;
        public final String changeType;

        public TurtleStateChangedEvent(UUID turtleId, TurtleStateManager.TurtleState oldState, TurtleStateManager.TurtleState newState, String changeType) {
            super(turtleId);
            this.oldState = oldState;
            this.newState = newState;
            this.changeType = changeType;
        }

        @Override
        public String getDescription() {
            return String.format("Turtle %s state changed: %s", this.turtleId, this.changeType);
        }
    }

    public static class TurtleUnloadedEvent
    extends TurtleEvent {
        public final TurtleStateManager.TurtleState lastState;
        public final String reason;

        public TurtleUnloadedEvent(UUID turtleId, TurtleStateManager.TurtleState lastState, String reason) {
            super(turtleId);
            this.lastState = lastState;
            this.reason = reason;
        }

        @Override
        public String getDescription() {
            return String.format("Turtle %s unloaded (%s)", this.turtleId, this.reason);
        }
    }

    public static class TurtleLoadedEvent
    extends TurtleEvent {
        public final ChunkLoaderPeripheral peripheral;
        public final TurtleStateManager.TurtleState state;

        public TurtleLoadedEvent(UUID turtleId, ChunkLoaderPeripheral peripheral, TurtleStateManager.TurtleState state) {
            super(turtleId);
            this.peripheral = peripheral;
            this.state = state;
        }

        @Override
        public String getDescription() {
            return String.format("Turtle %s loaded (radius: %.1f, fuel: %d)", this.turtleId, this.state.getRadius(), this.state.getFuelLevel());
        }
    }
}

