/*
 * Decompiled with CFR 0.152.
 */
package ccchunkloader.niko.ink;

import ccchunkloader.niko.ink.CCChunkloader;
import ccchunkloader.niko.ink.ChunkLoaderPeripheral;
import ccchunkloader.niko.ink.ChunkLoaderRegistry;
import ccchunkloader.niko.ink.TurtleStateManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurtleCommandQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(TurtleCommandQueue.class);
    private final Map<UUID, LatestCommandHolder> pendingCommands = new ConcurrentHashMap<UUID, LatestCommandHolder>();
    private static final long COMMAND_EXPIRY_MS = 2000L;

    public boolean queueCommand(UUID turtleId, TurtleCommand command, String requestedBy) {
        TurtleStateManager stateManager = CCChunkloader.getStateManager();
        TurtleStateManager.TurtleState state = stateManager.getState(turtleId);
        if (state != null && state.getFuelLevel() < command.getRequiredFuel()) {
            LOGGER.warn("Turtle {} has insufficient fuel ({} < {}) for command: {}", new Object[]{turtleId, state.getFuelLevel(), command.getRequiredFuel(), command.getDescription()});
            return false;
        }
        LatestCommandHolder previousCommand = this.pendingCommands.put(turtleId, new LatestCommandHolder(command, requestedBy));
        LOGGER.debug("Command queued: {} for turtle {}", (Object)command.getDescription(), (Object)turtleId);
        return true;
    }

    public synchronized boolean processLatestCommand(UUID turtleId, TurtleStateManager.TurtleState state) {
        LatestCommandHolder holder = this.pendingCommands.get(turtleId);
        if (holder == null) {
            return false;
        }
        if (holder.isExpired()) {
            this.pendingCommands.remove(turtleId);
            LOGGER.debug("Command expired: {} for turtle {} after {}ms", new Object[]{holder.command.getDescription(), turtleId, holder.ageMs()});
            return false;
        }
        if (holder.command.canExecute(state)) {
            try {
                holder.command.execute(turtleId, state);
                this.pendingCommands.remove(turtleId);
                LOGGER.info("Command executed: {} for turtle {}", (Object)holder.command.getDescription(), (Object)turtleId);
                return true;
            }
            catch (Exception e) {
                this.pendingCommands.remove(turtleId);
                LOGGER.error("Command failed: {} for turtle {} - {}", new Object[]{holder.command.getDescription(), turtleId, e.getMessage()});
                return false;
            }
        }
        LOGGER.debug("Command waiting: {} for turtle {} cannot execute yet", (Object)holder.command.getDescription(), (Object)turtleId);
        return false;
    }

    public int getPendingCommandCount(UUID turtleId) {
        LatestCommandHolder holder = this.pendingCommands.get(turtleId);
        return holder != null && !holder.isExpired() ? 1 : 0;
    }

    public String getPendingCommand(UUID turtleId) {
        LatestCommandHolder holder = this.pendingCommands.get(turtleId);
        if (holder == null) {
            return null;
        }
        return holder.command.getDescription() + (holder.isExpired() ? " [EXPIRED]" : "");
    }

    public void clearCommand(UUID turtleId) {
        LatestCommandHolder removed = this.pendingCommands.remove(turtleId);
        if (removed != null) {
            LOGGER.debug("Cleared pending command for turtle {}: {}", (Object)turtleId, (Object)removed.command.getDescription());
        }
    }

    public void removeTurtle(UUID turtleId) {
        LatestCommandHolder removed = this.pendingCommands.remove(turtleId);
        if (removed != null) {
            LOGGER.debug("Removed command data for turtle {}: {}", (Object)turtleId, (Object)removed.command.getDescription());
        }
    }

    public Map<String, Object> getStatistics() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        int totalCommands = 0;
        int expiredCommands = 0;
        for (LatestCommandHolder holder : this.pendingCommands.values()) {
            ++totalCommands;
            if (!holder.isExpired()) continue;
            ++expiredCommands;
        }
        stats.put("totalTurtles", this.pendingCommands.size());
        stats.put("totalPendingCommands", totalCommands);
        stats.put("expiredCommands", expiredCommands);
        stats.put("commandExpiryMs", 2000L);
        return stats;
    }

    public void performMaintenance() {
        int expiredCount = 0;
        Iterator<Map.Entry<UUID, LatestCommandHolder>> iterator = this.pendingCommands.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, LatestCommandHolder> entry = iterator.next();
            if (!entry.getValue().isExpired()) continue;
            iterator.remove();
            ++expiredCount;
        }
        if (expiredCount > 0) {
            LOGGER.debug("Maintenance: removed {} expired commands", (Object)expiredCount);
        }
    }

    public static interface TurtleCommand {
        public boolean canExecute(TurtleStateManager.TurtleState var1);

        public TurtleStateManager.TurtleState execute(UUID var1, TurtleStateManager.TurtleState var2);

        public String getDescription();

        public int getRequiredFuel();
    }

    private static class LatestCommandHolder {
        final TurtleCommand command;
        final long timestamp;
        final String requestedBy;

        LatestCommandHolder(TurtleCommand command, String requestedBy) {
            this.command = command;
            this.requestedBy = requestedBy;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 2000L;
        }

        long ageMs() {
            return System.currentTimeMillis() - this.timestamp;
        }
    }

    public static class SetWakeOnWorldLoadCommand
    implements TurtleCommand {
        private final boolean wakeEnabled;
        private final String requestedBy;

        public SetWakeOnWorldLoadCommand(boolean wakeEnabled, String requestedBy) {
            this.wakeEnabled = wakeEnabled;
            this.requestedBy = requestedBy;
        }

        @Override
        public boolean canExecute(TurtleStateManager.TurtleState state) {
            return true;
        }

        @Override
        public TurtleStateManager.TurtleState execute(UUID turtleId, TurtleStateManager.TurtleState state) {
            state.setWakeOnWorldLoad(this.wakeEnabled);
            state.clearWakeOverride();
            LOGGER.info("Executed SetWakeOnWorldLoadCommand: turtle {} wake set to {} (requested by {})", new Object[]{turtleId, this.wakeEnabled, this.requestedBy});
            return state;
        }

        @Override
        public String getDescription() {
            return String.format("SetWake(%s, by:%s)", this.wakeEnabled, this.requestedBy);
        }

        @Override
        public int getRequiredFuel() {
            return 0;
        }
    }

    public static class SetRadiusCommand
    implements TurtleCommand {
        private final double targetRadius;
        private final String requestedBy;

        public SetRadiusCommand(double targetRadius, String requestedBy) {
            this.targetRadius = targetRadius;
            this.requestedBy = requestedBy;
        }

        @Override
        public boolean canExecute(TurtleStateManager.TurtleState state) {
            if (this.targetRadius > 0.0 && state.getFuelLevel() < this.getRequiredFuel()) {
                return false;
            }
            return state.getPosition() != null;
        }

        @Override
        public TurtleStateManager.TurtleState execute(UUID turtleId, TurtleStateManager.TurtleState state) {
            ChunkLoaderPeripheral peripheral = ChunkLoaderRegistry.getPeripheral(turtleId);
            if (peripheral != null) {
                try {
                    peripheral.setRadius(this.targetRadius);
                    LOGGER.debug("Turtle {} radius set to {} via peripheral", (Object)turtleId, (Object)this.targetRadius);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to apply SetRadiusCommand to peripheral for turtle {}: {}", (Object)turtleId, (Object)e.getMessage());
                    throw new RuntimeException("Failed to apply radius change", e);
                }
            } else {
                LOGGER.debug("SetRadiusCommand applied to state only: turtle {} radius set to {} (requested by {})", new Object[]{turtleId, this.targetRadius, this.requestedBy});
            }
            state.setRadius(this.targetRadius);
            state.clearRadiusOverride();
            return state;
        }

        @Override
        public String getDescription() {
            return String.format("SetRadius(%.1f, by:%s)", this.targetRadius, this.requestedBy);
        }

        @Override
        public int getRequiredFuel() {
            return this.targetRadius > 0.0 ? 10 : 0;
        }
    }
}

