/*
 * Decompiled with CFR 0.152.
 */
package ccchunkloader.niko.ink;

import ccchunkloader.niko.ink.ChunkLoaderPeripheral;
import ccchunkloader.niko.ink.ChunkLoaderRegistry;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomTickOrchestrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomTickOrchestrator.class);
    private static final int MAX_CHUNKS_PER_WORLD_PER_TICK = 2048;
    private static final boolean DEBUG_LOGGING = false;
    private static RandomTickOrchestrator instance;

    private RandomTickOrchestrator() {
    }

    public static RandomTickOrchestrator getInstance() {
        if (instance == null) {
            instance = new RandomTickOrchestrator();
        }
        return instance;
    }

    public void initialize() {
        ServerTickEvents.END_WORLD_TICK.register(this::onWorldTick);
        LOGGER.info("RandomTickOrchestrator initialized with budget: {} chunks per world per tick", (Object)2048);
    }

    private void onWorldTick(class_3218 world) {
        int randomTickSpeed = world.method_8450().method_8356(class_1928.field_19399);
        if (randomTickSpeed <= 0) {
            return;
        }
        Map<UUID, ChunkLoaderPeripheral> allPeripherals = ChunkLoaderRegistry.getAllPeripherals();
        ArrayList<ChunkLoaderPeripheral> randomTickLoaders = new ArrayList<ChunkLoaderPeripheral>();
        for (ChunkLoaderPeripheral chunkLoaderPeripheral : allPeripherals.values()) {
            if (chunkLoaderPeripheral.getWorldKey() == null || !chunkLoaderPeripheral.getWorldKey().equals((Object)world.method_27983()) || !chunkLoaderPeripheral.isRandomTickEnabled()) continue;
            randomTickLoaders.add(chunkLoaderPeripheral);
        }
        if (randomTickLoaders.isEmpty()) {
            return;
        }
        ConcurrentHashMap.KeySetView allRandomTickChunks = ConcurrentHashMap.newKeySet();
        for (ChunkLoaderPeripheral chunkLoaderPeripheral : randomTickLoaders) {
            allRandomTickChunks.addAll(chunkLoaderPeripheral.getLoadedChunks());
        }
        if (allRandomTickChunks.isEmpty()) {
            return;
        }
        int n = Math.min(allRandomTickChunks.size(), 2048);
        class_1923[] class_1923Array = allRandomTickChunks.toArray(new class_1923[0]);
        for (int i = 0; i < n; ++i) {
            class_1923 chunkPos = class_1923Array[i];
            if (!world.method_8393(chunkPos.field_9181, chunkPos.field_9180)) continue;
            class_2818 chunk = world.method_8497(chunkPos.field_9181, chunkPos.field_9180);
            this.applyRandomTicksToChunk(world, chunk, randomTickSpeed);
        }
    }

    private void applyRandomTicksToChunk(class_3218 world, class_2818 chunk, int randomTickSpeed) {
        class_2826[] sections = chunk.method_12006();
        for (int sectionIndex = 0; sectionIndex < sections.length; ++sectionIndex) {
            class_2826 section = sections[sectionIndex];
            if (section == null || section.method_38292() || !section.method_12262()) continue;
            int sectionY = chunk.method_31604(sectionIndex);
            int baseY = sectionY << 4;
            for (int tick = 0; tick < randomTickSpeed; ++tick) {
                class_3610 fluidState;
                int localX = world.field_9229.method_43048(16);
                int localY = world.field_9229.method_43048(16);
                int localZ = world.field_9229.method_43048(16);
                int worldX = (chunk.method_12004().field_9181 << 4) + localX;
                int worldY = baseY + localY;
                int worldZ = (chunk.method_12004().field_9180 << 4) + localZ;
                class_2338 pos = new class_2338(worldX, worldY, worldZ);
                class_2680 blockState = section.method_12254(localX, localY, localZ);
                if (blockState.method_26229()) {
                    try {
                        blockState.method_26199(world, pos, world.field_9229);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!(fluidState = section.method_12255(localX, localY, localZ)).method_15773()) continue;
                try {
                    fluidState.method_15757((class_1937)world, pos, world.field_9229);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String getConfigInfo() {
        return String.format("RandomTickOrchestrator: max_chunks_per_world=%d, debug=%b", 2048, false);
    }
}

