/*
 * Decompiled with CFR 0.152.
 */
package ccchunkloader.niko.ink;

import ccchunkloader.niko.ink.ChunkLoaderPeripheral;
import ccchunkloader.niko.ink.ChunkLoaderRegistry;
import ccchunkloader.niko.ink.TurtleCommandQueue;
import ccchunkloader.niko.ink.TurtleStateEvents;
import ccchunkloader.niko.ink.TurtleStateManager;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultTurtleEventHandlers {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTurtleEventHandlers.class);
    private final TurtleStateManager stateManager;
    private final TurtleCommandQueue commandQueue;

    public DefaultTurtleEventHandlers(TurtleStateManager stateManager, TurtleCommandQueue commandQueue) {
        this.stateManager = stateManager;
        this.commandQueue = commandQueue;
    }

    public void registerDefaultHandlers(TurtleStateEvents eventSystem) {
        eventSystem.addEventListener(TurtleStateEvents.TurtleLoadedEvent.class, this::onTurtleLoaded);
        eventSystem.addEventListener(TurtleStateEvents.TurtleUnloadedEvent.class, this::onTurtleUnloaded);
        eventSystem.addEventListener(TurtleStateEvents.CommandQueuedEvent.class, this::onCommandQueued);
        eventSystem.addEventListener(TurtleStateEvents.TurtleStateChangedEvent.class, this::onStateChanged);
        eventSystem.addEventListener(TurtleStateEvents.TurtleMovedEvent.class, this::onTurtleMoved);
        eventSystem.addEventListener(TurtleStateEvents.TurtleFuelExhaustedEvent.class, this::onFuelExhausted);
        this.startPeriodicCommandProcessing();
        LOGGER.info("Registered default turtle event handlers with periodic command processing");
    }

    private void onTurtleLoaded(TurtleStateEvents.TurtleLoadedEvent event) {
        boolean processed;
        this.stateManager.setTurtleActive(event.turtleId, true);
        int pendingCount = this.commandQueue.getPendingCommandCount(event.turtleId);
        if (pendingCount > 0 && (processed = this.commandQueue.processLatestCommand(event.turtleId, event.state))) {
            LOGGER.debug("Turtle {} loaded and processed pending command", (Object)event.turtleId);
        }
        LOGGER.debug("Handled turtle loaded: {}", (Object)event.getDescription());
    }

    private void onTurtleUnloaded(TurtleStateEvents.TurtleUnloadedEvent event) {
        this.stateManager.setTurtleActive(event.turtleId, false);
        LOGGER.debug("Handled turtle unloaded: {}", (Object)event.getDescription());
    }

    private void onCommandQueued(TurtleStateEvents.CommandQueuedEvent event) {
        boolean processed;
        ChunkLoaderPeripheral peripheral = ChunkLoaderRegistry.getPeripheral(event.turtleId);
        TurtleStateManager.TurtleState state = this.stateManager.getState(event.turtleId);
        if (peripheral != null && state != null && !(processed = this.commandQueue.processLatestCommand(event.turtleId, state))) {
            LOGGER.debug("Command for turtle {} cannot execute immediately", (Object)event.turtleId);
        }
    }

    private void onStateChanged(TurtleStateEvents.TurtleStateChangedEvent event) {
        LOGGER.debug("Handled state changed: {}", (Object)event.getDescription());
    }

    private void onTurtleMoved(TurtleStateEvents.TurtleMovedEvent event) {
        TurtleStateManager.TurtleState state = this.stateManager.getState(event.turtleId);
        if (state != null) {
            state.setPosition(event.newPosition);
            LOGGER.debug("Updated turtle {} position: {} -> {}", new Object[]{event.turtleId, event.oldPosition, event.newPosition});
        }
    }

    private void onFuelExhausted(TurtleStateEvents.TurtleFuelExhaustedEvent event) {
        TurtleStateManager.TurtleState state = this.stateManager.getState(event.turtleId);
        if (state != null) {
            state.setRadius(0.0);
            LOGGER.info("Disabled chunk loading for turtle {} due to fuel exhaustion", (Object)event.turtleId);
        }
    }

    private void startPeriodicCommandProcessing() {
        Thread periodicProcessor = new Thread(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(10000L);
                    this.processStuckCommands();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("Error in periodic command processing: {}", (Object)e.getMessage());
                }
            }
        });
        periodicProcessor.setDaemon(true);
        periodicProcessor.setName("TurtleCommandProcessor");
        periodicProcessor.start();
        LOGGER.info("Started periodic command processing thread");
    }

    private void processStuckCommands() {
        try {
            Map<UUID, ChunkLoaderPeripheral> activePeripherals = ChunkLoaderRegistry.getAllPeripherals();
            int totalProcessed = 0;
            for (UUID turtleId : activePeripherals.keySet()) {
                boolean processed;
                TurtleStateManager.TurtleState state;
                int pendingCount = this.commandQueue.getPendingCommandCount(turtleId);
                if (pendingCount <= 0 || (state = this.stateManager.getState(turtleId)) == null || !(processed = this.commandQueue.processLatestCommand(turtleId, state))) continue;
                ++totalProcessed;
                LOGGER.debug("\ud83d\udd04 PERIODIC PROCESSING: Processed command for turtle {}", (Object)turtleId);
            }
            if (totalProcessed > 0) {
                LOGGER.debug("Periodic processing: {} commands processed", (Object)totalProcessed);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing stuck commands: {}", (Object)e.getMessage());
        }
    }
}

