/*
 * Decompiled with CFR 0.152.
 */
package ccchunkloader.niko.ink;

import ccchunkloader.niko.ink.CCChunkloader;
import ccchunkloader.niko.ink.ChunkLoaderPeripheral;
import ccchunkloader.niko.ink.ChunkLoaderRegistry;
import ccchunkloader.niko.ink.ChunkManager;
import ccchunkloader.niko.ink.Config;
import ccchunkloader.niko.ink.TurtleCommandQueue;
import ccchunkloader.niko.ink.TurtleStateEvents;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkloaderManagerPeripheral
implements IPeripheral {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkloaderManagerPeripheral.class);
    private static final String OFFLINE_TURTLE_MESSAGE = "Turtle is offline. To activate it, first use setTurtleRadius() with radius > 0, then try again.";
    private final class_1937 world;

    public ChunkloaderManagerPeripheral(class_1937 world) {
        this.world = world;
    }

    @NotNull
    public String getType() {
        return "chunkloader_manager";
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    @LuaFunction
    public final Map<String, Object> getTurtleInfo(String turtleIdString) throws LuaException {
        UUID turtleId = this.parseUUID(turtleIdString);
        ChunkLoaderPeripheral chunkLoader = ChunkLoaderRegistry.getPeripheral(turtleId);
        if (chunkLoader == null) {
            throw new LuaException(OFFLINE_TURTLE_MESSAGE);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("turtleId", chunkLoader.getTurtleId().toString());
        result.put("fuelLevel", chunkLoader.getFuelLevel());
        result.put("radius", chunkLoader.getRadius());
        result.put("loadedChunks", chunkLoader.getLoadedChunkCount());
        result.put("fuelRate", chunkLoader.calculateFuelCost());
        result.put("active", true);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @LuaFunction
    public final boolean setTurtleRadius(String turtleIdString, double radius) throws LuaException {
        if (radius < 0.0 || radius > Config.MAX_RADIUS) {
            throw new LuaException("Radius must be between 0.0 and " + Config.MAX_RADIUS);
        }
        turtleId = this.parseUUID(turtleIdString);
        if (!(this.world instanceof class_3218)) {
            throw new LuaException("Remote management only available on server");
        }
        commandQueue = CCChunkloader.getCommandQueue();
        eventSystem = CCChunkloader.getEventSystem();
        commandSource = "manager:" + turtleId.toString().substring(0, 8);
        command = new TurtleCommandQueue.SetRadiusCommand(radius, commandSource);
        queued = commandQueue.queueCommand(turtleId, command, commandSource);
        if (!queued) {
            throw new LuaException("Cannot set radius " + radius + " for turtle " + turtleIdString + " - insufficient fuel or invalid state");
        }
        ChunkloaderManagerPeripheral.LOGGER.debug("SetRadius({}) queued for turtle {} by {}", new Object[]{radius, turtleId, commandSource});
        chunkLoader = ChunkLoaderRegistry.getPeripheral(turtleId);
        if (chunkLoader != null || !((var12_10 = this.world) instanceof class_3218)) ** GOTO lbl-1000
        serverWorld = (class_3218)var12_10;
        if (radius > 0.0) {
            ChunkloaderManagerPeripheral.LOGGER.debug("Attempting bootstrap for dormant turtle {} (radius={})", (Object)turtleId, (Object)radius);
            manager = ChunkManager.get(serverWorld);
            result = manager.bootstrapTurtleOnDemand(turtleId);
            if (result.success) {
                ChunkloaderManagerPeripheral.LOGGER.debug("Turtle {} bootstrap successful", (Object)turtleId);
                chunkLoader = ChunkLoaderRegistry.getPeripheral(turtleId);
            } else {
                ChunkloaderManagerPeripheral.LOGGER.debug("Turtle {} bootstrap failed: {}", (Object)turtleId, (Object)result.errorCode);
            }
        } else if (chunkLoader == null) {
            throw new LuaException("Turtle is offline. To activate it, first use setTurtleRadius() with radius > 0, then try again.");
        }
        eventSystem.fireEvent(new TurtleStateEvents.CommandQueuedEvent(turtleId, command, commandSource));
        if (chunkLoader != null && radius > 0.0 && chunkLoader.getFuelLevel() == 0) {
            throw new LuaException("Warning: Turtle " + turtleIdString + " has no fuel. Command queued but may not execute immediately.");
        }
        return true;
    }

    @LuaFunction
    public final boolean setTurtleWakeOnWorldLoad(String turtleIdString, boolean wake) throws LuaException {
        UUID turtleId = this.parseUUID(turtleIdString);
        ChunkLoaderPeripheral chunkLoader = ChunkLoaderRegistry.getPeripheral(turtleId);
        if (chunkLoader == null) {
            throw new LuaException(OFFLINE_TURTLE_MESSAGE);
        }
        chunkLoader.setWakeOnWorldLoad(wake);
        return true;
    }

    @LuaFunction
    public final boolean getTurtleWakeOnWorldLoad(String turtleIdString) throws LuaException {
        UUID turtleId = this.parseUUID(turtleIdString);
        ChunkLoaderPeripheral chunkLoader = ChunkLoaderRegistry.getPeripheral(turtleId);
        if (chunkLoader == null) {
            throw new LuaException(OFFLINE_TURTLE_MESSAGE);
        }
        return chunkLoader.getWakeOnWorldLoad();
    }

    @LuaFunction
    public final String getTurtleDiagnostic(String turtleIdString) throws LuaException {
        UUID turtleId = this.parseUUID(turtleIdString);
        class_1937 class_19372 = this.world;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            return ChunkLoaderRegistry.getTurtleDiagnostic(turtleId, serverWorld);
        }
        return "Cannot get diagnostic - world is not ServerWorld";
    }

    private UUID parseUUID(String uuidString) throws LuaException {
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            throw new LuaException("Invalid turtle ID format: " + uuidString);
        }
    }
}

