/*
 * Decompiled with CFR 0.152.
 */
package ccchunkloader.niko.ink;

import ccchunkloader.niko.ink.ChunkLoaderRegistry;
import ccchunkloader.niko.ink.ChunkManager;
import ccchunkloader.niko.ink.Config;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class ChunkloaderCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ccchunkloader").requires(source -> source.method_9259(2))).executes(ctx -> {
            ChunkloaderCommand.showMainHelp((class_2168)ctx.getSource());
            return 1;
        })).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"help").executes(ctx -> {
            ChunkloaderCommand.showMainHelp((class_2168)ctx.getSource());
            return 1;
        })).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String command = StringArgumentType.getString((CommandContext)ctx, (String)"command");
            ChunkloaderCommand.showDetailedHelp((class_2168)ctx.getSource(), command);
            return 1;
        })))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            ChunkloaderCommand.showAllConfigValues((class_2168)ctx.getSource());
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").then(class_2170.method_9247((String)"uuids").executes(ctx -> {
            ChunkloaderCommand.showAllUUIDs((class_2168)ctx.getSource());
            return 1;
        }))).then(class_2170.method_9247((String)"computer").then(class_2170.method_9244((String)"computer_id", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String computerIdStr = StringArgumentType.getString((CommandContext)ctx, (String)"computer_id");
            try {
                int computerId = Integer.parseInt(computerIdStr);
                ChunkloaderCommand.showComputerUUIDs((class_2168)ctx.getSource(), computerId);
            }
            catch (NumberFormatException e) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Invalid computer ID: " + computerIdStr)));
            }
            return 1;
        })))).then(class_2170.method_9247((String)"validate").then(class_2170.method_9244((String)"computer_id", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String computerIdStr = StringArgumentType.getString((CommandContext)ctx, (String)"computer_id");
            try {
                int computerId = Integer.parseInt(computerIdStr);
                ChunkloaderCommand.validateComputer((class_2168)ctx.getSource(), computerId);
            }
            catch (NumberFormatException e) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Invalid computer ID: " + computerIdStr)));
            }
            return 1;
        })))).then(class_2170.method_9247((String)"orphans").executes(ctx -> {
            ChunkloaderCommand.showOrphanedUUIDs((class_2168)ctx.getSource());
            return 1;
        }))).then(class_2170.method_9247((String)"purge").then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String uuidStr = StringArgumentType.getString((CommandContext)ctx, (String)"uuid");
            try {
                UUID uuid = UUID.fromString(uuidStr);
                ChunkloaderCommand.purgeUUID((class_2168)ctx.getSource(), uuid);
            }
            catch (IllegalArgumentException e) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Invalid UUID format: " + uuidStr)));
            }
            return 1;
        })))).then(class_2170.method_9247((String)"states").executes(ctx -> {
            ChunkloaderCommand.showStateBreakdown((class_2168)ctx.getSource());
            return 1;
        }))).then(class_2170.method_9247((String)"stats").executes(ctx -> {
            ChunkloaderCommand.showTrackingStats((class_2168)ctx.getSource());
            return 1;
        })))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String key;
            switch (key = StringArgumentType.getString((CommandContext)ctx, (String)"key")) {
                case "MAX_RADIUS": {
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("MAX_RADIUS: " + Config.MAX_RADIUS)), false);
                    break;
                }
                case "MAX_RANDOM_TICK_RADIUS": {
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("MAX_RANDOM_TICK_RADIUS: " + Config.MAX_RANDOM_TICK_RADIUS)), false);
                    break;
                }
                case "BASE_FUEL_COST_PER_CHUNK": {
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("BASE_FUEL_COST_PER_CHUNK: " + Config.BASE_FUEL_COST_PER_CHUNK)), false);
                    break;
                }
                case "DISTANCE_MULTIPLIER": {
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("DISTANCE_MULTIPLIER: " + Config.DISTANCE_MULTIPLIER)), false);
                    break;
                }
                case "RANDOM_TICK_FUEL_MULTIPLIER": {
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("RANDOM_TICK_FUEL_MULTIPLIER: " + Config.RANDOM_TICK_FUEL_MULTIPLIER)), false);
                    break;
                }
                default: {
                    ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Unknown config key: " + key)));
                }
            }
            return 1;
        })))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
            String value = StringArgumentType.getString((CommandContext)ctx, (String)"value");
            try {
                switch (key) {
                    case "MAX_RADIUS": {
                        Config.MAX_RADIUS = Double.parseDouble(value);
                        break;
                    }
                    case "MAX_RANDOM_TICK_RADIUS": {
                        Config.MAX_RANDOM_TICK_RADIUS = Double.parseDouble(value);
                        break;
                    }
                    case "BASE_FUEL_COST_PER_CHUNK": {
                        Config.BASE_FUEL_COST_PER_CHUNK = Double.parseDouble(value);
                        break;
                    }
                    case "DISTANCE_MULTIPLIER": {
                        Config.DISTANCE_MULTIPLIER = Double.parseDouble(value);
                        break;
                    }
                    case "RANDOM_TICK_FUEL_MULTIPLIER": {
                        Config.RANDOM_TICK_FUEL_MULTIPLIER = Double.parseDouble(value);
                        break;
                    }
                    default: {
                        ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Unknown config key: " + key)));
                        return 0;
                    }
                }
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Set " + key + " to " + value)), true);
                return 1;
            }
            catch (NumberFormatException e) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Invalid value: " + value)));
                return 0;
            }
        }))));
        dispatcher.register(builder);
    }

    private static void showMainHelp(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== CC Chunk Loader Commands ==="), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e/ccchunkloader help \u00a77- Show this help"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e/ccchunkloader help <command> \u00a77- Detailed help for a command"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e/ccchunkloader list \u00a77- Show all config values"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e/ccchunkloader get <key> \u00a77- Get a config value"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e/ccchunkloader set <key> <value> \u00a77- Set a config value"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76Debug Commands:"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e/ccchunkloader debug uuids \u00a77- List all tracked UUIDs"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e/ccchunkloader debug computer <id> \u00a77- Show UUIDs for computer"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e/ccchunkloader debug states \u00a77- Show turtle state breakdown"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e/ccchunkloader debug stats \u00a77- Show tracking statistics"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77Use \u00a7e/ccchunkloader help <command> \u00a77for detailed info"), false);
    }

    private static void showDetailedHelp(class_2168 source, String command) {
        switch (command.toLowerCase()) {
            case "get": {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== /ccchunkloader get ==="), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77Get the current value of a config setting"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7eUsage: \u00a7f/ccchunkloader get <key>"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77Example: \u00a7f/ccchunkloader get MAX_RADIUS"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77Use \u00a7e/ccchunkloader list \u00a77to see all available keys"), false);
                break;
            }
            case "set": {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== /ccchunkloader set ==="), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77Set a config value (requires OP level 2)"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7eUsage: \u00a7f/ccchunkloader set <key> <value>"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77Examples:"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7f  /ccchunkloader set MAX_RADIUS 3.0"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7f  /ccchunkloader set BASE_FUEL_COST_PER_CHUNK 0.05"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7c\u26a0 Warning: Some settings affect all turtles immediately!"), false);
                break;
            }
            case "list": {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== /ccchunkloader list ==="), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77Shows all config keys and their current values"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7eUsage: \u00a7f/ccchunkloader list"), false);
                break;
            }
            case "debug": {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== /ccchunkloader debug ==="), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77Debug commands for UUID lifecycle management"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7eSubcommands:"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7f  uuids \u00a77- List all tracked UUIDs by computer"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7f  computer <id> \u00a77- Show UUIDs for specific computer"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7f  states \u00a77- Show turtle state breakdown (active/dormant/loaded)"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7f  orphans \u00a77- List UUIDs without computer mapping"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7f  purge <uuid> \u00a77- Force remove specific UUID"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7f  stats \u00a77- Show tracking statistics"), false);
                break;
            }
            default: {
                source.method_9226(() -> class_2561.method_43470((String)("\u00a7cUnknown command: " + command)), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77Available commands: \u00a7eget, set, list, debug, help"), false);
            }
        }
    }

    private static void showAllConfigValues(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== CC Chunk Loader Configuration ==="), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77General Settings:"), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7e  MAX_RADIUS: \u00a7f" + Config.MAX_RADIUS + " \u00a77(max chunk loading radius)")), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7e  MAX_RANDOM_TICK_RADIUS: \u00a7f" + Config.MAX_RANDOM_TICK_RADIUS + " \u00a77(max random tick radius)")), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77Fuel Cost Settings:"), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7e  BASE_FUEL_COST_PER_CHUNK: \u00a7f" + Config.BASE_FUEL_COST_PER_CHUNK + " \u00a77(fuel per chunk per tick)")), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7e  DISTANCE_MULTIPLIER: \u00a7f" + Config.DISTANCE_MULTIPLIER + " \u00a77(distance cost multiplier)")), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7e  RANDOM_TICK_FUEL_MULTIPLIER: \u00a7f" + Config.RANDOM_TICK_FUEL_MULTIPLIER + " \u00a77(random tick cost multiplier)")), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77Use \u00a7e/ccchunkloader set <key> <value> \u00a77to change values"), false);
    }

    private static void showAllUUIDs(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== All Tracked UUIDs ==="), false);
        if (!(source.method_9225() instanceof class_3218)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Command must be run in a server world"));
            return;
        }
        class_3218 serverWorld = source.method_9225();
        ChunkManager manager = ChunkManager.get(serverWorld);
        Set<Integer> computerIds = manager.getAllComputerIds();
        if (computerIds.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77No computers with tracked UUIDs"), false);
            return;
        }
        for (int computerId : computerIds) {
            Set<UUID> uuids = manager.getUUIDsForComputer(computerId);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7eComputer " + computerId + ": \u00a7f" + uuids.size() + " UUIDs")), false);
            for (UUID uuid : uuids) {
                boolean isActive = ChunkLoaderRegistry.isActive(uuid);
                boolean isChunkLoaded = manager.isTurtleChunkLoaded(uuid);
                String status = isActive ? (isChunkLoaded ? "\u00a7aACTIVE_LOADED" : "\u00a76ACTIVE_UNLOADED") : "\u00a77DORMANT";
                source.method_9226(() -> class_2561.method_43470((String)("  \u00a77" + String.valueOf(uuid) + " " + status)), false);
            }
        }
    }

    private static void showComputerUUIDs(class_2168 source, int computerId) {
        source.method_9226(() -> class_2561.method_43470((String)("\u00a76=== Computer " + computerId + " UUIDs ===")), false);
        if (!(source.method_9225() instanceof class_3218)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Command must be run in a server world"));
            return;
        }
        class_3218 serverWorld = source.method_9225();
        ChunkManager manager = ChunkManager.get(serverWorld);
        Set<UUID> uuids = manager.getUUIDsForComputer(computerId);
        if (uuids.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77No UUIDs tracked for computer " + computerId)), false);
            return;
        }
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77Found " + uuids.size() + " UUIDs:")), false);
        for (UUID uuid : uuids) {
            boolean isActive = ChunkLoaderRegistry.isActive(uuid);
            boolean isChunkLoaded = manager.isTurtleChunkLoaded(uuid);
            String status = isActive ? (isChunkLoaded ? "\u00a7aACTIVE_LOADED" : "\u00a76ACTIVE_UNLOADED") : "\u00a77DORMANT";
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7f" + String.valueOf(uuid) + " " + status)), false);
        }
    }

    private static void validateComputer(class_2168 source, int computerId) {
        source.method_9226(() -> class_2561.method_43470((String)("\u00a76=== Validating Computer " + computerId + " ===")), false);
        if (!(source.method_9225() instanceof class_3218)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Command must be run in a server world"));
            return;
        }
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77Manual validation is not safe - validation only occurs when turtle is loaded and active"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77UUIDs are automatically validated when chunkloader peripherals are created"), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77Use \u00a7e/ccchunkloader debug computer " + computerId + " \u00a77to see current UUIDs")), false);
    }

    private static void showOrphanedUUIDs(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== Orphaned UUIDs ==="), false);
        if (!(source.method_9225() instanceof class_3218)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Command must be run in a server world"));
            return;
        }
        class_3218 serverWorld = source.method_9225();
        ChunkManager manager = ChunkManager.get(serverWorld);
        Set<UUID> allTrackedUUIDs = manager.getRestoredTurtleIds();
        int orphanCount = 0;
        for (UUID uuid : allTrackedUUIDs) {
            Integer computerId = manager.getComputerIdForUUID(uuid);
            if (computerId != null) continue;
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7c" + String.valueOf(uuid) + " \u00a77(no computer ID mapping)")), false);
            ++orphanCount;
        }
        int finalOrphanCount = orphanCount;
        if (finalOrphanCount == 0) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77No orphaned UUIDs found"), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77Found " + finalOrphanCount + " orphaned UUIDs")), false);
        }
    }

    private static void purgeUUID(class_2168 source, UUID uuid) {
        source.method_9226(() -> class_2561.method_43470((String)("\u00a76=== Purging UUID " + String.valueOf(uuid) + " ===")), false);
        if (!(source.method_9225() instanceof class_3218)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Command must be run in a server world"));
            return;
        }
        class_3218 serverWorld = source.method_9225();
        ChunkManager manager = ChunkManager.get(serverWorld);
        Integer computerId = manager.getComputerIdForUUID(uuid);
        boolean isTracked = manager.getRestoredTurtleIds().contains(uuid);
        boolean isActive = ChunkLoaderRegistry.isActive(uuid);
        if (!isTracked) {
            source.method_9213((class_2561)class_2561.method_43470((String)("UUID " + String.valueOf(uuid) + " is not tracked")));
            return;
        }
        if (isActive) {
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7cWARNING: UUID " + String.valueOf(uuid) + " is currently ACTIVE!")), false);
        }
        ChunkManager.permanentlyRemoveTurtleFromWorld(serverWorld, uuid);
        ChunkLoaderRegistry.permanentlyRemoveTurtle(uuid);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7aPurged UUID " + String.valueOf(uuid) + " from computer " + computerId)), false);
    }

    private static void showStateBreakdown(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== Turtle State Breakdown ==="), false);
        if (!(source.method_9225() instanceof class_3218)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Command must be run in a server world"));
            return;
        }
        class_3218 serverWorld = source.method_9225();
        ChunkManager manager = ChunkManager.get(serverWorld);
        Set<UUID> allTrackedUUIDs = manager.getRestoredTurtleIds();
        if (allTrackedUUIDs.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77No tracked turtles"), false);
            return;
        }
        int activeLoadedCount = 0;
        int activeUnloadedCount = 0;
        int dormantCount = 0;
        for (UUID uuid : allTrackedUUIDs) {
            boolean isActive = ChunkLoaderRegistry.isActive(uuid);
            boolean isChunkLoaded = manager.isTurtleChunkLoaded(uuid);
            if (isActive) {
                if (isChunkLoaded) {
                    ++activeLoadedCount;
                    continue;
                }
                ++activeUnloadedCount;
                continue;
            }
            ++dormantCount;
        }
        int finalActiveLoadedCount = activeLoadedCount;
        int finalActiveUnloadedCount = activeUnloadedCount;
        int finalDormantCount = dormantCount;
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77Total Turtles: \u00a7f" + allTrackedUUIDs.size())), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7a  ACTIVE_LOADED: \u00a7f" + finalActiveLoadedCount + " \u00a77(peripheral exists, chunk loaded)")), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a76  ACTIVE_UNLOADED: \u00a7f" + finalActiveUnloadedCount + " \u00a77(peripheral exists, chunk unloaded)")), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77  DORMANT: \u00a7f" + finalDormantCount + " \u00a77(no peripheral, chunk unloaded)")), false);
        if (finalActiveUnloadedCount > 0) {
            source.method_9226(() -> class_2561.method_43470((String)""), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7c\u26a0 " + finalActiveUnloadedCount + " turtles are candidates for garbage collection")), false);
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77(Active peripherals in unloaded chunks could be cleaned up)"), false);
        }
    }

    private static void showTrackingStats(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== UUID Tracking Statistics ==="), false);
        if (!(source.method_9225() instanceof class_3218)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Command must be run in a server world"));
            return;
        }
        class_3218 serverWorld = source.method_9225();
        ChunkManager manager = ChunkManager.get(serverWorld);
        Map<String, Object> stats = manager.getComputerIdStats();
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77Total Computers: \u00a7f" + String.valueOf(stats.get("totalComputers")))), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77Total UUIDs: \u00a7f" + String.valueOf(stats.get("totalUUIDs")))), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77Orphaned UUIDs: \u00a7f" + String.valueOf(stats.get("orphanedUUIDs")))), false);
        int activeCount = ChunkLoaderRegistry.getAllPeripherals().size();
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77Active Peripherals: \u00a7f" + activeCount)), false);
        Set<UUID> allTrackedUUIDs = manager.getRestoredTurtleIds();
        int activeLoadedCount = 0;
        int activeUnloadedCount = 0;
        int dormantCount = 0;
        for (UUID uuid : allTrackedUUIDs) {
            boolean isActive = ChunkLoaderRegistry.isActive(uuid);
            boolean isChunkLoaded = manager.isTurtleChunkLoaded(uuid);
            if (isActive) {
                if (isChunkLoaded) {
                    ++activeLoadedCount;
                    continue;
                }
                ++activeUnloadedCount;
                continue;
            }
            ++dormantCount;
        }
        int finalActiveLoadedCount2 = activeLoadedCount;
        int finalActiveUnloadedCount2 = activeUnloadedCount;
        int finalDormantCount2 = dormantCount;
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76Load State Breakdown:"), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7a  Active + Loaded: \u00a7f" + finalActiveLoadedCount2)), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a76  Active + Unloaded: \u00a7f" + finalActiveUnloadedCount2)), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77  Dormant: \u00a7f" + finalDormantCount2)), false);
    }
}

