/*
 * Decompiled with CFR 0.152.
 */
package ccchunkloader.niko.ink;

import ccchunkloader.niko.ink.CCChunkloader;
import ccchunkloader.niko.ink.ChunkLoaderPeripheral;
import ccchunkloader.niko.ink.ChunkLoaderRegistry;
import ccchunkloader.niko.ink.ChunkManagerPersistentState;
import ccchunkloader.niko.ink.TurtleStateManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkManager.class);
    private static final Map<class_3218, ChunkManager> MANAGERS = new ConcurrentHashMap<class_3218, ChunkManager>();
    private final Map<class_1923, Set<UUID>> chunkLoaders = new ConcurrentHashMap<class_1923, Set<UUID>>();
    private final Map<UUID, Set<class_1923>> turtleChunks = new ConcurrentHashMap<UUID, Set<class_1923>>();
    private final Map<UUID, RemoteManagementState> remoteManagementStates = new ConcurrentHashMap<UUID, RemoteManagementState>();
    private final Map<UUID, ChunkLoaderPeripheral.SavedState> restoredTurtleStates = new ConcurrentHashMap<UUID, ChunkLoaderPeripheral.SavedState>();
    private final ComputerUUIDTracker computerTracker = new ComputerUUIDTracker();
    private final class_3218 world;
    private boolean bootstrapped = false;

    private ChunkManager(class_3218 world) {
        this.world = world;
        LOGGER.debug("Created new ChunkManager for world: {}", (Object)world.method_27983().method_29177());
    }

    public static ChunkManager get(class_3218 world) {
        ChunkManager manager = MANAGERS.computeIfAbsent(world, ChunkManager::new);
        manager.bootstrapTurtles();
        return manager;
    }

    public static void forceBootstrap(class_3218 world) {
        ChunkManager manager = MANAGERS.get(world);
        if (manager != null) {
            manager.forceBootstrapTurtles();
        }
    }

    private void forceBootstrapTurtles() {
        LOGGER.info("Force-bootstrapping turtles for world {}", (Object)this.world.method_27983().method_29177());
        Map<UUID, BootstrapData> turtlesToBootstrap = this.getTurtlesToBootstrap((class_5321<class_1937>)this.world.method_27983());
        LOGGER.info("Found {} turtles in bootstrap registry for force-bootstrap in world {}", (Object)turtlesToBootstrap.size(), (Object)this.world.method_27983().method_29177());
        if (turtlesToBootstrap.isEmpty()) {
            LOGGER.info("No turtles to force-bootstrap for world {}", (Object)this.world.method_27983().method_29177());
            return;
        }
        for (Map.Entry<UUID, BootstrapData> entry : turtlesToBootstrap.entrySet()) {
            UUID turtleId = entry.getKey();
            BootstrapData data = entry.getValue();
            LOGGER.info("Force-processing bootstrap data for turtle {}: chunk={}, fuel={}, wake={}", new Object[]{turtleId, data.chunkPos, data.lastKnownFuelLevel, data.wakeOnWorldLoad});
            if (data.lastKnownFuelLevel <= 0 || !data.wakeOnWorldLoad) continue;
            this.world.method_17988(data.chunkPos.field_9181, data.chunkPos.field_9180, true);
            LOGGER.info("FORCE-LOADED chunk {} to bootstrap turtle {} (fuel: {}) [FORCE-BOOTSTRAP]", new Object[]{data.chunkPos, turtleId, data.lastKnownFuelLevel});
        }
        LOGGER.info("Force-bootstrap process completed for world {}", (Object)this.world.method_27983().method_29177());
    }

    private void bootstrapTurtles() {
        if (this.bootstrapped) {
            LOGGER.debug("ChunkManager for world {} already bootstrapped, skipping", (Object)this.world.method_27983().method_29177());
            return;
        }
        this.bootstrapped = true;
        LOGGER.info("Starting bootstrap process for world {}", (Object)this.world.method_27983().method_29177());
        Map<UUID, BootstrapData> turtlesToBootstrap = this.getTurtlesToBootstrap((class_5321<class_1937>)this.world.method_27983());
        LOGGER.info("Found {} turtles in bootstrap registry for world {}", (Object)turtlesToBootstrap.size(), (Object)this.world.method_27983().method_29177());
        if (turtlesToBootstrap.isEmpty()) {
            LOGGER.info("No turtles to bootstrap for world {}", (Object)this.world.method_27983().method_29177());
            return;
        }
        LOGGER.info("Bootstrapping {} turtles with wake-on-world-load enabled for world {}", (Object)turtlesToBootstrap.size(), (Object)this.world.method_27983().method_29177());
        for (Map.Entry<UUID, BootstrapData> entry : turtlesToBootstrap.entrySet()) {
            UUID turtleId = entry.getKey();
            BootstrapData data = entry.getValue();
            LOGGER.info("Processing bootstrap data for turtle {}: chunk={}, fuel={}, wake={}", new Object[]{turtleId, data.chunkPos, data.lastKnownFuelLevel, data.wakeOnWorldLoad});
            if (data.lastKnownFuelLevel > 0 && data.wakeOnWorldLoad) {
                this.world.method_17988(data.chunkPos.field_9181, data.chunkPos.field_9180, true);
                LOGGER.info("FORCE-LOADED chunk {} to bootstrap turtle {} (fuel: {})", new Object[]{data.chunkPos, turtleId, data.lastKnownFuelLevel});
                continue;
            }
            LOGGER.info("Skipping bootstrap for turtle {}: fuel={}, wake={}", new Object[]{turtleId, data.lastKnownFuelLevel, data.wakeOnWorldLoad});
        }
        LOGGER.info("Bootstrap process completed for world {}", (Object)this.world.method_27983().method_29177());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChunksFromSet(UUID turtleId, Set<class_1923> newChunks) {
        ConcurrentHashMap.KeySetView chunksToUnload;
        ConcurrentHashMap.KeySetView chunksToLoad;
        LOGGER.debug("Adding {} chunks for turtle {}", (Object)newChunks.size(), (Object)turtleId);
        Iterator iterator = this;
        synchronized (iterator) {
            Set<class_1923> oldChunks = this.turtleChunks.get(turtleId);
            chunksToLoad = ConcurrentHashMap.newKeySet();
            for (class_1923 chunkPos : newChunks) {
                Set loaders = this.chunkLoaders.computeIfAbsent(chunkPos, k -> ConcurrentHashMap.newKeySet());
                loaders.add(turtleId);
                if (loaders.size() != 1) continue;
                chunksToLoad.add(chunkPos);
            }
            chunksToUnload = ConcurrentHashMap.newKeySet();
            if (oldChunks != null) {
                for (class_1923 oldChunk : oldChunks) {
                    if (newChunks.contains(oldChunk)) continue;
                    chunksToUnload.add(oldChunk);
                }
            }
            this.turtleChunks.put(turtleId, Set.copyOf(newChunks));
            this.touch(turtleId);
        }
        for (class_1923 chunkPos : chunksToLoad) {
            this.world.method_17988(chunkPos.field_9181, chunkPos.field_9180, true);
            LOGGER.debug("Force loaded chunk {} for turtle {}", (Object)chunkPos, (Object)turtleId);
        }
        for (class_1923 oldChunk : chunksToUnload) {
            this.removeChunkLoader(turtleId, oldChunk);
        }
        LOGGER.debug("Completed chunk update for turtle {}: +{} -{}", new Object[]{turtleId, chunksToLoad.size(), chunksToUnload.size()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllChunks(UUID turtleId) {
        Set<class_1923> chunks;
        ChunkManager chunkManager = this;
        synchronized (chunkManager) {
            chunks = this.turtleChunks.get(turtleId);
            if (chunks != null) {
                this.turtleChunks.put(turtleId, ConcurrentHashMap.newKeySet());
                chunks = Set.copyOf(chunks);
            }
        }
        if (chunks != null) {
            for (class_1923 chunk : chunks) {
                this.removeChunkLoader(turtleId, chunk);
            }
        }
        LOGGER.debug("Removed {} chunks for turtle {} (turtle tracking preserved)", (Object)(chunks != null ? chunks.size() : 0), (Object)turtleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChunkLoader(UUID turtleId, class_1923 chunk) {
        boolean shouldUnforce;
        ChunkManager chunkManager = this;
        synchronized (chunkManager) {
            Set<UUID> loaders = this.chunkLoaders.get(chunk);
            if (loaders == null) {
                return;
            }
            loaders.remove(turtleId);
            if (loaders.isEmpty()) {
                this.chunkLoaders.remove(chunk);
                shouldUnforce = true;
            } else {
                shouldUnforce = false;
            }
        }
        if (shouldUnforce) {
            this.world.method_17988(chunk.field_9181, chunk.field_9180, false);
            LOGGER.debug("Unforced chunk {} (no more loaders)", (Object)chunk);
        }
    }

    public boolean isTurtleTracked(UUID turtleId) {
        return this.turtleChunks.containsKey(turtleId);
    }

    public void touch(UUID turtleId) {
        if (!this.turtleChunks.containsKey(turtleId)) {
            this.turtleChunks.put(turtleId, ConcurrentHashMap.newKeySet());
            LOGGER.debug("Added turtle {} to turtleChunks tracking with empty chunk set", (Object)turtleId);
        }
    }

    public void updateRemoteManagementState(UUID turtleId, class_1923 position, int fuelLevel, boolean wakeOnWorldLoad, Integer computerId) {
        RemoteManagementState current = this.remoteManagementStates.get(turtleId);
        Double existingOverride = current != null ? current.radiusOverride : null;
        RemoteManagementState newState = new RemoteManagementState(position, fuelLevel, wakeOnWorldLoad, computerId, existingOverride);
        this.remoteManagementStates.put(turtleId, newState);
        this.touch(turtleId);
        LOGGER.debug("Updated remote management state for turtle {}: pos={}, fuel={}, wake={}, computerId={}, override={}", new Object[]{turtleId, position, fuelLevel, wakeOnWorldLoad, computerId, existingOverride});
    }

    public void updateTurtlePosition(UUID turtleId, class_1923 position) {
        RemoteManagementState current = this.remoteManagementStates.get(turtleId);
        if (current != null) {
            this.updateRemoteManagementState(turtleId, position, current.lastKnownFuel, current.wakeOnWorldLoad, current.computerId);
        } else {
            this.updateRemoteManagementState(turtleId, position, 1, false, null);
        }
    }

    public void updateTurtleFuel(UUID turtleId, int fuelLevel) {
        RemoteManagementState current = this.remoteManagementStates.get(turtleId);
        if (current != null) {
            this.updateRemoteManagementState(turtleId, current.lastKnownPosition, fuelLevel, current.wakeOnWorldLoad, current.computerId);
        } else {
            this.updateRemoteManagementState(turtleId, null, fuelLevel, false, null);
        }
    }

    public class_1923 getPersistentPosition(UUID turtleId) {
        RemoteManagementState state = this.remoteManagementStates.get(turtleId);
        return state != null ? state.lastKnownPosition : null;
    }

    public Integer getPersistentFuelLevel(UUID turtleId) {
        RemoteManagementState state = this.remoteManagementStates.get(turtleId);
        return state != null ? Integer.valueOf(state.lastKnownFuel) : null;
    }

    public void setRadiusOverride(UUID turtleId, double radius) {
        TurtleStateManager stateManager = CCChunkloader.getStateManager();
        stateManager.setRadiusOverride(turtleId, radius);
        LOGGER.info("Set radius override via new architecture: {} -> {} (bug-free!)", (Object)turtleId, (Object)radius);
        this.markDirty();
    }

    public Double getAndClearRadiusOverride(UUID turtleId) {
        TurtleStateManager stateManager = CCChunkloader.getStateManager();
        Double override = stateManager.getRadiusOverride(turtleId);
        if (override != null) {
            stateManager.clearRadiusOverride(turtleId);
            LOGGER.info("Retrieved and cleared radius override via new architecture: {} -> {}", (Object)turtleId, (Object)override);
            this.markDirty();
        }
        return override;
    }

    public Double getRadiusOverride(UUID turtleId) {
        TurtleStateManager stateManager = CCChunkloader.getStateManager();
        return stateManager.getRadiusOverride(turtleId);
    }

    public void clearRadiusOverride(UUID turtleId) {
        TurtleStateManager stateManager = CCChunkloader.getStateManager();
        if (stateManager.hasRadiusOverride(turtleId)) {
            stateManager.clearRadiusOverride(turtleId);
            LOGGER.info("Cleared radius override via new architecture: {}", (Object)turtleId);
            this.markDirty();
        }
    }

    public boolean hasRadiusOverride(UUID turtleId) {
        TurtleStateManager stateManager = CCChunkloader.getStateManager();
        return stateManager.hasRadiusOverride(turtleId);
    }

    private void markDirty() {
        ChunkManagerPersistentState.getWorldState(this.world).method_80();
    }

    public synchronized void updateTurtleStateCache(UUID turtleId, ChunkLoaderPeripheral.SavedState state) {
        TurtleStateManager stateManager = CCChunkloader.getStateManager();
        if (state != null) {
            RemoteManagementState current = this.remoteManagementStates.get(turtleId);
            Integer computerId = current != null ? current.computerId : null;
            stateManager.updateFromPeripheral(turtleId, state, computerId, (class_5321<class_1937>)this.world.method_27983());
            LOGGER.debug("Updated turtle cache via new state manager: {} (preserves all pending commands!)", (Object)turtleId);
        } else {
            stateManager.removeTurtle(turtleId);
            LOGGER.debug("Removed turtle via new state manager: {}", (Object)turtleId);
        }
    }

    public synchronized ChunkLoaderPeripheral.SavedState getCachedTurtleState(UUID turtleId) {
        RemoteManagementState state = this.remoteManagementStates.get(turtleId);
        return state != null ? state.toSavedState() : null;
    }

    public synchronized void removeTurtleFromCache(UUID turtleId) {
        this.remoteManagementStates.remove(turtleId);
        LOGGER.debug("Removed turtle {} from state cache", (Object)turtleId);
    }

    public int getLoadedChunkCount(UUID turtleId) {
        Set<class_1923> chunks = this.turtleChunks.get(turtleId);
        return chunks != null ? chunks.size() : 0;
    }

    public boolean hasLoadedChunks(UUID turtleId) {
        return this.turtleChunks.containsKey(turtleId) && !this.turtleChunks.get(turtleId).isEmpty();
    }

    public Set<class_1923> getLoadedChunks(UUID turtleId) {
        Set<class_1923> chunks = this.turtleChunks.get(turtleId);
        return chunks != null ? Set.copyOf(chunks) : Set.of();
    }

    public boolean isTurtleChunkLoaded(UUID turtleId) {
        RemoteManagementState state = this.remoteManagementStates.get(turtleId);
        if (state == null || state.lastKnownPosition == null) {
            return false;
        }
        return this.world.method_8393(state.lastKnownPosition.field_9181, state.lastKnownPosition.field_9180);
    }

    public int getTotalLoadedChunks() {
        return this.chunkLoaders.size();
    }

    public int getActiveTurtleCount() {
        return this.turtleChunks.size();
    }

    public synchronized Set<UUID> getRestoredTurtleIds() {
        return Set.copyOf(this.turtleChunks.keySet());
    }

    public synchronized ChunkLoaderPeripheral.SavedState getRestoredTurtleState(UUID turtleId) {
        return this.restoredTurtleStates.get(turtleId);
    }

    public synchronized Map<UUID, ChunkLoaderPeripheral.SavedState> getAllRestoredTurtleStates() {
        return Map.copyOf(this.restoredTurtleStates);
    }

    public synchronized class_1923 getRestoredTurtlePosition(UUID turtleId) {
        ChunkLoaderPeripheral.SavedState state = this.restoredTurtleStates.get(turtleId);
        return state != null ? state.lastChunkPos : null;
    }

    public synchronized Map<UUID, class_1923> getAllRestoredTurtlePositions() {
        HashMap<UUID, class_1923> positions = new HashMap<UUID, class_1923>();
        for (Map.Entry<UUID, ChunkLoaderPeripheral.SavedState> entry : this.restoredTurtleStates.entrySet()) {
            if (entry.getValue().lastChunkPos == null) continue;
            positions.put(entry.getKey(), entry.getValue().lastChunkPos);
        }
        return positions;
    }

    public synchronized boolean getRestoredWakePreference(UUID turtleId) {
        ChunkLoaderPeripheral.SavedState state = this.restoredTurtleStates.get(turtleId);
        return state != null ? state.wakeOnWorldLoad : false;
    }

    public synchronized Map<UUID, Boolean> getAllRestoredWakePreferences() {
        HashMap<UUID, Boolean> wakePrefs = new HashMap<UUID, Boolean>();
        for (Map.Entry<UUID, ChunkLoaderPeripheral.SavedState> entry : this.restoredTurtleStates.entrySet()) {
            wakePrefs.put(entry.getKey(), entry.getValue().wakeOnWorldLoad);
        }
        return wakePrefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Set<class_1923> chunksToUnforce;
        ChunkManager chunkManager = this;
        synchronized (chunkManager) {
            chunksToUnforce = Set.copyOf(this.chunkLoaders.keySet());
            this.chunkLoaders.clear();
            for (UUID turtleId : this.turtleChunks.keySet()) {
                this.turtleChunks.put(turtleId, ConcurrentHashMap.newKeySet());
            }
        }
        for (class_1923 chunk : chunksToUnforce) {
            this.world.method_17988(chunk.field_9181, chunk.field_9180, false);
        }
        LOGGER.info("Emergency cleanup: cleared {} chunk loaders for world {} (turtle data preserved)", (Object)chunksToUnforce.size(), (Object)this.world.method_27983().method_29177());
    }

    public static void cleanupWorld(class_3218 world) {
        ChunkManager manager = MANAGERS.remove(world);
        if (manager != null) {
            manager.clearAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void permanentlyRemoveTurtle(UUID turtleId) {
        LOGGER.info("PERMANENTLY removing turtle {} from all tracking", (Object)turtleId);
        this.removeAllChunks(turtleId);
        ChunkManager chunkManager = this;
        synchronized (chunkManager) {
            this.turtleChunks.remove(turtleId);
            this.remoteManagementStates.remove(turtleId);
            Integer computerId = this.computerTracker.getComputerForUUID(turtleId);
            if (computerId != null) {
                this.computerTracker.remove(turtleId);
                LOGGER.debug("Removed UUID {} from computer ID {} tracking", (Object)turtleId, (Object)computerId);
            }
        }
        LOGGER.info("Turtle {} permanently removed from ChunkManager", (Object)turtleId);
    }

    public static void permanentlyRemoveTurtleFromWorld(class_3218 world, UUID turtleId) {
        ChunkManager manager = MANAGERS.get(world);
        if (manager != null) {
            manager.permanentlyRemoveTurtle(turtleId);
        }
    }

    public synchronized Map<UUID, BootstrapData> getTurtlesToBootstrap(class_5321<class_1937> worldKey) {
        HashMap<UUID, BootstrapData> toBootstrap = new HashMap<UUID, BootstrapData>();
        for (Map.Entry<UUID, RemoteManagementState> entry : this.remoteManagementStates.entrySet()) {
            UUID turtleId = entry.getKey();
            RemoteManagementState state = entry.getValue();
            if (!state.wakeOnWorldLoad || state.lastKnownFuel <= 0 || state.lastKnownPosition == null) continue;
            BootstrapData bootstrapData = new BootstrapData(worldKey, state.lastKnownPosition, state.lastKnownFuel, state.wakeOnWorldLoad);
            toBootstrap.put(turtleId, bootstrapData);
        }
        return toBootstrap;
    }

    public static void cleanupAll() {
        for (ChunkManager manager : MANAGERS.values()) {
            manager.clearAll();
        }
        MANAGERS.clear();
    }

    public synchronized class_2487 serializeToNbt() {
        class_2487 nbt = new class_2487();
        class_2499 turtleStates = new class_2499();
        for (UUID turtleId : this.turtleChunks.keySet()) {
            Integer computerId;
            ChunkLoaderPeripheral chunkLoader;
            class_1923 lastPosition = null;
            int fuelLevel = -1;
            boolean wakeOnWorldLoad = false;
            boolean isActive = false;
            RemoteManagementState remoteState = this.remoteManagementStates.get(turtleId);
            if (remoteState != null) {
                lastPosition = remoteState.lastKnownPosition;
                fuelLevel = remoteState.lastKnownFuel;
                wakeOnWorldLoad = remoteState.wakeOnWorldLoad;
            }
            if ((chunkLoader = ChunkLoaderRegistry.getPeripheral(turtleId)) != null) {
                ChunkLoaderPeripheral.SavedState state = chunkLoader.getSavedState();
                if (state != null) {
                    wakeOnWorldLoad = state.wakeOnWorldLoad;
                    isActive = true;
                    computerId = remoteState != null ? remoteState.computerId : this.computerTracker.getComputerForUUID(turtleId);
                    this.updateRemoteManagementState(turtleId, state.lastChunkPos, state.fuelLevel, state.wakeOnWorldLoad, computerId);
                    if (state.lastChunkPos != null) {
                        lastPosition = state.lastChunkPos;
                    }
                    fuelLevel = state.fuelLevel;
                    wakeOnWorldLoad = state.wakeOnWorldLoad;
                }
            } else if (remoteState != null) {
                LOGGER.debug("Using remote management state for dormant turtle {}", (Object)turtleId);
            } else {
                LOGGER.debug("No state data available for dormant turtle {}", (Object)turtleId);
            }
            if (lastPosition == null) {
                LOGGER.error("CRITICAL: Turtle {} has no position data even in persistent tracking! This should never happen. Skipping serialization.", (Object)turtleId);
                continue;
            }
            if (fuelLevel < 0) {
                LOGGER.error("CRITICAL: Turtle {} has no fuel data even in persistent tracking! Defaulting to fuel=1 to prevent data loss.", (Object)turtleId);
                fuelLevel = 1;
            }
            class_2487 stateData = new class_2487();
            stateData.method_10582("uuid", turtleId.toString());
            stateData.method_10569("lastChunkX", lastPosition.field_9181);
            stateData.method_10569("lastChunkZ", lastPosition.field_9180);
            stateData.method_10569("fuelLevel", fuelLevel);
            stateData.method_10556("wakeOnWorldLoad", wakeOnWorldLoad);
            computerId = this.computerTracker.getComputerForUUID(turtleId);
            if (computerId != null) {
                stateData.method_10569("computerId", computerId.intValue());
            }
            turtleStates.add((Object)stateData);
            LOGGER.debug("Serialized essential data for turtle {}: active={}, pos=({},{}), fuel={}, wake={}", new Object[]{turtleId, isActive, lastPosition.field_9181, lastPosition.field_9180, fuelLevel, wakeOnWorldLoad});
        }
        nbt.method_10566("turtleStates", (class_2520)turtleStates);
        LOGGER.info("Serialized {} turtle bootstrap records to NBT ({} tracked turtles)", (Object)turtleStates.size(), (Object)this.turtleChunks.size());
        return nbt;
    }

    public synchronized DeserializationResult deserializeFromNbt(class_2487 nbt) {
        this.chunkLoaders.clear();
        this.turtleChunks.clear();
        this.computerTracker.clear();
        if (nbt.method_10545("turtleStates")) {
            class_2499 turtleStatesNbt = nbt.method_10554("turtleStates", 10);
            for (int i = 0; i < turtleStatesNbt.size(); ++i) {
                class_2487 stateData = turtleStatesNbt.method_10602(i);
                try {
                    UUID turtleId = UUID.fromString(stateData.method_10558("uuid"));
                    class_1923 lastChunkPos = null;
                    int fuelLevel = -1;
                    boolean wakeOnWorldLoad = false;
                    if (stateData.method_10545("lastChunkX") && stateData.method_10545("lastChunkZ")) {
                        lastChunkPos = new class_1923(stateData.method_10550("lastChunkX"), stateData.method_10550("lastChunkZ"));
                    }
                    if (stateData.method_10545("fuelLevel")) {
                        fuelLevel = stateData.method_10550("fuelLevel");
                    }
                    if (stateData.method_10545("wakeOnWorldLoad")) {
                        wakeOnWorldLoad = stateData.method_10577("wakeOnWorldLoad");
                    }
                    ChunkLoaderPeripheral.SavedState bootstrapState = new ChunkLoaderPeripheral.SavedState(0.0, lastChunkPos, 0.0, wakeOnWorldLoad, false, fuelLevel);
                    this.turtleChunks.put(turtleId, ConcurrentHashMap.newKeySet());
                    this.restoredTurtleStates.put(turtleId, bootstrapState);
                    Integer computerIdForState = null;
                    if (stateData.method_10545("computerId")) {
                        computerIdForState = stateData.method_10550("computerId");
                    }
                    this.updateRemoteManagementState(turtleId, lastChunkPos, fuelLevel >= 0 ? fuelLevel : 1, wakeOnWorldLoad, computerIdForState);
                    if (stateData.method_10545("computerId")) {
                        int computerIdFromNbt = stateData.method_10550("computerId");
                        this.computerTracker.register(computerIdFromNbt, turtleId);
                        LOGGER.debug("Restored computer ID mapping: UUID {} -> Computer {}", (Object)turtleId, (Object)computerIdFromNbt);
                    }
                    LOGGER.debug("Restored turtle bootstrap data {}: pos=({},{}), fuel={}, wake={}", new Object[]{turtleId, lastChunkPos != null ? Integer.valueOf(lastChunkPos.field_9181) : "null", lastChunkPos != null ? Integer.valueOf(lastChunkPos.field_9180) : "null", fuelLevel, wakeOnWorldLoad});
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to restore turtle bootstrap data from NBT.", (Throwable)e);
                }
            }
        }
        int totalCount = this.restoredTurtleStates.size();
        int toWakeCount = (int)this.restoredTurtleStates.values().stream().filter(state -> state.wakeOnWorldLoad).count();
        LOGGER.info("Deserialized {} turtle bootstrap records from NBT ({} to wake on world load)", (Object)totalCount, (Object)toWakeCount);
        LOGGER.info("Restored computer ID mappings for {} computers with {} total UUIDs", (Object)this.computerTracker.getAllComputerIds().size(), this.computerTracker.getStats().get("totalUUIDs"));
        return new DeserializationResult(totalCount, toWakeCount);
    }

    public synchronized BootstrapResult bootstrapTurtleOnDemand(UUID turtleId) {
        Double pendingOverride;
        LOGGER.info("Attempting on-demand bootstrap for turtle {}", (Object)turtleId);
        if (ChunkLoaderRegistry.getPeripheral(turtleId) != null) {
            LOGGER.debug("Turtle {} is already active, no bootstrap needed", (Object)turtleId);
            return BootstrapResult.alreadyActive();
        }
        boolean inTurtleChunks = this.turtleChunks.containsKey(turtleId);
        boolean inRemoteState = this.remoteManagementStates.containsKey(turtleId);
        boolean inRestoredStates = this.restoredTurtleStates.containsKey(turtleId);
        LOGGER.info("Turtle {} tracking status: chunks={}, remote={}, restored={}", new Object[]{turtleId, inTurtleChunks, inRemoteState, inRestoredStates});
        ChunkLoaderPeripheral.SavedState cachedState = this.getCachedTurtleState(turtleId);
        if (cachedState == null) {
            LOGGER.info("No cached state available for turtle {}", (Object)turtleId);
        }
        if (cachedState == null) {
            LOGGER.warn("Cannot bootstrap turtle {} - no cached state available (chunks={}, remote={})", new Object[]{turtleId, inTurtleChunks, inRemoteState});
            return BootstrapResult.noData();
        }
        if (cachedState.lastChunkPos == null) {
            LOGGER.warn("Cannot bootstrap turtle {} - no position available. State: radius={}, fuel={}, wake={}", new Object[]{turtleId, cachedState.radius, cachedState.fuelLevel, cachedState.wakeOnWorldLoad});
            return BootstrapResult.noData();
        }
        LOGGER.info("Bootstrapping turtle {} at chunk {} with {} fuel", new Object[]{turtleId, cachedState.lastChunkPos, cachedState.fuelLevel});
        Set<class_1923> bootstrapChunk = Set.of(cachedState.lastChunkPos);
        this.addChunksFromSet(turtleId, bootstrapChunk);
        LOGGER.info("Bootstrap: Added chunk {} for turtle {} via ChunkManager", (Object)cachedState.lastChunkPos, (Object)turtleId);
        int MAX_WAIT_TICKS = 20;
        int TICK_DELAY_MS = 50;
        for (int i = 0; i < 20; ++i) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            ChunkLoaderPeripheral peripheral = ChunkLoaderRegistry.getPeripheral(turtleId);
            if (peripheral == null) continue;
            LOGGER.info("Successfully bootstrapped turtle {} after {}ms", (Object)turtleId, (Object)(i * 50));
            Double expectedOverride = this.getRadiusOverride(turtleId);
            if (expectedOverride != null) {
                double currentRadius = peripheral.getRadius();
                if (Math.abs(currentRadius - expectedOverride) < 0.001) {
                    LOGGER.info("Bootstrap confirmed: turtle {} has expected radius {} from override", (Object)turtleId, (Object)expectedOverride);
                } else {
                    LOGGER.debug("Bootstrap: turtle {} found but radius {} doesn't match override {} yet", new Object[]{turtleId, currentRadius, expectedOverride});
                }
            }
            this.removeAllChunks(turtleId);
            LOGGER.debug("Bootstrap cleanup: Removed bootstrap chunks for turtle {} - turtle will take over chunk management", (Object)turtleId);
            return BootstrapResult.success();
        }
        if ((pendingOverride = this.getRadiusOverride(turtleId)) != null) {
            LOGGER.info("Bootstrap timeout for turtle {} but override {} is still pending - considering success", (Object)turtleId, (Object)pendingOverride);
            this.removeAllChunks(turtleId);
            LOGGER.debug("Bootstrap cleanup (pending override): Removed bootstrap chunks for turtle {}", (Object)turtleId);
            return BootstrapResult.success();
        }
        LOGGER.info("Bootstrap timeout for turtle {} - peripheral not available after {}ms (turtle may still be loading)", (Object)turtleId, (Object)1000);
        this.removeAllChunks(turtleId);
        LOGGER.debug("Bootstrap timeout cleanup: Removed bootstrap chunks for turtle {}", (Object)turtleId);
        return BootstrapResult.timeout();
    }

    public void wakeTurtlesOnLoad() {
        int restoredCount = this.remoteManagementStates.size();
        if (restoredCount == 0) {
            return;
        }
        long turtlesToWake = this.remoteManagementStates.values().stream().filter(state -> state.wakeOnWorldLoad).count();
        if (turtlesToWake == 0L) {
            LOGGER.info("No restored turtles marked to wake on load.");
            return;
        }
        LOGGER.info("Attempting to wake {}/{} restored turtles that have opted-in...", (Object)turtlesToWake, (Object)restoredCount);
        for (Map.Entry<UUID, RemoteManagementState> entry : this.remoteManagementStates.entrySet()) {
            UUID turtleId = entry.getKey();
            RemoteManagementState state2 = entry.getValue();
            ChunkLoaderPeripheral.SavedState savedState = state2.toSavedState();
            if (!savedState.wakeOnWorldLoad) continue;
            if (savedState.fuelLevel == 0) {
                LOGGER.warn("Skipping wake for opt-in turtle {} because it has no fuel.", (Object)turtleId);
                continue;
            }
            if (savedState.lastChunkPos != null) {
                LOGGER.info("Turtle {} available for bootstrap wakeup", (Object)turtleId);
                continue;
            }
            LOGGER.warn("Cannot bootstrap turtle {} - no last known position", (Object)turtleId);
        }
    }

    public void registerUUIDForComputer(int computerId, UUID turtleId) {
        this.computerTracker.register(computerId, turtleId);
        LOGGER.debug("Registered UUID {} for computer ID {}", (Object)turtleId, (Object)computerId);
    }

    public Set<UUID> getUUIDsForComputer(int computerId) {
        return this.computerTracker.getUUIDsForComputer(computerId);
    }

    public Integer getComputerIdForUUID(UUID turtleId) {
        return this.computerTracker.getComputerForUUID(turtleId);
    }

    public void validateUUIDsForComputer(int computerId, Set<UUID> currentlyEquippedUUIDs) {
        Set<UUID> orphanedUUIDs = this.computerTracker.validateAndCleanup(computerId, currentlyEquippedUUIDs);
        for (UUID orphanedUUID : orphanedUUIDs) {
            LOGGER.info("Removing orphaned UUID {} from computer {} (no longer equipped)", (Object)orphanedUUID, (Object)computerId);
            this.permanentlyRemoveTurtle(orphanedUUID);
        }
    }

    public Set<Integer> getAllComputerIds() {
        return this.computerTracker.getAllComputerIds();
    }

    public Map<String, Object> getComputerIdStats() {
        return this.computerTracker.getStats();
    }

    public static class ComputerUUIDTracker {
        private final Map<Integer, Set<UUID>> computerToUUIDs = new ConcurrentHashMap<Integer, Set<UUID>>();
        private final Map<UUID, Integer> uuidToComputer = new ConcurrentHashMap<UUID, Integer>();

        public synchronized void register(int computerId, UUID uuid) {
            this.computerToUUIDs.computeIfAbsent(computerId, k -> ConcurrentHashMap.newKeySet()).add(uuid);
            this.uuidToComputer.put(uuid, computerId);
        }

        public synchronized void remove(UUID uuid) {
            Set<UUID> computerUUIDs;
            Integer computerId = this.uuidToComputer.remove(uuid);
            if (computerId != null && (computerUUIDs = this.computerToUUIDs.get(computerId)) != null) {
                computerUUIDs.remove(uuid);
                if (computerUUIDs.isEmpty()) {
                    this.computerToUUIDs.remove(computerId);
                }
            }
        }

        public Set<UUID> getUUIDsForComputer(int computerId) {
            return Set.copyOf(this.computerToUUIDs.getOrDefault(computerId, Set.of()));
        }

        public Integer getComputerForUUID(UUID uuid) {
            return this.uuidToComputer.get(uuid);
        }

        public Set<Integer> getAllComputerIds() {
            return Set.copyOf(this.computerToUUIDs.keySet());
        }

        public synchronized Set<UUID> validateAndCleanup(int computerId, Set<UUID> currentlyEquippedUUIDs) {
            Set<UUID> storedUUIDs = this.computerToUUIDs.get(computerId);
            if (storedUUIDs == null) {
                return Set.of();
            }
            HashSet<UUID> toRemove = new HashSet<UUID>(storedUUIDs);
            toRemove.removeAll(currentlyEquippedUUIDs);
            for (UUID orphanedUUID : toRemove) {
                this.remove(orphanedUUID);
            }
            return toRemove;
        }

        public synchronized Map<String, Object> getStats() {
            HashMap<String, Object> stats = new HashMap<String, Object>();
            stats.put("totalComputers", this.computerToUUIDs.size());
            stats.put("totalUUIDs", this.uuidToComputer.size());
            stats.put("orphanedUUIDs", this.uuidToComputer.size() - this.computerToUUIDs.values().stream().mapToInt(Set::size).sum());
            return stats;
        }

        public synchronized void clear() {
            this.computerToUUIDs.clear();
            this.uuidToComputer.clear();
        }
    }

    public static class BootstrapData {
        public final class_5321<class_1937> worldKey;
        public final class_1923 chunkPos;
        public final int lastKnownFuelLevel;
        public final boolean wakeOnWorldLoad;

        public BootstrapData(class_5321<class_1937> worldKey, class_1923 chunkPos, int fuelLevel, boolean wakeOnWorldLoad) {
            this.worldKey = worldKey;
            this.chunkPos = chunkPos;
            this.lastKnownFuelLevel = fuelLevel;
            this.wakeOnWorldLoad = wakeOnWorldLoad;
        }
    }

    public static class RemoteManagementState {
        public final class_1923 lastKnownPosition;
        public final int lastKnownFuel;
        public final boolean wakeOnWorldLoad;
        public final Integer computerId;
        public final Double radiusOverride;

        public RemoteManagementState(class_1923 lastKnownPosition, int lastKnownFuel, boolean wakeOnWorldLoad, Integer computerId, Double radiusOverride) {
            this.lastKnownPosition = lastKnownPosition;
            this.lastKnownFuel = lastKnownFuel;
            this.wakeOnWorldLoad = wakeOnWorldLoad;
            this.computerId = computerId;
            this.radiusOverride = radiusOverride;
        }

        public RemoteManagementState(class_1923 lastKnownPosition, int lastKnownFuel, boolean wakeOnWorldLoad, Integer computerId) {
            this(lastKnownPosition, lastKnownFuel, wakeOnWorldLoad, computerId, null);
        }

        public static RemoteManagementState fromSavedState(ChunkLoaderPeripheral.SavedState savedState, Integer computerId) {
            return new RemoteManagementState(savedState.lastChunkPos, savedState.fuelLevel, savedState.wakeOnWorldLoad, computerId, null);
        }

        public ChunkLoaderPeripheral.SavedState toSavedState() {
            return new ChunkLoaderPeripheral.SavedState(0.0, this.lastKnownPosition, 0.0, this.wakeOnWorldLoad, false, this.lastKnownFuel);
        }
    }

    public static class DeserializationResult {
        public final int total;
        public final int toWake;

        public DeserializationResult(int total, int toWake) {
            this.total = total;
            this.toWake = toWake;
        }
    }

    public static class BootstrapResult {
        public final boolean success;
        public final String errorCode;
        public final String message;

        public BootstrapResult(boolean success, String errorCode, String message) {
            this.success = success;
            this.errorCode = errorCode;
            this.message = message;
        }

        public static BootstrapResult success() {
            return new BootstrapResult(true, "SUCCESS", "Turtle successfully bootstrapped");
        }

        public static BootstrapResult alreadyActive() {
            return new BootstrapResult(true, "ALREADY_ACTIVE", "Turtle is already active");
        }

        public static BootstrapResult noData() {
            return new BootstrapResult(false, "NO_DATA", "No cached data available for turtle");
        }

        public static BootstrapResult timeout() {
            return new BootstrapResult(false, "TIMEOUT", "Bootstrap timed out - turtle may still be loading");
        }
    }
}

